/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.x509;

import com.tencent.kona.sun.security.util.Debug;
import com.tencent.kona.sun.security.util.DerOutputStream;
import com.tencent.kona.sun.security.util.DerValue;
import com.tencent.kona.sun.security.util.ObjectIdentifier;
import com.tencent.kona.sun.security.x509.Extension;
import com.tencent.kona.sun.security.x509.PKIXExtensions;
import java.io.IOException;
import java.math.BigInteger;

public class CRLNumberExtension
extends Extension {
    public static final String NAME = "CRLNumber";
    private static final String LABEL = "CRL Number";
    private BigInteger crlNumber;
    private final String extensionName;
    private final String extensionLabel;

    private void encodeThis() {
        if (this.crlNumber == null) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream os = new DerOutputStream();
        os.putInteger(this.crlNumber);
        this.extensionValue = os.toByteArray();
    }

    public CRLNumberExtension(int crlNum) {
        this(PKIXExtensions.CRLNumber_Id, false, BigInteger.valueOf(crlNum), NAME, LABEL);
    }

    public CRLNumberExtension(BigInteger crlNum) {
        this(PKIXExtensions.CRLNumber_Id, false, crlNum, NAME, LABEL);
    }

    protected CRLNumberExtension(ObjectIdentifier extensionId, boolean isCritical, BigInteger crlNum, String extensionName, String extensionLabel) {
        if (crlNum == null) {
            throw new IllegalArgumentException("CRL number cannot be null");
        }
        this.extensionId = extensionId;
        this.critical = isCritical;
        this.crlNumber = crlNum;
        this.extensionName = extensionName;
        this.extensionLabel = extensionLabel;
        this.encodeThis();
    }

    public CRLNumberExtension(Boolean critical, Object value) throws IOException {
        this(PKIXExtensions.CRLNumber_Id, critical, value, NAME, LABEL);
    }

    protected CRLNumberExtension(ObjectIdentifier extensionId, Boolean critical, Object value, String extensionName, String extensionLabel) throws IOException {
        this.extensionId = extensionId;
        this.critical = critical;
        this.extensionValue = (byte[])value;
        DerValue val = new DerValue(this.extensionValue);
        this.crlNumber = val.getBigInteger();
        this.extensionName = extensionName;
        this.extensionLabel = extensionLabel;
    }

    public BigInteger getCrlNumber() {
        return this.crlNumber;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append(this.extensionLabel).append(": ");
        if (this.crlNumber != null) {
            sb.append(Debug.toHexString(this.crlNumber));
        }
        sb.append('\n');
        return sb.toString();
    }

    @Override
    public void encode(DerOutputStream out) {
        this.encode(out, PKIXExtensions.CRLNumber_Id, true);
    }

    protected void encode(DerOutputStream out, ObjectIdentifier extensionId, boolean isCritical) {
        if (this.extensionValue == null) {
            this.extensionId = extensionId;
            this.critical = isCritical;
            this.encodeThis();
        }
        super.encode(out);
    }

    @Override
    public String getName() {
        return this.extensionName;
    }
}

