/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.x509;

import com.tencent.kona.sun.security.util.DerOutputStream;
import com.tencent.kona.sun.security.util.DerValue;
import com.tencent.kona.sun.security.x509.Extension;
import com.tencent.kona.sun.security.x509.PKIXExtensions;
import java.io.IOException;
import java.security.cert.CRLReason;

public class CRLReasonCodeExtension
extends Extension {
    public static final String NAME = "CRLReasonCode";
    private static final CRLReason[] values = CRLReason.values();
    private int reasonCode;

    private void encodeThis() {
        if (this.reasonCode == 0) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream dos = new DerOutputStream();
        dos.putEnumerated(this.reasonCode);
        this.extensionValue = dos.toByteArray();
    }

    public CRLReasonCodeExtension(int reason) throws IOException {
        this(false, reason);
    }

    public CRLReasonCodeExtension(boolean critical, int reason) {
        if (reason <= 0) {
            throw new IllegalArgumentException("reason code must be positive");
        }
        this.extensionId = PKIXExtensions.ReasonCode_Id;
        this.critical = critical;
        this.reasonCode = reason;
        this.encodeThis();
    }

    public CRLReasonCodeExtension(Boolean critical, Object value) throws IOException {
        this.extensionId = PKIXExtensions.ReasonCode_Id;
        this.critical = critical;
        this.extensionValue = (byte[])value;
        DerValue val = new DerValue(this.extensionValue);
        this.reasonCode = val.getEnumerated();
    }

    @Override
    public String toString() {
        return super.toString() + "    Reason Code: " + (Object)((Object)this.getReasonCode());
    }

    @Override
    public void encode(DerOutputStream out) {
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.ReasonCode_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(out);
    }

    @Override
    public String getName() {
        return NAME;
    }

    public int getReason() {
        return this.reasonCode;
    }

    public CRLReason getReasonCode() {
        if (this.reasonCode > 0 && this.reasonCode < values.length) {
            return values[this.reasonCode];
        }
        return CRLReason.UNSPECIFIED;
    }
}

