/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.x509;

import com.tencent.kona.sun.security.util.DerEncoder;
import com.tencent.kona.sun.security.util.DerInputStream;
import com.tencent.kona.sun.security.util.DerOutputStream;
import com.tencent.kona.sun.security.util.DerValue;
import com.tencent.kona.sun.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.InputStream;

public class CertificateAlgorithmId
implements DerEncoder {
    private AlgorithmId algId;
    public static final String NAME = "algorithmID";
    public static final String ALGORITHM = "algorithm";

    public CertificateAlgorithmId(AlgorithmId algId) {
        this.algId = algId;
    }

    public CertificateAlgorithmId(DerInputStream in) throws IOException {
        DerValue val = in.getDerValue();
        this.algId = AlgorithmId.parse(val);
    }

    public CertificateAlgorithmId(InputStream in) throws IOException {
        DerValue val = new DerValue(in);
        this.algId = AlgorithmId.parse(val);
    }

    public String toString() {
        if (this.algId == null) {
            return "";
        }
        return this.algId.toString() + ", OID = " + this.algId.getOID().toString() + "\n";
    }

    @Override
    public void encode(DerOutputStream out) {
        this.algId.encode(out);
    }

    public AlgorithmId getAlgId() throws IOException {
        return this.algId;
    }
}

