/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.x509;

import com.tencent.kona.sun.security.util.DerOutputStream;
import com.tencent.kona.sun.security.util.DerValue;
import com.tencent.kona.sun.security.x509.Extension;
import com.tencent.kona.sun.security.x509.GeneralNames;
import com.tencent.kona.sun.security.x509.PKIXExtensions;
import java.io.IOException;

public class CertificateIssuerExtension
extends Extension {
    public static final String NAME = "CertificateIssuer";
    private GeneralNames names;

    private void encodeThis() {
        if (this.names == null || this.names.isEmpty()) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream os = new DerOutputStream();
        this.names.encode(os);
        this.extensionValue = os.toByteArray();
    }

    public CertificateIssuerExtension(GeneralNames issuer) {
        if (issuer == null || issuer.isEmpty()) {
            throw new IllegalArgumentException("issuer cannot be null or empty");
        }
        this.extensionId = PKIXExtensions.CertificateIssuer_Id;
        this.critical = true;
        this.names = issuer;
        this.encodeThis();
    }

    public CertificateIssuerExtension(Boolean critical, Object value) throws IOException {
        this.extensionId = PKIXExtensions.CertificateIssuer_Id;
        this.critical = critical;
        this.extensionValue = (byte[])value;
        DerValue val = new DerValue(this.extensionValue);
        this.names = new GeneralNames(val);
    }

    public GeneralNames getNames() {
        return this.names;
    }

    @Override
    public String toString() {
        return super.toString() + "Certificate Issuer [\n" + this.names + "]\n";
    }

    @Override
    public void encode(DerOutputStream out) {
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.CertificateIssuer_Id;
            this.critical = true;
            this.encodeThis();
        }
        super.encode(out);
    }

    @Override
    public String getName() {
        return NAME;
    }
}

