/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.x509;

import com.tencent.kona.sun.security.util.DerEncoder;
import com.tencent.kona.sun.security.util.DerInputStream;
import com.tencent.kona.sun.security.util.DerOutputStream;
import com.tencent.kona.sun.security.util.DerValue;
import com.tencent.kona.sun.security.x509.X509Key;
import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;

public class CertificateX509Key
implements DerEncoder {
    public static final String NAME = "key";
    private PublicKey key;

    public CertificateX509Key(PublicKey key) {
        this.key = key;
    }

    public CertificateX509Key(DerInputStream in) throws IOException {
        DerValue val = in.getDerValue();
        this.key = X509Key.parse(val);
    }

    public CertificateX509Key(InputStream in) throws IOException {
        DerValue val = new DerValue(in);
        this.key = X509Key.parse(val);
    }

    public String toString() {
        if (this.key == null) {
            return "";
        }
        return this.key.toString();
    }

    @Override
    public void encode(DerOutputStream out) {
        byte[] bytes = this.key.getEncoded();
        out.write(bytes, 0, bytes.length);
    }

    public PublicKey getKey() {
        return this.key;
    }
}

