/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.x509;

import com.tencent.kona.sun.security.util.DerEncoder;
import com.tencent.kona.sun.security.util.DerOutputStream;
import com.tencent.kona.sun.security.util.DerValue;
import com.tencent.kona.sun.security.x509.GeneralName;
import java.io.IOException;
import java.util.Objects;

public class GeneralSubtree
implements DerEncoder {
    private static final byte TAG_MIN = 0;
    private static final byte TAG_MAX = 1;
    private static final int MIN_DEFAULT = 0;
    private final GeneralName name;
    private int minimum = 0;
    private int maximum = -1;
    private int myhash = -1;

    public GeneralSubtree(GeneralName name, int min, int max) {
        this.name = Objects.requireNonNull(name);
        this.minimum = min;
        this.maximum = max;
    }

    public GeneralSubtree(DerValue val) throws IOException {
        if (val.tag != 48) {
            throw new IOException("Invalid encoding for GeneralSubtree.");
        }
        this.name = new GeneralName(val.data.getDerValue(), true);
        while (val.data.available() != 0) {
            DerValue opt = val.data.getDerValue();
            if (opt.isContextSpecific((byte)0) && !opt.isConstructed()) {
                opt.resetTag((byte)2);
                this.minimum = opt.getInteger();
                continue;
            }
            if (opt.isContextSpecific((byte)1) && !opt.isConstructed()) {
                opt.resetTag((byte)2);
                this.maximum = opt.getInteger();
                continue;
            }
            throw new IOException("Invalid encoding of GeneralSubtree.");
        }
    }

    public GeneralName getName() {
        return this.name;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n   GeneralSubtree: [").append("\n    GeneralName: ");
        if (this.name != null) {
            sb.append(this.name);
        }
        sb.append("\n    Minimum: ").append(this.minimum).append("\n    Maximum: ");
        if (this.maximum == -1) {
            sb.append("undefined");
        } else {
            sb.append(this.maximum);
        }
        sb.append("    ]\n");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GeneralSubtree)) {
            return false;
        }
        return Objects.equals(this.name, ((GeneralSubtree)obj).name) && this.minimum == ((GeneralSubtree)obj).minimum && this.maximum == ((GeneralSubtree)obj).maximum;
    }

    public int hashCode() {
        if (this.myhash == -1) {
            this.myhash = 17;
            if (this.name != null) {
                this.myhash = 37 * this.myhash + this.name.hashCode();
            }
            if (this.minimum != 0) {
                this.myhash = 37 * this.myhash + this.minimum;
            }
            if (this.maximum != -1) {
                this.myhash = 37 * this.myhash + this.maximum;
            }
        }
        return this.myhash;
    }

    @Override
    public void encode(DerOutputStream out) {
        DerOutputStream tmp;
        DerOutputStream seq = new DerOutputStream();
        this.name.encode(seq);
        if (this.minimum != 0) {
            tmp = new DerOutputStream();
            tmp.putInteger(this.minimum);
            seq.writeImplicit(DerValue.createTag((byte)-128, false, (byte)0), tmp);
        }
        if (this.maximum != -1) {
            tmp = new DerOutputStream();
            tmp.putInteger(this.maximum);
            seq.writeImplicit(DerValue.createTag((byte)-128, false, (byte)1), tmp);
        }
        out.write((byte)48, seq);
    }
}

