/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.x509;

import com.tencent.kona.sun.security.util.DerOutputStream;
import com.tencent.kona.sun.security.util.DerValue;
import com.tencent.kona.sun.security.x509.Extension;
import com.tencent.kona.sun.security.x509.GeneralName;
import com.tencent.kona.sun.security.x509.GeneralNames;
import com.tencent.kona.sun.security.x509.PKIXExtensions;
import java.io.IOException;

public class IssuerAlternativeNameExtension
extends Extension {
    public static final String NAME = "IssuerAlternativeName";
    GeneralNames names;

    private void encodeThis() {
        if (this.names == null || this.names.isEmpty()) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream os = new DerOutputStream();
        this.names.encode(os);
        this.extensionValue = os.toByteArray();
    }

    public IssuerAlternativeNameExtension(GeneralNames names) {
        this((Boolean)false, names);
    }

    public IssuerAlternativeNameExtension(Boolean critical, GeneralNames names) {
        if (names == null || names.isEmpty()) {
            throw new IllegalArgumentException("names cannot be null or empty");
        }
        this.names = names;
        this.extensionId = PKIXExtensions.IssuerAlternativeName_Id;
        this.critical = critical;
        this.encodeThis();
    }

    public IssuerAlternativeNameExtension(Boolean critical, Object value) throws IOException {
        this.extensionId = PKIXExtensions.IssuerAlternativeName_Id;
        this.critical = critical;
        this.extensionValue = (byte[])value;
        DerValue val = new DerValue(this.extensionValue);
        if (val.data == null) {
            this.names = new GeneralNames();
            return;
        }
        this.names = new GeneralNames(val);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append("IssuerAlternativeName [\n");
        if (this.names == null) {
            sb.append("  null\n");
        } else {
            for (GeneralName name : this.names.names()) {
                sb.append("  ").append(name).append('\n');
            }
        }
        sb.append("]\n");
        return sb.toString();
    }

    @Override
    public void encode(DerOutputStream out) {
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.IssuerAlternativeName_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(out);
    }

    public GeneralNames getNames() {
        return this.names;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

