/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.x509;

import com.tencent.kona.crypto.CryptoInsts;
import com.tencent.kona.sun.security.util.DerOutputStream;
import com.tencent.kona.sun.security.util.DerValue;
import com.tencent.kona.sun.security.util.HexDumpEncoder;
import com.tencent.kona.sun.security.x509.AlgorithmId;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.util.Arrays;

public class KeyIdentifier {
    private final byte[] octetString;

    public KeyIdentifier(byte[] octetString) {
        this.octetString = (byte[])octetString.clone();
    }

    public KeyIdentifier(DerValue val) throws IOException {
        this.octetString = val.getOctetString();
    }

    public KeyIdentifier(PublicKey pubKey) throws IOException {
        MessageDigest md;
        DerValue algAndKey = new DerValue(pubKey.getEncoded());
        if (algAndKey.tag != 48) {
            throw new IOException("PublicKey value is not a valid X.509 public key");
        }
        AlgorithmId algid = AlgorithmId.parse(algAndKey.data.getDerValue());
        byte[] key = algAndKey.data.getUnalignedBitString().toByteArray();
        try {
            md = CryptoInsts.getMessageDigest("SHA1");
        }
        catch (NoSuchAlgorithmException e3) {
            throw new IOException("SHA1 not supported");
        }
        md.update(key);
        this.octetString = md.digest();
    }

    public byte[] getIdentifier() {
        return (byte[])this.octetString.clone();
    }

    public String toString() {
        String s = "KeyIdentifier [\n";
        HexDumpEncoder encoder = new HexDumpEncoder();
        s = s + encoder.encodeBuffer(this.octetString);
        s = s + "]\n";
        return s;
    }

    void encode(DerOutputStream out) {
        out.putOctetString(this.octetString);
    }

    public int hashCode() {
        return Arrays.hashCode(this.octetString);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof KeyIdentifier)) {
            return false;
        }
        return Arrays.equals(this.octetString, ((KeyIdentifier)obj).octetString);
    }
}

