/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.x509;

import com.tencent.kona.sun.net.util.IPAddressUtil;
import com.tencent.kona.sun.security.pkcs.PKCS9Attribute;
import com.tencent.kona.sun.security.util.DerOutputStream;
import com.tencent.kona.sun.security.util.DerValue;
import com.tencent.kona.sun.security.util.ObjectIdentifier;
import com.tencent.kona.sun.security.x509.AVA;
import com.tencent.kona.sun.security.x509.DNSName;
import com.tencent.kona.sun.security.x509.Extension;
import com.tencent.kona.sun.security.x509.GeneralName;
import com.tencent.kona.sun.security.x509.GeneralNameInterface;
import com.tencent.kona.sun.security.x509.GeneralNames;
import com.tencent.kona.sun.security.x509.GeneralSubtree;
import com.tencent.kona.sun.security.x509.GeneralSubtrees;
import com.tencent.kona.sun.security.x509.IPAddressName;
import com.tencent.kona.sun.security.x509.PKIXExtensions;
import com.tencent.kona.sun.security.x509.RFC822Name;
import com.tencent.kona.sun.security.x509.SubjectAlternativeNameExtension;
import com.tencent.kona.sun.security.x509.X500Name;
import com.tencent.kona.sun.security.x509.X509CertImpl;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;

public class NameConstraintsExtension
extends Extension
implements Cloneable {
    public static final String NAME = "NameConstraints";
    private static final byte TAG_PERMITTED = 0;
    private static final byte TAG_EXCLUDED = 1;
    private GeneralSubtrees permitted = null;
    private GeneralSubtrees excluded = null;
    private boolean hasMin;
    private boolean hasMax;
    private boolean minMaxValid = false;

    private void calcMinMax() {
        GeneralSubtree subtree;
        int i;
        this.hasMin = false;
        this.hasMax = false;
        if (this.excluded != null) {
            for (i = 0; i < this.excluded.size(); ++i) {
                subtree = this.excluded.get(i);
                if (subtree.getMinimum() != 0) {
                    this.hasMin = true;
                }
                if (subtree.getMaximum() == -1) continue;
                this.hasMax = true;
            }
        }
        if (this.permitted != null) {
            for (i = 0; i < this.permitted.size(); ++i) {
                subtree = this.permitted.get(i);
                if (subtree.getMinimum() != 0) {
                    this.hasMin = true;
                }
                if (subtree.getMaximum() == -1) continue;
                this.hasMax = true;
            }
        }
        this.minMaxValid = true;
    }

    private void encodeThis() {
        DerOutputStream tmp;
        this.minMaxValid = false;
        if (this.permitted == null && this.excluded == null) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream seq = new DerOutputStream();
        DerOutputStream tagged = new DerOutputStream();
        if (this.permitted != null) {
            tmp = new DerOutputStream();
            this.permitted.encode(tmp);
            tagged.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), tmp);
        }
        if (this.excluded != null) {
            tmp = new DerOutputStream();
            this.excluded.encode(tmp);
            tagged.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), tmp);
        }
        seq.write((byte)48, tagged);
        this.extensionValue = seq.toByteArray();
    }

    public NameConstraintsExtension(GeneralSubtrees permitted, GeneralSubtrees excluded) {
        if (permitted == null && excluded == null) {
            throw new IllegalArgumentException("permitted and excluded cannot both be null");
        }
        this.permitted = permitted;
        this.excluded = excluded;
        this.extensionId = PKIXExtensions.NameConstraints_Id;
        this.critical = true;
        this.encodeThis();
    }

    public NameConstraintsExtension(Boolean critical, Object value) throws IOException {
        this.extensionId = PKIXExtensions.NameConstraints_Id;
        this.critical = critical;
        this.extensionValue = (byte[])value;
        DerValue val = new DerValue(this.extensionValue);
        if (val.tag != 48) {
            throw new IOException("Invalid encoding for NameConstraintsExtension.");
        }
        if (val.data == null) {
            return;
        }
        while (val.data.available() != 0) {
            DerValue opt = val.data.getDerValue();
            if (opt.isContextSpecific((byte)0) && opt.isConstructed()) {
                if (this.permitted != null) {
                    throw new IOException("Duplicate permitted GeneralSubtrees in NameConstraintsExtension.");
                }
                opt.resetTag((byte)48);
                this.permitted = new GeneralSubtrees(opt);
                continue;
            }
            if (opt.isContextSpecific((byte)1) && opt.isConstructed()) {
                if (this.excluded != null) {
                    throw new IOException("Duplicate excluded GeneralSubtrees in NameConstraintsExtension.");
                }
                opt.resetTag((byte)48);
                this.excluded = new GeneralSubtrees(opt);
                continue;
            }
            throw new IOException("Invalid encoding of NameConstraintsExtension.");
        }
        this.minMaxValid = false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append("NameConstraints: [");
        if (this.permitted != null) {
            sb.append("\n    Permitted:").append(this.permitted);
        }
        if (this.excluded != null) {
            sb.append("\n    Excluded:").append(this.excluded);
        }
        sb.append("   ]\n");
        return sb.toString();
    }

    @Override
    public void encode(DerOutputStream out) {
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.NameConstraints_Id;
            this.critical = true;
            this.encodeThis();
        }
        super.encode(out);
    }

    public GeneralSubtrees getPermittedSubtrees() {
        return this.permitted;
    }

    public GeneralSubtrees getExcludedSubtrees() {
        return this.excluded;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public void merge(NameConstraintsExtension newConstraints) throws IOException {
        if (newConstraints == null) {
            return;
        }
        boolean updated = false;
        GeneralSubtrees newExcluded = newConstraints.getExcludedSubtrees();
        if (this.excluded == null) {
            if (newExcluded != null) {
                this.excluded = (GeneralSubtrees)newExcluded.clone();
                updated = true;
            }
        } else if (newExcluded != null) {
            this.excluded.union(newExcluded);
            updated = true;
        }
        GeneralSubtrees newPermitted = newConstraints.getPermittedSubtrees();
        if (this.permitted == null) {
            if (newPermitted != null) {
                this.permitted = (GeneralSubtrees)newPermitted.clone();
                updated = true;
            }
        } else if (newPermitted != null && (newExcluded = this.permitted.intersect(newPermitted)) != null) {
            if (this.excluded != null) {
                this.excluded.union(newExcluded);
            } else {
                this.excluded = (GeneralSubtrees)newExcluded.clone();
            }
            updated = true;
        }
        if (this.permitted != null) {
            this.permitted.reduce(this.excluded);
            updated = true;
        }
        if (updated) {
            this.encodeThis();
        }
    }

    public boolean verify(X509Certificate cert) throws IOException {
        DerValue derValue;
        String cn;
        if (cert == null) {
            throw new IOException("Certificate is null");
        }
        if (!this.minMaxValid) {
            this.calcMinMax();
        }
        if (this.hasMin) {
            throw new IOException("Non-zero minimum BaseDistance in name constraints not supported");
        }
        if (this.hasMax) {
            throw new IOException("Maximum BaseDistance in name constraints not supported");
        }
        X500Principal subjectPrincipal = cert.getSubjectX500Principal();
        X500Name subject = X500Name.asX500Name(subjectPrincipal);
        if (!subject.isEmpty() && !this.verify(subject)) {
            return false;
        }
        GeneralNames altNames = null;
        try {
            X509CertImpl certImpl = X509CertImpl.toImpl(cert);
            SubjectAlternativeNameExtension altNameExt = certImpl.getSubjectAlternativeNameExtension();
            if (altNameExt != null) {
                altNames = altNameExt.getNames();
            }
        }
        catch (CertificateException ce) {
            throw new IOException("Unable to extract extensions from certificate: " + ce.getMessage());
        }
        if (altNames == null) {
            altNames = new GeneralNames();
            for (AVA ava : subject.allAvas()) {
                String attrValue;
                ObjectIdentifier attrOID = ava.getObjectIdentifier();
                if (!attrOID.equals(PKCS9Attribute.EMAIL_ADDRESS_OID) || (attrValue = ava.getValueString()) == null) continue;
                try {
                    altNames.add(new GeneralName(new RFC822Name(attrValue)));
                }
                catch (IOException ioe) {}
            }
        }
        String string = cn = (derValue = subject.findMostSpecificAttribute(X500Name.commonName_oid)) == null ? null : derValue.getAsString();
        if (cn != null) {
            try {
                if (IPAddressUtil.isIPv4LiteralAddress(cn) || IPAddressUtil.isIPv6LiteralAddress(cn)) {
                    if (!NameConstraintsExtension.hasNameType(altNames, 7)) {
                        altNames.add(new GeneralName(new IPAddressName(cn)));
                    }
                } else if (!NameConstraintsExtension.hasNameType(altNames, 2)) {
                    altNames.add(new GeneralName(new DNSName(cn)));
                }
            }
            catch (IOException attrOID) {
                // empty catch block
            }
        }
        for (int i = 0; i < altNames.size(); ++i) {
            GeneralNameInterface altGNI = altNames.get(i).getName();
            if (this.verify(altGNI)) continue;
            return false;
        }
        return true;
    }

    private static boolean hasNameType(GeneralNames names, int type) {
        for (GeneralName name : names.names()) {
            if (name.getType() != type) continue;
            return true;
        }
        return false;
    }

    public boolean verify(GeneralNameInterface name) throws IOException {
        if (name == null) {
            throw new IOException("name is null");
        }
        if (this.excluded != null && this.excluded.size() > 0) {
            block9: for (int i = 0; i < this.excluded.size(); ++i) {
                GeneralNameInterface exName;
                GeneralName gn;
                GeneralSubtree gs = this.excluded.get(i);
                if (gs == null || (gn = gs.getName()) == null || (exName = gn.getName()) == null) continue;
                switch (exName.constrains(name)) {
                    case -1: 
                    case 2: 
                    case 3: {
                        continue block9;
                    }
                    case 0: 
                    case 1: {
                        return false;
                    }
                }
            }
        }
        if (this.permitted != null && this.permitted.size() > 0) {
            boolean sameType = false;
            block10: for (int i = 0; i < this.permitted.size(); ++i) {
                GeneralNameInterface perName;
                GeneralName gn;
                GeneralSubtree gs = this.permitted.get(i);
                if (gs == null || (gn = gs.getName()) == null || (perName = gn.getName()) == null) continue;
                switch (perName.constrains(name)) {
                    case -1: {
                        continue block10;
                    }
                    case 2: 
                    case 3: {
                        sameType = true;
                        continue block10;
                    }
                    case 0: 
                    case 1: {
                        return true;
                    }
                }
            }
            return !sameType;
        }
        return true;
    }

    public Object clone() {
        try {
            NameConstraintsExtension newNCE = (NameConstraintsExtension)super.clone();
            if (this.permitted != null) {
                newNCE.permitted = (GeneralSubtrees)this.permitted.clone();
            }
            if (this.excluded != null) {
                newNCE.excluded = (GeneralSubtrees)this.excluded.clone();
            }
            return newNCE;
        }
        catch (CloneNotSupportedException cnsee) {
            throw new RuntimeException("CloneNotSupportedException while cloning NameConstraintsException. This should never happen.");
        }
    }
}

