/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.x509;

import com.tencent.kona.sun.security.util.DerOutputStream;
import com.tencent.kona.sun.security.util.DerValue;
import com.tencent.kona.sun.security.util.ObjectIdentifier;
import com.tencent.kona.sun.security.util.Oid;
import com.tencent.kona.sun.security.x509.GeneralNameInterface;
import java.io.IOException;

public class OIDName
implements GeneralNameInterface {
    private final ObjectIdentifier oid;

    public OIDName(DerValue derValue) throws IOException {
        this.oid = derValue.getOID();
    }

    public OIDName(ObjectIdentifier oid) {
        this.oid = oid;
    }

    public OIDName(String name) throws IOException {
        try {
            this.oid = Oid.of(name);
        }
        catch (Exception e) {
            throw new IOException("Unable to create OIDName: " + e);
        }
    }

    @Override
    public int getType() {
        return 8;
    }

    @Override
    public void encode(DerOutputStream out) {
        out.putOID(this.oid);
    }

    public String toString() {
        return "OIDName: " + this.oid.toString();
    }

    public ObjectIdentifier getOID() {
        return this.oid;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OIDName)) {
            return false;
        }
        return this.oid.equals(((OIDName)obj).oid);
    }

    public int hashCode() {
        return this.oid.hashCode();
    }

    @Override
    public int constrains(GeneralNameInterface inputName) throws UnsupportedOperationException {
        int constraintType;
        if (inputName == null) {
            constraintType = -1;
        } else if (inputName.getType() != 8) {
            constraintType = -1;
        } else if (this.equals(inputName)) {
            constraintType = 0;
        } else {
            throw new UnsupportedOperationException("Narrowing and widening are not supported for OIDNames");
        }
        return constraintType;
    }

    @Override
    public int subtreeDepth() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("subtreeDepth() not supported for OIDName.");
    }
}

