/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.x509;

import com.tencent.kona.sun.security.util.DerEncoder;
import com.tencent.kona.sun.security.util.DerOutputStream;
import com.tencent.kona.sun.security.util.DerValue;
import com.tencent.kona.sun.security.x509.CertificatePolicyId;
import java.io.IOException;
import java.security.cert.PolicyQualifierInfo;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public class PolicyInformation
implements DerEncoder {
    public static final String NAME = "PolicyInformation";
    public static final String ID = "id";
    public static final String QUALIFIERS = "qualifiers";
    private CertificatePolicyId policyIdentifier;
    private Set<PolicyQualifierInfo> policyQualifiers;

    public PolicyInformation(CertificatePolicyId policyIdentifier, Set<PolicyQualifierInfo> policyQualifiers) throws IOException {
        if (policyQualifiers == null) {
            throw new NullPointerException("policyQualifiers is null");
        }
        this.policyQualifiers = new LinkedHashSet<PolicyQualifierInfo>(policyQualifiers);
        this.policyIdentifier = Objects.requireNonNull(policyIdentifier);
    }

    public PolicyInformation(DerValue val) throws IOException {
        if (val.tag != 48) {
            throw new IOException("Invalid encoding of PolicyInformation");
        }
        this.policyIdentifier = new CertificatePolicyId(val.data.getDerValue());
        if (val.data.available() != 0) {
            this.policyQualifiers = new LinkedHashSet<PolicyQualifierInfo>();
            DerValue opt = val.data.getDerValue();
            if (opt.tag != 48) {
                throw new IOException("Invalid encoding of PolicyInformation");
            }
            if (opt.data.available() == 0) {
                throw new IOException("No data available in policyQualifiers");
            }
            while (opt.data.available() != 0) {
                this.policyQualifiers.add(new PolicyQualifierInfo(opt.data.getDerValue().toByteArray()));
            }
        } else {
            this.policyQualifiers = Collections.emptySet();
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PolicyInformation)) {
            return false;
        }
        return this.policyIdentifier.equals(((PolicyInformation)obj).getPolicyIdentifier()) && this.policyQualifiers.equals(((PolicyInformation)obj).getPolicyQualifiers());
    }

    public int hashCode() {
        return Objects.hash(this.policyIdentifier, this.policyQualifiers);
    }

    public CertificatePolicyId getPolicyIdentifier() {
        return this.policyIdentifier;
    }

    public Set<PolicyQualifierInfo> getPolicyQualifiers() {
        return this.policyQualifiers;
    }

    public String toString() {
        return "  [" + this.policyIdentifier + this.policyQualifiers + "  ]\n";
    }

    @Override
    public void encode(DerOutputStream out) {
        DerOutputStream tmp = new DerOutputStream();
        this.policyIdentifier.encode(tmp);
        if (!this.policyQualifiers.isEmpty()) {
            DerOutputStream tmp2 = new DerOutputStream();
            for (PolicyQualifierInfo pq : this.policyQualifiers) {
                byte[] bufBytes = pq.getEncoded();
                tmp2.write(bufBytes, 0, bufBytes.length);
            }
            tmp.write((byte)48, tmp2);
        }
        out.write((byte)48, tmp);
    }
}

