/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.x509;

import com.tencent.kona.sun.security.util.BitArray;
import com.tencent.kona.sun.security.util.DerEncoder;
import com.tencent.kona.sun.security.util.DerInputStream;
import com.tencent.kona.sun.security.util.DerOutputStream;
import com.tencent.kona.sun.security.util.DerValue;
import java.io.IOException;

public class ReasonFlags
implements DerEncoder {
    public static final String UNUSED = "unused";
    public static final String KEY_COMPROMISE = "key_compromise";
    public static final String CA_COMPROMISE = "ca_compromise";
    public static final String AFFILIATION_CHANGED = "affiliation_changed";
    public static final String SUPERSEDED = "superseded";
    public static final String CESSATION_OF_OPERATION = "cessation_of_operation";
    public static final String CERTIFICATE_HOLD = "certificate_hold";
    public static final String PRIVILEGE_WITHDRAWN = "privilege_withdrawn";
    public static final String AA_COMPROMISE = "aa_compromise";
    private static final String[] NAMES = new String[]{"unused", "key_compromise", "ca_compromise", "affiliation_changed", "superseded", "cessation_of_operation", "certificate_hold", "privilege_withdrawn", "aa_compromise"};
    private boolean[] bitString;

    private static int name2Index(String name) throws IOException {
        for (int i = 0; i < NAMES.length; ++i) {
            if (!NAMES[i].equalsIgnoreCase(name)) continue;
            return i;
        }
        throw new IOException("Name not recognized by ReasonFlags");
    }

    private boolean isSet(int position) {
        return position < this.bitString.length && this.bitString[position];
    }

    private void set(int position, boolean val) {
        if (position >= this.bitString.length) {
            boolean[] tmp = new boolean[position + 1];
            System.arraycopy(this.bitString, 0, tmp, 0, this.bitString.length);
            this.bitString = tmp;
        }
        this.bitString[position] = val;
    }

    public ReasonFlags(byte[] reasons) {
        this.bitString = new BitArray(reasons.length * 8, reasons).toBooleanArray();
    }

    public ReasonFlags(boolean[] reasons) {
        this.bitString = reasons;
    }

    public ReasonFlags(BitArray reasons) {
        this.bitString = reasons.toBooleanArray();
    }

    public ReasonFlags(DerInputStream in) throws IOException {
        DerValue derVal = in.getDerValue();
        this.bitString = derVal.getUnalignedBitString(true).toBooleanArray();
    }

    public ReasonFlags(DerValue derVal) throws IOException {
        this.bitString = derVal.getUnalignedBitString(true).toBooleanArray();
    }

    public boolean[] getFlags() {
        return this.bitString;
    }

    public void set(String name, Object obj) throws IOException {
        if (!(obj instanceof Boolean)) {
            throw new IOException("Attribute must be of type Boolean.");
        }
        boolean val = (Boolean)obj;
        this.set(ReasonFlags.name2Index(name), val);
    }

    public Object get(String name) throws IOException {
        return this.isSet(ReasonFlags.name2Index(name));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Reason Flags [\n");
        if (this.isSet(0)) {
            sb.append("  Unused\n");
        }
        if (this.isSet(1)) {
            sb.append("  Key Compromise\n");
        }
        if (this.isSet(2)) {
            sb.append("  CA Compromise\n");
        }
        if (this.isSet(3)) {
            sb.append("  Affiliation_Changed\n");
        }
        if (this.isSet(4)) {
            sb.append("  Superseded\n");
        }
        if (this.isSet(5)) {
            sb.append("  Cessation Of Operation\n");
        }
        if (this.isSet(6)) {
            sb.append("  Certificate Hold\n");
        }
        if (this.isSet(7)) {
            sb.append("  Privilege Withdrawn\n");
        }
        if (this.isSet(8)) {
            sb.append("  AA Compromise\n");
        }
        sb.append("]\n");
        return sb.toString();
    }

    @Override
    public void encode(DerOutputStream out) {
        out.putTruncatedUnalignedBitString(new BitArray(this.bitString));
    }
}

