/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.x509;

import com.tencent.kona.crypto.CryptoInsts;
import com.tencent.kona.sun.security.provider.X509Factory;
import com.tencent.kona.sun.security.util.DerEncoder;
import com.tencent.kona.sun.security.util.DerInputStream;
import com.tencent.kona.sun.security.util.DerOutputStream;
import com.tencent.kona.sun.security.util.DerValue;
import com.tencent.kona.sun.security.util.HexDumpEncoder;
import com.tencent.kona.sun.security.util.ObjectIdentifier;
import com.tencent.kona.sun.security.util.SignatureUtil;
import com.tencent.kona.sun.security.x509.AlgorithmId;
import com.tencent.kona.sun.security.x509.AuthorityKeyIdentifierExtension;
import com.tencent.kona.sun.security.x509.CRLExtensions;
import com.tencent.kona.sun.security.x509.CRLNumberExtension;
import com.tencent.kona.sun.security.x509.CertificateIssuerExtension;
import com.tencent.kona.sun.security.x509.DeltaCRLIndicatorExtension;
import com.tencent.kona.sun.security.x509.Extension;
import com.tencent.kona.sun.security.x509.GeneralNames;
import com.tencent.kona.sun.security.x509.IssuerAlternativeNameExtension;
import com.tencent.kona.sun.security.x509.IssuingDistributionPointExtension;
import com.tencent.kona.sun.security.x509.KeyIdentifier;
import com.tencent.kona.sun.security.x509.OIDMap;
import com.tencent.kona.sun.security.x509.PKIXExtensions;
import com.tencent.kona.sun.security.x509.X500Name;
import com.tencent.kona.sun.security.x509.X509CRLEntryImpl;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.security.auth.x500.X500Principal;

public class X509CRLImpl
extends X509CRL
implements DerEncoder {
    private byte[] signedCRL = null;
    private byte[] signature = null;
    private byte[] tbsCertList = null;
    private AlgorithmId sigAlgId = null;
    private TBSCertList info;
    private static final boolean isExplicit = true;
    private PublicKey verifiedPublicKey;
    private String verifiedProvider;

    public X509CRLImpl(TBSCertList info, AlgorithmId sigAlgId, byte[] signature, byte[] tbsCertList, byte[] signedCRL) {
        this.info = info;
        this.sigAlgId = sigAlgId;
        this.signature = signature;
        this.tbsCertList = tbsCertList;
        this.signedCRL = Objects.requireNonNull(signedCRL);
    }

    public X509CRLImpl(byte[] crlData) throws CRLException {
        try {
            this.parse(new DerValue(crlData));
        }
        catch (IOException e) {
            throw new CRLException("Parsing error: " + e.getMessage());
        }
    }

    public X509CRLImpl(DerValue val) throws CRLException {
        try {
            this.parse(val);
        }
        catch (IOException e) {
            throw new CRLException("Parsing error: " + e.getMessage());
        }
    }

    public X509CRLImpl(InputStream inStrm) throws CRLException {
        try {
            this.parse(new DerValue(inStrm));
        }
        catch (IOException e) {
            throw new CRLException("Parsing error: " + e.getMessage());
        }
    }

    public byte[] getEncodedInternal() throws CRLException {
        return this.signedCRL;
    }

    @Override
    public byte[] getEncoded() throws CRLException {
        return (byte[])this.getEncodedInternal().clone();
    }

    @Override
    public void verify(PublicKey key) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(key, "");
    }

    @Override
    public synchronized void verify(PublicKey key, String sigProvider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (sigProvider == null) {
            sigProvider = "";
        }
        if (this.verifiedPublicKey != null && this.verifiedPublicKey.equals(key) && sigProvider.equals(this.verifiedProvider)) {
            return;
        }
        Signature sigVerf = null;
        String sigName = this.sigAlgId.getName();
        sigVerf = sigProvider.isEmpty() ? CryptoInsts.getSignature(sigName) : Signature.getInstance(sigName, sigProvider);
        try {
            SignatureUtil.initVerifyWithParam(sigVerf, key, SignatureUtil.getParamSpec(sigName, this.getSigAlgParams()));
        }
        catch (ProviderException e) {
            throw new CRLException(e.getMessage(), e.getCause());
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CRLException(e);
        }
        if (this.tbsCertList == null) {
            throw new CRLException("Uninitialized CRL");
        }
        sigVerf.update(this.tbsCertList, 0, this.tbsCertList.length);
        if (!sigVerf.verify(this.signature)) {
            throw new SignatureException("Signature does not match.");
        }
        this.verifiedPublicKey = key;
        this.verifiedProvider = sigProvider;
    }

    @Override
    public synchronized void verify(PublicKey key, Provider sigProvider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        String sigName = this.sigAlgId.getName();
        Signature sigVerf = sigProvider == null ? CryptoInsts.getSignature(sigName) : Signature.getInstance(sigName, sigProvider);
        try {
            SignatureUtil.initVerifyWithParam(sigVerf, key, SignatureUtil.getParamSpec(sigName, this.getSigAlgParams()));
        }
        catch (ProviderException e) {
            throw new CRLException(e.getMessage(), e.getCause());
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CRLException(e);
        }
        if (this.tbsCertList == null) {
            throw new CRLException("Uninitialized CRL");
        }
        sigVerf.update(this.tbsCertList, 0, this.tbsCertList.length);
        if (!sigVerf.verify(this.signature)) {
            throw new SignatureException("Signature does not match.");
        }
        this.verifiedPublicKey = key;
    }

    public static X509CRLImpl newSigned(TBSCertList info, PrivateKey key, String algorithm) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        return X509CRLImpl.newSigned(info, key, algorithm, null);
    }

    public static X509CRLImpl newSigned(TBSCertList info, PrivateKey key, String algorithm, String provider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature sigEngine = SignatureUtil.fromKey(algorithm, key, provider);
        AlgorithmId sigAlgId = SignatureUtil.fromSignature(sigEngine, key);
        info.infoSigAlgId = sigAlgId;
        DerOutputStream out = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        byte[] tbsCertList = info.encodeInfo();
        tmp.write(tbsCertList, 0, tbsCertList.length);
        sigAlgId.encode(tmp);
        sigEngine.update(tbsCertList, 0, tbsCertList.length);
        byte[] signature = sigEngine.sign();
        tmp.putBitString(signature);
        out.write((byte)48, tmp);
        byte[] signedCRL = out.toByteArray();
        return new X509CRLImpl(info, sigAlgId, signature, tbsCertList, signedCRL);
    }

    @Override
    public String toString() {
        return this.toStringWithAlgName("" + this.sigAlgId);
    }

    public String toStringWithAlgName(String name) {
        StringBuilder sb = new StringBuilder();
        sb.append("X.509 CRL v").append(this.info.version + 1).append('\n');
        if (this.sigAlgId != null) {
            sb.append("Signature Algorithm: ").append(name).append(", OID=").append(this.sigAlgId.getOID()).append('\n');
        }
        if (this.info.issuer != null) {
            sb.append("Issuer: ").append(this.info.issuer).append('\n');
        }
        if (this.info.thisUpdate != null) {
            sb.append("\nThis Update: ").append(this.info.thisUpdate).append('\n');
        }
        if (this.info.nextUpdate != null) {
            sb.append("Next Update: ").append(this.info.nextUpdate).append('\n');
        }
        if (this.info.revokedList.isEmpty()) {
            sb.append("\nNO certificates have been revoked\n");
        } else {
            sb.append("\nRevoked Certificates: ").append(this.info.revokedList.size());
            int i = 1;
            for (X509CRLEntry entry : this.info.revokedList) {
                sb.append("\n[").append(i++).append("] ").append(entry);
            }
        }
        if (this.info.extensions != null) {
            Collection<Extension> allExts = this.info.extensions.getAllExtensions();
            Object[] objs = allExts.toArray();
            sb.append("\nCRL Extensions: ").append(objs.length);
            for (int i = 0; i < objs.length; ++i) {
                sb.append("\n[").append(i + 1).append("]: ");
                Extension ext = (Extension)objs[i];
                try {
                    if (OIDMap.getClass(ext.getExtensionId()) == null) {
                        sb.append(ext);
                        byte[] extValue = ext.getExtensionValue();
                        if (extValue == null) continue;
                        DerOutputStream out = new DerOutputStream();
                        out.putOctetString(extValue);
                        extValue = out.toByteArray();
                        HexDumpEncoder enc = new HexDumpEncoder();
                        sb.append("Extension unknown: ").append("DER encoded OCTET string =\n").append(enc.encodeBuffer(extValue)).append('\n');
                        continue;
                    }
                    sb.append(ext);
                    continue;
                }
                catch (Exception e) {
                    sb.append(", Error parsing this extension");
                }
            }
        }
        if (this.signature != null) {
            HexDumpEncoder encoder = new HexDumpEncoder();
            sb.append("\nSignature:\n").append(encoder.encodeBuffer(this.signature)).append('\n');
        } else {
            sb.append("NOT signed yet\n");
        }
        return sb.toString();
    }

    @Override
    public boolean isRevoked(Certificate cert) {
        if (this.info.revokedMap.isEmpty() || !(cert instanceof X509Certificate)) {
            return false;
        }
        X509Certificate xcert = (X509Certificate)cert;
        X509IssuerSerial issuerSerial = new X509IssuerSerial(xcert);
        return this.info.revokedMap.containsKey(issuerSerial);
    }

    @Override
    public int getVersion() {
        return this.info.version + 1;
    }

    @Override
    public Principal getIssuerDN() {
        return this.info.issuer;
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        return this.info.getIssuerX500Principal();
    }

    @Override
    public Date getThisUpdate() {
        return new Date(this.info.thisUpdate.getTime());
    }

    @Override
    public Date getNextUpdate() {
        if (this.info.nextUpdate == null) {
            return null;
        }
        return new Date(this.info.nextUpdate.getTime());
    }

    @Override
    public X509CRLEntry getRevokedCertificate(BigInteger serialNumber) {
        if (this.info.revokedMap.isEmpty()) {
            return null;
        }
        X509IssuerSerial issuerSerial = new X509IssuerSerial(this.getIssuerX500Principal(), serialNumber);
        return (X509CRLEntry)this.info.revokedMap.get(issuerSerial);
    }

    @Override
    public X509CRLEntry getRevokedCertificate(X509Certificate cert) {
        if (this.info.revokedMap.isEmpty()) {
            return null;
        }
        X509IssuerSerial issuerSerial = new X509IssuerSerial(cert);
        return (X509CRLEntry)this.info.revokedMap.get(issuerSerial);
    }

    public Set<X509CRLEntry> getRevokedCertificates() {
        if (this.info.revokedList.isEmpty()) {
            return null;
        }
        return new TreeSet<X509CRLEntry>(this.info.revokedList);
    }

    @Override
    public byte[] getTBSCertList() throws CRLException {
        if (this.tbsCertList == null) {
            throw new CRLException("Uninitialized CRL");
        }
        return (byte[])this.tbsCertList.clone();
    }

    @Override
    public byte[] getSignature() {
        if (this.signature == null) {
            return null;
        }
        return (byte[])this.signature.clone();
    }

    @Override
    public String getSigAlgName() {
        if (this.sigAlgId == null) {
            return null;
        }
        return this.sigAlgId.getName();
    }

    @Override
    public String getSigAlgOID() {
        if (this.sigAlgId == null) {
            return null;
        }
        ObjectIdentifier oid = this.sigAlgId.getOID();
        return oid.toString();
    }

    @Override
    public byte[] getSigAlgParams() {
        return this.sigAlgId == null ? null : this.sigAlgId.getEncodedParams();
    }

    public AlgorithmId getSigAlgId() {
        return this.sigAlgId;
    }

    public KeyIdentifier getAuthKeyId() {
        AuthorityKeyIdentifierExtension aki = this.getAuthKeyIdExtension();
        if (aki != null) {
            return aki.getKeyIdentifier();
        }
        return null;
    }

    public AuthorityKeyIdentifierExtension getAuthKeyIdExtension() {
        return (AuthorityKeyIdentifierExtension)this.getExtension(PKIXExtensions.AuthorityKey_Id);
    }

    public CRLNumberExtension getCRLNumberExtension() {
        return (CRLNumberExtension)this.getExtension(PKIXExtensions.CRLNumber_Id);
    }

    public BigInteger getCRLNumber() {
        CRLNumberExtension numExt = this.getCRLNumberExtension();
        if (numExt != null) {
            return numExt.getCrlNumber();
        }
        return null;
    }

    public DeltaCRLIndicatorExtension getDeltaCRLIndicatorExtension() {
        return (DeltaCRLIndicatorExtension)this.getExtension(PKIXExtensions.DeltaCRLIndicator_Id);
    }

    public BigInteger getBaseCRLNumber() {
        DeltaCRLIndicatorExtension dciExt = this.getDeltaCRLIndicatorExtension();
        if (dciExt != null) {
            return dciExt.getCrlNumber();
        }
        return null;
    }

    public IssuerAlternativeNameExtension getIssuerAltNameExtension() {
        return (IssuerAlternativeNameExtension)this.getExtension(PKIXExtensions.IssuerAlternativeName_Id);
    }

    public IssuingDistributionPointExtension getIssuingDistributionPointExtension() {
        return (IssuingDistributionPointExtension)this.getExtension(PKIXExtensions.IssuingDistributionPoint_Id);
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        if (this.info.extensions == null) {
            return false;
        }
        return this.info.extensions.hasUnsupportedCriticalExtension();
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        if (this.info.extensions == null) {
            return null;
        }
        TreeSet<String> extSet = new TreeSet<String>();
        for (Extension ex : this.info.extensions.getAllExtensions()) {
            if (!ex.isCritical()) continue;
            extSet.add(ex.getExtensionId().toString());
        }
        return extSet;
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        if (this.info.extensions == null) {
            return null;
        }
        TreeSet<String> extSet = new TreeSet<String>();
        for (Extension ex : this.info.extensions.getAllExtensions()) {
            if (ex.isCritical()) continue;
            extSet.add(ex.getExtensionId().toString());
        }
        return extSet;
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        if (this.info.extensions == null) {
            return null;
        }
        try {
            String extAlias = OIDMap.getName(ObjectIdentifier.of(oid));
            Extension crlExt = null;
            if (extAlias == null) {
                ObjectIdentifier findOID = ObjectIdentifier.of(oid);
                for (Extension ex : this.info.extensions.getAllExtensions()) {
                    ObjectIdentifier inCertOID = ex.getExtensionId();
                    if (!inCertOID.equals(findOID)) continue;
                    crlExt = ex;
                    break;
                }
            } else {
                crlExt = this.info.extensions.getExtension(extAlias);
            }
            if (crlExt == null) {
                return null;
            }
            byte[] extData = crlExt.getExtensionValue();
            if (extData == null) {
                return null;
            }
            DerOutputStream out = new DerOutputStream();
            out.putOctetString(extData);
            return out.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object getExtension(ObjectIdentifier oid) {
        if (this.info.extensions == null) {
            return null;
        }
        return this.info.extensions.getExtension(OIDMap.getName(oid));
    }

    private void parse(DerValue val) throws CRLException, IOException {
        if (val.getData() == null || val.tag != 48) {
            throw new CRLException("Invalid DER-encoded CRL data");
        }
        this.signedCRL = val.toByteArray();
        DerValue[] seq = new DerValue[]{val.data.getDerValue(), val.data.getDerValue(), val.data.getDerValue()};
        if (val.data.available() != 0) {
            throw new CRLException("signed overrun, bytes = " + val.data.available());
        }
        this.info = new TBSCertList(seq[0]);
        this.sigAlgId = AlgorithmId.parse(seq[1]);
        if (!this.sigAlgId.equals(this.info.infoSigAlgId)) {
            throw new CRLException("Signature algorithm mismatch");
        }
        this.signature = seq[2].getBitString();
        if (seq[1].data.available() != 0) {
            throw new CRLException("AlgorithmId field overrun");
        }
        if (seq[2].data.available() != 0) {
            throw new CRLException("Signature field overrun");
        }
        this.tbsCertList = seq[0].toByteArray();
    }

    public static X500Principal getIssuerX500Principal(X509CRL crl) {
        try {
            byte[] encoded = crl.getEncoded();
            DerInputStream derIn = new DerInputStream(encoded);
            DerValue tbsCert = derIn.getSequence(3)[0];
            DerInputStream tbsIn = tbsCert.data;
            byte nextByte = (byte)tbsIn.peekByte();
            if (nextByte == 2) {
                DerValue derValue = tbsIn.getDerValue();
            }
            DerValue tmp = tbsIn.getDerValue();
            tmp = tbsIn.getDerValue();
            byte[] principalBytes = tmp.toByteArray();
            return new X500Principal(principalBytes);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not parse issuer", e);
        }
    }

    public static byte[] getEncodedInternal(X509CRL crl) throws CRLException {
        if (crl instanceof X509CRLImpl) {
            return ((X509CRLImpl)crl).getEncodedInternal();
        }
        return crl.getEncoded();
    }

    public static X509CRLImpl toImpl(X509CRL crl) throws CRLException {
        if (crl instanceof X509CRLImpl) {
            return (X509CRLImpl)crl;
        }
        return X509Factory.intern(crl);
    }

    @Override
    public void encode(DerOutputStream out) {
        byte[] bytes = (byte[])this.signedCRL.clone();
        out.write(bytes, 0, bytes.length);
    }

    private static final class X509IssuerSerial
    implements Comparable<X509IssuerSerial> {
        final X500Principal issuer;
        final BigInteger serial;
        volatile int hashcode;

        X509IssuerSerial(X500Principal issuer, BigInteger serial) {
            this.issuer = issuer;
            this.serial = serial;
        }

        X509IssuerSerial(X509Certificate cert) {
            this(cert.getIssuerX500Principal(), cert.getSerialNumber());
        }

        X500Principal getIssuer() {
            return this.issuer;
        }

        BigInteger getSerial() {
            return this.serial;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof X509IssuerSerial)) {
                return false;
            }
            X509IssuerSerial other = (X509IssuerSerial)o;
            return this.serial.equals(other.getSerial()) && this.issuer.equals(other.getIssuer());
        }

        public int hashCode() {
            int h = this.hashcode;
            if (h == 0 && (h = Objects.hash(this.issuer, this.serial)) != 0) {
                this.hashcode = h;
            }
            return h;
        }

        @Override
        public int compareTo(X509IssuerSerial another) {
            int cissuer = this.issuer.toString().compareTo(another.issuer.toString());
            if (cissuer != 0) {
                return cissuer;
            }
            return this.serial.compareTo(another.serial);
        }
    }

    public static class TBSCertList {
        private int version;
        private AlgorithmId infoSigAlgId;
        private X500Name issuer = null;
        private X500Principal issuerPrincipal = null;
        private Date thisUpdate = null;
        private Date nextUpdate = null;
        private final Map<X509IssuerSerial, X509CRLEntry> revokedMap = new TreeMap<X509IssuerSerial, X509CRLEntry>();
        private final List<X509CRLEntry> revokedList = new LinkedList<X509CRLEntry>();
        private CRLExtensions extensions = null;

        public TBSCertList(X500Name issuer, Date thisDate, Date nextDate) {
            this.issuer = issuer;
            this.thisUpdate = thisDate;
            this.nextUpdate = nextDate;
        }

        public TBSCertList(X500Name issuer, Date thisDate, Date nextDate, X509CRLEntry[] badCerts) throws CRLException {
            this.issuer = issuer;
            this.thisUpdate = thisDate;
            this.nextUpdate = nextDate;
            if (badCerts != null) {
                X500Principal crlIssuer;
                X500Principal badCertIssuer = crlIssuer = this.getIssuerX500Principal();
                for (int i = 0; i < badCerts.length; ++i) {
                    X509CRLEntryImpl badCert = (X509CRLEntryImpl)badCerts[i];
                    badCertIssuer = this.getCertIssuer(badCert, badCertIssuer);
                    badCert.setCertificateIssuer(crlIssuer, badCertIssuer);
                    X509IssuerSerial issuerSerial = new X509IssuerSerial(badCertIssuer, badCert.getSerialNumber());
                    this.revokedMap.put(issuerSerial, badCert);
                    this.revokedList.add(badCert);
                    if (!badCert.hasExtensions()) continue;
                    this.version = 1;
                }
            }
        }

        public TBSCertList(X500Name issuer, Date thisDate, Date nextDate, X509CRLEntry[] badCerts, CRLExtensions crlExts) throws CRLException {
            this(issuer, thisDate, nextDate, badCerts);
            if (crlExts != null) {
                this.extensions = crlExts;
                this.version = 1;
            }
        }

        public TBSCertList(DerValue value) throws IOException, CRLException {
            if (value.tag != 48) {
                throw new CRLException("signed CRL fields invalid");
            }
            DerInputStream derStrm = value.data;
            this.version = 0;
            byte nextByte = (byte)derStrm.peekByte();
            if (nextByte == 2) {
                this.version = derStrm.getInteger();
                if (this.version != 1) {
                    throw new CRLException("Invalid version");
                }
            }
            DerValue tmp = derStrm.getDerValue();
            this.infoSigAlgId = AlgorithmId.parse(tmp);
            this.issuer = new X500Name(derStrm);
            if (this.issuer.isEmpty()) {
                throw new CRLException("Empty issuer DN not allowed in X509CRLs");
            }
            nextByte = (byte)derStrm.peekByte();
            if (nextByte == 23) {
                this.thisUpdate = derStrm.getUTCTime();
            } else if (nextByte == 24) {
                this.thisUpdate = derStrm.getGeneralizedTime();
            } else {
                throw new CRLException("Invalid encoding for thisUpdate (tag=" + nextByte + ")");
            }
            if (derStrm.available() == 0) {
                return;
            }
            nextByte = (byte)derStrm.peekByte();
            if (nextByte == 23) {
                this.nextUpdate = derStrm.getUTCTime();
            } else if (nextByte == 24) {
                this.nextUpdate = derStrm.getGeneralizedTime();
            }
            if (derStrm.available() == 0) {
                return;
            }
            nextByte = (byte)derStrm.peekByte();
            if (nextByte == 48) {
                X500Principal crlIssuer;
                DerValue[] badCerts = derStrm.getSequence(4);
                X500Principal badCertIssuer = crlIssuer = this.getIssuerX500Principal();
                for (int i = 0; i < badCerts.length; ++i) {
                    X509CRLEntryImpl entry = new X509CRLEntryImpl(badCerts[i]);
                    badCertIssuer = this.getCertIssuer(entry, badCertIssuer);
                    entry.setCertificateIssuer(crlIssuer, badCertIssuer);
                    X509IssuerSerial issuerSerial = new X509IssuerSerial(badCertIssuer, entry.getSerialNumber());
                    this.revokedMap.put(issuerSerial, entry);
                    this.revokedList.add(entry);
                }
            }
            if (derStrm.available() == 0) {
                return;
            }
            tmp = derStrm.getDerValue();
            if (tmp.isConstructed() && tmp.isContextSpecific((byte)0)) {
                this.extensions = new CRLExtensions(tmp.data);
            }
        }

        public X500Principal getIssuerX500Principal() {
            if (this.issuerPrincipal == null) {
                this.issuerPrincipal = this.issuer.asX500Principal();
            }
            return this.issuerPrincipal;
        }

        private X500Principal getCertIssuer(X509CRLEntryImpl entry, X500Principal prevCertIssuer) {
            CertificateIssuerExtension ciExt = entry.getCertificateIssuerExtension();
            if (ciExt != null) {
                GeneralNames names = ciExt.getNames();
                X500Name issuerDN = (X500Name)names.get(0).getName();
                return issuerDN.asX500Principal();
            }
            return prevCertIssuer;
        }

        public byte[] encodeInfo() throws CRLException {
            DerOutputStream tmp = new DerOutputStream();
            DerOutputStream rCerts = new DerOutputStream();
            DerOutputStream seq = new DerOutputStream();
            if (this.version != 0) {
                tmp.putInteger(this.version);
            }
            this.infoSigAlgId.encode(tmp);
            if (this.version == 0 && this.issuer.toString() == null) {
                throw new CRLException("Null Issuer DN not allowed in v1 CRL");
            }
            this.issuer.encode(tmp);
            if (this.thisUpdate.getTime() < 2524608000000L) {
                tmp.putUTCTime(this.thisUpdate);
            } else {
                tmp.putGeneralizedTime(this.thisUpdate);
            }
            if (this.nextUpdate != null) {
                if (this.nextUpdate.getTime() < 2524608000000L) {
                    tmp.putUTCTime(this.nextUpdate);
                } else {
                    tmp.putGeneralizedTime(this.nextUpdate);
                }
            }
            if (!this.revokedList.isEmpty()) {
                for (X509CRLEntry entry : this.revokedList) {
                    ((X509CRLEntryImpl)entry).encode(rCerts);
                }
                tmp.write((byte)48, rCerts);
            }
            if (this.extensions != null) {
                this.extensions.encode(tmp, true);
            }
            seq.write((byte)48, tmp);
            return seq.toByteArray();
        }
    }
}

