/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.impl.TimeoutTracker;
import com.microsoft.azure.eventhubs.impl.WorkItem;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

public class ReplayableWorkItem<T>
extends WorkItem<T> {
    private byte[] amqpMessage;
    private int messageFormat;
    private int encodedMessageSize;
    private boolean waitingForAck;
    private Exception lastKnownException;
    private CompletableFuture<?> timeoutTask;

    public ReplayableWorkItem(byte[] amqpMessage, int encodedMessageSize, int messageFormat, CompletableFuture<T> completableFuture, Duration timeout) {
        super(completableFuture, timeout);
        this.initialize(amqpMessage, encodedMessageSize, messageFormat);
    }

    public ReplayableWorkItem(byte[] amqpMessage, int encodedMessageSize, int messageFormat, CompletableFuture<T> completableFuture, TimeoutTracker timeout) {
        super(completableFuture, timeout);
        this.initialize(amqpMessage, encodedMessageSize, messageFormat);
    }

    private void initialize(byte[] amqpMessage, int encodedMessageSize, int messageFormat) {
        this.amqpMessage = amqpMessage;
        this.messageFormat = messageFormat;
        this.encodedMessageSize = encodedMessageSize;
    }

    public byte[] getMessage() {
        return this.amqpMessage;
    }

    public void clearMessage() {
        this.amqpMessage = null;
    }

    public int getEncodedMessageSize() {
        return this.encodedMessageSize;
    }

    public int getMessageFormat() {
        return this.messageFormat;
    }

    public Exception getLastKnownException() {
        return this.lastKnownException;
    }

    public void setLastKnownException(Exception exception) {
        this.lastKnownException = exception;
    }

    public CompletableFuture<?> getTimeoutTask() {
        return this.timeoutTask;
    }

    public void setTimeoutTask(CompletableFuture<?> timeoutTask) {
        this.timeoutTask = timeoutTask;
    }

    public void setWaitingForAck() {
        this.waitingForAck = true;
    }

    public boolean isWaitingForAck() {
        return this.waitingForAck;
    }
}

