/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.event;

import com.google.common.eventbus.Subscribe;
import com.nepxion.discovery.common.entity.RuleEntity;
import com.nepxion.discovery.common.entity.RuleType;
import com.nepxion.discovery.common.exception.DiscoveryException;
import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.framework.config.PluginConfigParser;
import com.nepxion.discovery.plugin.framework.context.PluginContextAware;
import com.nepxion.discovery.plugin.framework.event.PluginEventWapper;
import com.nepxion.discovery.plugin.framework.event.RuleClearedEvent;
import com.nepxion.discovery.plugin.framework.event.RuleFailureEvent;
import com.nepxion.discovery.plugin.framework.event.RuleUpdatedEvent;
import com.nepxion.discovery.plugin.framework.event.VersionClearedEvent;
import com.nepxion.discovery.plugin.framework.event.VersionUpdatedEvent;
import com.nepxion.discovery.plugin.framework.listener.loadbalance.LoadBalanceListenerExecutor;
import com.nepxion.eventbus.annotation.EventBus;
import com.netflix.loadbalancer.ZoneAwareLoadBalancer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@EventBus
public class PluginSubscriber {
    private static final Logger LOG = LoggerFactory.getLogger(PluginSubscriber.class);
    @Autowired
    private PluginContextAware pluginContextAware;
    @Autowired
    private PluginAdapter pluginAdapter;
    @Autowired
    private PluginConfigParser pluginConfigParser;
    @Autowired
    private PluginEventWapper pluginEventWapper;
    @Autowired
    private LoadBalanceListenerExecutor loadBalanceListenerExecutor;

    @Subscribe
    public void onRuleUpdated(RuleUpdatedEvent ruleUpdatedEvent) {
        Boolean discoveryControlEnabled = this.pluginContextAware.isDiscoveryControlEnabled();
        if (!discoveryControlEnabled.booleanValue()) {
            LOG.info("Discovery control is disabled, ignore to subscribe");
            return;
        }
        LOG.info("Rule updating has been triggered");
        if (ruleUpdatedEvent == null) {
            throw new DiscoveryException("RuleUpdatedEvent can't be null");
        }
        RuleType ruleType = ruleUpdatedEvent.getRuleType();
        String rule = ruleUpdatedEvent.getRule();
        try {
            RuleEntity ruleEntity = this.pluginConfigParser.parse(rule);
            switch (ruleType) {
                case DYNAMIC_GLOBAL_RULE: {
                    this.pluginAdapter.setDynamicGlobalRule(ruleEntity);
                    break;
                }
                case DYNAMIC_PARTIAL_RULE: {
                    this.pluginAdapter.setDynamicPartialRule(ruleEntity);
                }
            }
            this.pluginEventWapper.fireParameterChanged();
        }
        catch (Exception e) {
            LOG.error("Parse rule xml failed", (Throwable)e);
            this.pluginEventWapper.fireRuleFailure(new RuleFailureEvent(ruleType, rule, e));
            throw e;
        }
        this.refreshLoadBalancer();
    }

    @Subscribe
    public void onRuleCleared(RuleClearedEvent ruleClearedEvent) {
        Boolean discoveryControlEnabled = this.pluginContextAware.isDiscoveryControlEnabled();
        if (!discoveryControlEnabled.booleanValue()) {
            LOG.info("Discovery control is disabled, ignore to subscribe");
            return;
        }
        LOG.info("Rule clearing has been triggered");
        if (ruleClearedEvent == null) {
            throw new DiscoveryException("RuleClearedEvent can't be null");
        }
        RuleType ruleType = ruleClearedEvent.getRuleType();
        switch (ruleType) {
            case DYNAMIC_GLOBAL_RULE: {
                this.pluginAdapter.clearDynamicGlobalRule();
                break;
            }
            case DYNAMIC_PARTIAL_RULE: {
                this.pluginAdapter.clearDynamicPartialRule();
            }
        }
        this.pluginEventWapper.fireParameterChanged();
        this.refreshLoadBalancer();
    }

    @Subscribe
    public void onVersionUpdated(VersionUpdatedEvent versionUpdatedEvent) {
        Boolean discoveryControlEnabled = this.pluginContextAware.isDiscoveryControlEnabled();
        if (!discoveryControlEnabled.booleanValue()) {
            LOG.info("Discovery control is disabled, ignore to subscribe");
            return;
        }
        LOG.info("Version updating has been triggered");
        if (versionUpdatedEvent == null) {
            throw new DiscoveryException("VersionUpdatedEvent can't be null");
        }
        String dynamicVersion = versionUpdatedEvent.getDynamicVersion();
        String localVersion = versionUpdatedEvent.getLocalVersion();
        if (StringUtils.isEmpty((CharSequence)localVersion)) {
            this.pluginAdapter.setDynamicVersion(dynamicVersion);
            this.refreshLoadBalancer();
            LOG.info("Version has been updated, new version is {}", (Object)dynamicVersion);
        } else if (StringUtils.equals((CharSequence)this.pluginAdapter.getLocalVersion(), (CharSequence)localVersion)) {
            this.pluginAdapter.setDynamicVersion(dynamicVersion);
            this.refreshLoadBalancer();
            LOG.info("Version has been updated, new version is {}", (Object)dynamicVersion);
        } else {
            throw new DiscoveryException("Version updating will be ignored, because input localVersion=" + localVersion + ", current localVersion=" + this.pluginAdapter.getLocalVersion());
        }
    }

    @Subscribe
    public void onVersionCleared(VersionClearedEvent versionClearedEvent) {
        Boolean discoveryControlEnabled = this.pluginContextAware.isDiscoveryControlEnabled();
        if (!discoveryControlEnabled.booleanValue()) {
            LOG.info("Discovery control is disabled, ignore to subscribe");
            return;
        }
        LOG.info("Version clearing has been triggered");
        if (versionClearedEvent == null) {
            throw new DiscoveryException("VersionClearedEvent can't be null");
        }
        String localVersion = versionClearedEvent.getLocalVersion();
        if (StringUtils.isEmpty((CharSequence)localVersion)) {
            this.pluginAdapter.clearDynamicVersion();
            this.refreshLoadBalancer();
            LOG.info("Version has been cleared");
        } else if (StringUtils.equals((CharSequence)this.pluginAdapter.getLocalVersion(), (CharSequence)localVersion)) {
            this.pluginAdapter.clearDynamicVersion();
            this.refreshLoadBalancer();
            LOG.info("Version has been cleared");
        } else {
            throw new DiscoveryException("Version clearing will be ignored, because input localVersion=" + localVersion + ", current localVersion=" + this.pluginAdapter.getLocalVersion());
        }
    }

    private void refreshLoadBalancer() {
        ZoneAwareLoadBalancer<?> loadBalancer = this.loadBalanceListenerExecutor.getLoadBalancer();
        if (loadBalancer == null) {
            return;
        }
        loadBalancer.updateListOfServers();
    }
}

