/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.read.dao;

import com.oceanbase.jdbc.internal.com.read.resultset.ColumnDefinition;
import com.oceanbase.jdbc.internal.util.exceptions.ExceptionFactory;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class ColumnLabelIndexer {
    private final ColumnDefinition[] columnInfo;
    private Map<String, Integer> originalMap;
    private Map<String, Integer> aliasMap;
    private Map<String, Integer> columnMapCache;

    public ColumnLabelIndexer(ColumnDefinition[] columnDefinitions) {
        this.columnInfo = columnDefinitions;
        this.columnMapCache = new HashMap<String, Integer>();
    }

    public int getIndex(String name) throws SQLException {
        String tableName;
        int counter;
        AbstractMap map;
        if (name == null) {
            throw new SQLException("Column name cannot be null");
        }
        Integer res = this.columnMapCache.get(name);
        if (res != null) {
            return res;
        }
        if (this.aliasMap == null) {
            map = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            counter = 0;
            for (ColumnDefinition ci : this.columnInfo) {
                String columnAlias = ci.getName();
                if (columnAlias != null) {
                    map.putIfAbsent(columnAlias, counter);
                    tableName = ci.getTable();
                    if (tableName != null) {
                        map.putIfAbsent(tableName + "." + columnAlias, counter);
                    }
                }
                ++counter;
            }
            this.aliasMap = map;
        }
        if ((res = this.aliasMap.get(name)) != null) {
            this.columnMapCache.put(name, res);
            return res;
        }
        if (this.originalMap == null) {
            map = new HashMap();
            counter = 0;
            for (ColumnDefinition ci : this.columnInfo) {
                String columnRealName = ci.getOriginalName();
                if (columnRealName != null) {
                    map.putIfAbsent(columnRealName, counter);
                    tableName = ci.getOriginalTable();
                    if (tableName != null) {
                        map.putIfAbsent(tableName + "." + columnRealName, counter);
                    }
                }
                ++counter;
            }
            this.originalMap = map;
        }
        if ((res = this.originalMap.get(name)) == null) {
            HashMap<String, Integer> possible = new HashMap<String, Integer>();
            possible.putAll(this.aliasMap);
            possible.putAll(this.originalMap);
            throw ExceptionFactory.INSTANCE.create(String.format("No such column: '%s'. '%s' must be in %s", name, name, possible.keySet().toString()), "42S22", 1054);
        }
        return res;
    }
}

