/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.read.resultset.rowprotocol;

import com.oceanbase.jdbc.JDBC4ResultSet;
import com.oceanbase.jdbc.extend.datatype.BINARY_DOUBLE;
import com.oceanbase.jdbc.extend.datatype.BINARY_FLOAT;
import com.oceanbase.jdbc.extend.datatype.ComplexData;
import com.oceanbase.jdbc.extend.datatype.ComplexDataType;
import com.oceanbase.jdbc.extend.datatype.DataTypeUtilities;
import com.oceanbase.jdbc.extend.datatype.INTERVALDS;
import com.oceanbase.jdbc.extend.datatype.INTERVALYM;
import com.oceanbase.jdbc.extend.datatype.NUMBER;
import com.oceanbase.jdbc.extend.datatype.NUMBER_FLOAT;
import com.oceanbase.jdbc.extend.datatype.TIMESTAMP;
import com.oceanbase.jdbc.extend.datatype.TIMESTAMPLTZ;
import com.oceanbase.jdbc.extend.datatype.TIMESTAMPTZ;
import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.com.read.resultset.ColumnDefinition;
import com.oceanbase.jdbc.internal.com.read.resultset.rowprotocol.RowProtocol;
import com.oceanbase.jdbc.internal.util.Utils;
import com.oceanbase.jdbc.internal.util.exceptions.ExceptionFactory;
import com.oceanbase.jdbc.util.Options;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class TextRowProtocol
extends RowProtocol {
    public TextRowProtocol(int maxFieldSize, Options options) {
        super(maxFieldSize, options);
    }

    @Override
    public void setPosition(int newIndex, JDBC4ResultSet resultSet) throws SQLException {
        if (this.index != newIndex) {
            if (this.index == -1 || this.index > newIndex) {
                this.pos = 0;
                this.index = 0;
            } else {
                ++this.index;
                if (this.length != -1) {
                    this.pos += this.length;
                }
            }
            while (this.index <= newIndex) {
                int type;
                if (this.index != newIndex) {
                    type = this.buf[this.pos++] & 0xFF;
                    switch (type) {
                        case 251: {
                            break;
                        }
                        case 252: {
                            this.pos += 2 + (0xFFFF & (this.buf[this.pos] & 0xFF) + ((this.buf[this.pos + 1] & 0xFF) << 8));
                            break;
                        }
                        case 253: {
                            this.pos += 3 + (0xFFFFFF & (this.buf[this.pos] & 0xFF) + ((this.buf[this.pos + 1] & 0xFF) << 8) + ((this.buf[this.pos + 2] & 0xFF) << 16));
                            break;
                        }
                        case 254: {
                            this.pos = (int)((long)this.pos + (8L + ((long)(this.buf[this.pos] & 0xFF) + ((long)(this.buf[this.pos + 1] & 0xFF) << 8) + ((long)(this.buf[this.pos + 2] & 0xFF) << 16) + ((long)(this.buf[this.pos + 3] & 0xFF) << 24) + ((long)(this.buf[this.pos + 4] & 0xFF) << 32) + ((long)(this.buf[this.pos + 5] & 0xFF) << 40) + ((long)(this.buf[this.pos + 6] & 0xFF) << 48) + ((long)(this.buf[this.pos + 7] & 0xFF) << 56))));
                            break;
                        }
                        default: {
                            this.pos += type;
                            break;
                        }
                    }
                } else {
                    type = this.buf[this.pos++] & 0xFF;
                    switch (type) {
                        case 251: {
                            this.length = -1;
                            this.lastValueNull = 1;
                            return;
                        }
                        case 252: {
                            this.length = 0xFFFF & (this.buf[this.pos++] & 0xFF) + ((this.buf[this.pos++] & 0xFF) << 8);
                            break;
                        }
                        case 253: {
                            this.length = 0xFFFFFF & (this.buf[this.pos++] & 0xFF) + ((this.buf[this.pos++] & 0xFF) << 8) + ((this.buf[this.pos++] & 0xFF) << 16);
                            break;
                        }
                        case 254: {
                            this.length = (int)((long)(this.buf[this.pos++] & 0xFF) + ((long)(this.buf[this.pos++] & 0xFF) << 8) + ((long)(this.buf[this.pos++] & 0xFF) << 16) + ((long)(this.buf[this.pos++] & 0xFF) << 24) + ((long)(this.buf[this.pos++] & 0xFF) << 32) + ((long)(this.buf[this.pos++] & 0xFF) << 40) + ((long)(this.buf[this.pos++] & 0xFF) << 48) + ((long)(this.buf[this.pos++] & 0xFF) << 56));
                            break;
                        }
                        default: {
                            this.length = type;
                        }
                    }
                    this.lastValueNull = 0;
                    return;
                }
                ++this.index;
            }
        }
        this.lastValueNull = this.length == -1 ? 1 : 0;
    }

    @Override
    public String getInternalString(ColumnDefinition columnInfo, Calendar cal, TimeZone timeZone) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        switch (columnInfo.getColumnType()) {
            case BIT: {
                return String.valueOf(this.parseBit());
            }
            case DOUBLE: 
            case FLOAT: {
                return this.zeroFillingIfNeeded(new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())), columnInfo);
            }
            case NUMBER_FLOAT: 
            case DECIMAL: 
            case OLDDECIMAL: 
            case OBDECIMAL: {
                BigDecimal bigDecimal = this.getInternalBigDecimal(columnInfo);
                return bigDecimal == null ? null : this.zeroFillingIfNeeded(bigDecimal.toString(), columnInfo);
            }
            case BINARY_FLOAT: {
                Double d;
                if (this.getProtocol().isOracleMode() && (d = this.getNanAndInfForOracle(columnInfo)) != null) {
                    return Float.valueOf(this.getNanAndInfForOracle(columnInfo).floatValue()).toString();
                }
                Float f = Float.valueOf(new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())));
                return Float.toString(f.floatValue());
            }
            case BINARY_DOUBLE: {
                Double d;
                if (this.getProtocol().isOracleMode() && (d = this.getNanAndInfForOracle(columnInfo)) != null) {
                    return Double.toString(d);
                }
                d = Double.valueOf(new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())));
                return Double.toString(d);
            }
            case TIME: {
                return this.getInternalTimeString(columnInfo);
            }
            case DATE: {
                Date date;
                try {
                    this.handleZeroDateException(columnInfo, Date.class);
                }
                catch (SQLException e) {
                    if (!this.getProtocol().isOracleMode() && this.options.compatibleMysqlVersion == 8) {
                        return "0000-00-00";
                    }
                    throw e;
                }
                if (!this.getProtocol().isOracleMode() && this.options.compatibleMysqlVersion == 8) {
                    this.useCalLenientFlag = true;
                }
                if ((date = this.getInternalDate(columnInfo, cal, TimeZone.getDefault())) == null) {
                    if ((this.lastValueNull & 2) != 0) {
                        this.lastValueNull ^= 2;
                        return new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
                    }
                    return null;
                }
                String dateStr = date.toString();
                if (!this.getProtocol().isOracleMode() && this.options.compatibleMysqlVersion == 8 && this.yearIsZero) {
                    this.yearIsZero = false;
                    String[] split = dateStr.split("-");
                    if ("0001".equals(split[0])) {
                        dateStr = dateStr.replaceFirst("0001", "0000");
                    }
                }
                return dateStr;
            }
            case YEAR: {
                String tempYear = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
                if ("0000".equals(tempYear) && this.options.compatibleMysqlVersion == 5 && this.options.yearIsDateType) {
                    return "0001-01-01";
                }
                if (this.options.yearIsDateType) {
                    Date date1 = this.getInternalDate(columnInfo, cal, TimeZone.getDefault());
                    return date1 == null ? null : date1.toString();
                }
                if (this.options.compatibleMysqlVersion != 8 || !"0000".equals(tempYear)) break;
                return "0";
            }
            case TIMESTAMP: 
            case TIMESTAMP_NANO: 
            case DATETIME: {
                if (columnInfo.getColumnType() == ColumnType.DATETIME && !this.options.mapDateToTimestamp && this.getProtocol().isOracleMode()) {
                    Date dateInter = this.getInternalDate(columnInfo, cal, TimeZone.getDefault());
                    return dateInter == null ? null : dateInter.toString();
                }
                Timestamp timestamp = null;
                if (!this.getProtocol().isOracleMode() && this.options.compatibleMysqlVersion == 8) {
                    this.useCalLenientFlag = true;
                }
                try {
                    if (!this.getProtocol().isOracleMode()) {
                        Calendar newCal = this.getCalendarInstance(cal);
                        if (!this.options.useLegacyDatetimeCode && this.options.compatibleMysqlVersion == 5) {
                            newCal = this.getCalendarInstanceWithTimezone(cal, timeZone);
                        }
                        timestamp = this.getInternalTimestamp(columnInfo, newCal, timeZone);
                    } else {
                        timestamp = this.getInternalTimestamp(columnInfo, cal, TimeZone.getDefault());
                    }
                }
                catch (SQLException sqlex) {
                    if (sqlex.getMessage().equals("Zero date value prohibited") && !this.getProtocol().isOracleMode() && this.options.compatibleMysqlVersion == 8) {
                        return "0000-00-00 00:00:00";
                    }
                    throw sqlex;
                }
                if (timestamp == null) {
                    if (!this.getProtocol().isOracleMode() && this.options.compatibleMysqlVersion == 8) {
                        return "0000-00-00 00:00:00";
                    }
                    if ((this.lastValueNull & 2) != 0) {
                        this.lastValueNull ^= 2;
                    }
                    return null;
                }
                if (this.getProtocol().isOracleMode()) {
                    LocalDateTime localDateTime = timestamp.toLocalDateTime();
                    int nano = localDateTime.getNano();
                    if (nano == 0 && (columnInfo.getColumnType() == ColumnType.TIMESTAMP_NANO || this.options.compatibleOjdbcVersion == 8)) {
                        nano = -1;
                    }
                    String str = DataTypeUtilities.TIMESTAMPTZToString(localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond(), nano, 0, null);
                    return str;
                }
                if (this.options.compatibleMysqlVersion == 8 && columnInfo.getLength() >= 19L) {
                    String[] timeSplit = timestamp.toString().split("\\.");
                    String datetime = timeSplit[0];
                    StringBuilder millisecond = new StringBuilder(timeSplit[1]);
                    if (!millisecond.toString().matches("0+")) {
                        for (int i = millisecond.length(); i < columnInfo.getPrimitiveDecimals(); ++i) {
                            millisecond.append(0);
                        }
                        datetime = datetime + "." + millisecond;
                    }
                    if (this.yearIsZero) {
                        this.yearIsZero = false;
                        String[] split = datetime.split("-");
                        if ("0001".equals(split[0])) {
                            datetime = datetime.replaceFirst("0001", "0000");
                        }
                    }
                    return datetime;
                }
                return timestamp.toString();
            }
            case INTERVALDS: {
                INTERVALDS intervalds = this.getInternalINTERVALDS(columnInfo);
                return intervalds.toString();
            }
            case INTERVALYM: {
                INTERVALYM intervalym = this.getInternalINTERVALYM(columnInfo);
                return intervalym.toString();
            }
            case NULL: {
                return null;
            }
            case RAW: {
                byte[] data = new byte[this.length];
                System.arraycopy(this.buf, this.pos, data, 0, this.length);
                if (data != null) {
                    boolean wasNullFlag = false;
                    return Utils.toHexString(data);
                }
                boolean wasNullFlag = true;
                return null;
            }
        }
        if (this.maxFieldSize > 0) {
            return new String(this.buf, this.pos, Math.min(this.maxFieldSize * 3, this.length), this.getCurrentEncoding(columnInfo.getColumnType())).substring(0, Math.min(this.maxFieldSize, this.length));
        }
        return new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
    }

    @Override
    public int getInternalInt(ColumnDefinition columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return 0;
        }
        switch (columnInfo.getColumnType()) {
            case FLOAT: {
                float internalFloat = this.getInternalFloat(columnInfo);
                this.rangeCheck(Integer.class, -2.147483648E9, 2.147483647E9, internalFloat, columnInfo);
                return (int)internalFloat;
            }
            case DOUBLE: {
                double internalDouble = this.getInternalDouble(columnInfo);
                this.rangeCheck(Integer.class, -2.147483648E9, 2.147483647E9, internalDouble, columnInfo);
                return (int)internalDouble;
            }
            case DECIMAL: 
            case OLDDECIMAL: 
            case OBDECIMAL: {
                BigDecimal bigDecimal = this.getInternalBigDecimal(columnInfo);
                this.rangeCheck(Integer.class, -2.147483648E9, 2.147483647E9, bigDecimal.doubleValue(), columnInfo);
                return bigDecimal.intValue();
            }
            case NUMBER_FLOAT: {
                BigDecimal value = this.getInternalBigDecimal(columnInfo);
                this.rangeCheck(Integer.class, Integer.MIN_VALUE, Integer.MAX_VALUE, value, columnInfo);
                return value.intValue();
            }
            case BINARY_FLOAT: 
            case BINARY_DOUBLE: {
                double internalDouble = this.getInternalDouble(columnInfo);
                return (int)internalDouble;
            }
        }
        Long longValue = this.getInternalLongUtil(columnInfo, Integer.class, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.rangeCheck(Integer.class, -2.147483648E9, 2.147483647E9, longValue.longValue(), columnInfo);
        return longValue.intValue();
    }

    @Override
    public long getInternalLong(ColumnDefinition columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return 0L;
        }
        long value = this.getInternalLongUtil(columnInfo, Long.class, Long.MIN_VALUE, Long.MAX_VALUE);
        return value;
    }

    public long getInternalLongUtil(ColumnDefinition columnInfo, Object className, long minValue, long maxValue) throws SQLException {
        if (this.lastValueWasNull()) {
            return 0L;
        }
        try {
            switch (columnInfo.getColumnType()) {
                case FLOAT: {
                    Float floatValue = Float.valueOf(new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())));
                    this.rangeCheck(Long.class, -9.223372036854776E18, 9.223372036854776E18, floatValue.floatValue(), columnInfo);
                    return floatValue.longValue();
                }
                case NUMBER_FLOAT: {
                    BigDecimal bigDecimal = this.getInternalBigDecimal(columnInfo);
                    this.rangeCheck(Long.class, Long.MIN_VALUE, Long.MAX_VALUE, bigDecimal, columnInfo);
                    return bigDecimal.longValue();
                }
                case BINARY_FLOAT: 
                case BINARY_DOUBLE: {
                    double internalDouble = this.getInternalDouble(columnInfo);
                    return (long)internalDouble;
                }
                case DOUBLE: {
                    Double doubleValue = Double.valueOf(new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())));
                    this.rangeCheck(Long.class, -9.223372036854776E18, 9.223372036854776E18, doubleValue, columnInfo);
                    return doubleValue.longValue();
                }
                case BIT: {
                    return this.parseBit();
                }
                case YEAR: 
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: 
                case MEDIUMINT: 
                case BIGINT: {
                    long result = 0L;
                    boolean negate = false;
                    int begin = this.pos;
                    if (this.length > 0 && this.buf[begin] == 45) {
                        negate = true;
                        ++begin;
                    }
                    while (begin < this.pos + this.length) {
                        result = result * 10L + (long)this.buf[begin] - 48L;
                        ++begin;
                    }
                    if (result < 0L) {
                        if (result == Long.MIN_VALUE && negate) {
                            return Long.MIN_VALUE;
                        }
                        throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' for value " + new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())), "22003", 1264);
                    }
                    return negate ? -1L * result : result;
                }
                case VARSTRING: 
                case VARCHAR: 
                case STRING: 
                case VARCHAR2: 
                case NVARCHAR2: {
                    if (this.length != 0) break;
                    return this.convertToZeroWithEmptyCheck();
                }
            }
            return Long.parseLong(new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())).trim());
        }
        catch (NumberFormatException nfe) {
            Object exceptionTmp = null;
            String value = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
            if (isIntegerRegex.matcher(value).find()) {
                try {
                    return Long.parseLong(value.substring(0, value.indexOf(".")));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            try {
                double doubleVal = Double.parseDouble(value);
                this.rangeCheck(className, (double)minValue, (double)maxValue, doubleVal, columnInfo);
                return (long)doubleVal;
            }
            catch (NumberFormatException e) {
                throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + value, "22003", 1264);
            }
        }
    }

    @Override
    public float getInternalFloat(ColumnDefinition columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return 0.0f;
        }
        switch (columnInfo.getColumnType()) {
            case BIT: {
                return this.parseBit();
            }
            case VARSTRING: 
            case VARCHAR: 
            case STRING: 
            case VARCHAR2: 
            case NVARCHAR2: {
                if (this.length == 0) {
                    return this.convertToZeroWithEmptyCheck();
                }
            }
            case DOUBLE: 
            case FLOAT: 
            case NUMBER_FLOAT: 
            case DECIMAL: 
            case OLDDECIMAL: 
            case BINARY_FLOAT: 
            case YEAR: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case MEDIUMINT: 
            case BIGINT: {
                try {
                    Double d;
                    if (this.getProtocol().isOracleMode() && (d = this.getNanAndInfForOracle(columnInfo)) != null) {
                        return d.floatValue();
                    }
                    return Float.valueOf(new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()))).floatValue();
                }
                catch (NumberFormatException nfe) {
                    SQLException sqlException = new SQLException("Incorrect format \"" + new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())) + "\" for getFloat for data field with type " + columnInfo.getColumnType().getSqlTypeName(), "22003", 1264);
                    sqlException.initCause(nfe);
                    throw sqlException;
                }
            }
            case OBDECIMAL: {
                String value = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())).trim();
                BigDecimal bigDecimal = new BigDecimal(value);
                return bigDecimal.floatValue();
            }
        }
        throw new SQLException("getFloat not available for data field type " + columnInfo.getColumnType().getSqlTypeName());
    }

    @Override
    public double getInternalDouble(ColumnDefinition columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return 0.0;
        }
        switch (columnInfo.getColumnType()) {
            case BIT: {
                return this.parseBit();
            }
            case VARSTRING: 
            case VARCHAR: 
            case STRING: 
            case VARCHAR2: 
            case NVARCHAR2: {
                if (this.length == 0) {
                    return this.convertToZeroWithEmptyCheck();
                }
            }
            case DOUBLE: 
            case FLOAT: 
            case DECIMAL: 
            case OLDDECIMAL: 
            case BINARY_DOUBLE: 
            case YEAR: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case MEDIUMINT: 
            case BIGINT: {
                try {
                    Double d;
                    if (this.getProtocol().isOracleMode() && (d = this.getNanAndInfForOracle(columnInfo)) != null) {
                        return d;
                    }
                    return Double.valueOf(new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())));
                }
                catch (NumberFormatException nfe) {
                    SQLException sqlException = new SQLException("Incorrect format \"" + new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())) + "\" for getDouble for data field with type " + columnInfo.getColumnType().getSqlTypeName(), "22003", 1264);
                    sqlException.initCause(nfe);
                    throw sqlException;
                }
            }
            case BINARY_FLOAT: {
                Double d;
                if (this.getProtocol().isOracleMode() && (d = this.getNanAndInfForOracle(columnInfo)) != null) {
                    return d;
                }
                return Float.valueOf(new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()))).floatValue();
            }
            case NUMBER_FLOAT: 
            case OBDECIMAL: {
                String value = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
                BigDecimal bigDecimal = new BigDecimal(value);
                return bigDecimal.doubleValue();
            }
        }
        throw new SQLException("getDouble not available for data field type " + columnInfo.getColumnType().getSqlTypeName());
    }

    @Override
    public BigDecimal getInternalBigDecimal(ColumnDefinition columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        switch (columnInfo.getColumnType()) {
            case BIT: {
                return BigDecimal.valueOf(this.parseBit());
            }
            case BINARY_FLOAT: {
                Float f = Float.valueOf(new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())));
                return new BigDecimal(f.toString());
            }
            case BINARY_DOUBLE: {
                Double d = Double.valueOf(new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())));
                return BigDecimal.valueOf(d);
            }
            case VARSTRING: 
            case VARCHAR: 
            case STRING: 
            case VARCHAR2: 
            case NVARCHAR2: {
                if (this.length != 0) break;
                return BigDecimal.valueOf(this.convertToZeroWithEmptyCheck());
            }
        }
        String value = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())).trim();
        try {
            BigDecimal retVal = new BigDecimal(value);
            return retVal;
        }
        catch (Exception e) {
            throw new SQLException("Bad format for BigDecimal '" + value + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Date getInternalDate(ColumnDefinition columnInfo, Calendar cal, TimeZone timeZone) throws SQLException {
        try {
            if (this.lastValueWasNull()) {
                return null;
            }
            if (this.getProtocol().isOracleMode()) {
                if (columnInfo.getColumnType() == ColumnType.INTERVALYM) throw new SQLException("Invalid column type, getDate not implemented for this type.");
                if (columnInfo.getColumnType() == ColumnType.INTERVALDS) {
                    throw new SQLException("Invalid column type, getDate not implemented for this type.");
                }
            }
            switch (columnInfo.getColumnType()) {
                case DATE: {
                    int[] datePart = new int[]{0, 0, 0};
                    int partIdx = 0;
                    for (int begin = this.pos; begin < this.pos + this.length; ++begin) {
                        byte b = this.buf[begin];
                        if (b == 45) {
                            ++partIdx;
                            continue;
                        }
                        if (b < 48) throw new SQLException("cannot parse data in date string '" + new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())) + "'");
                        if (b > 57) {
                            throw new SQLException("cannot parse data in date string '" + new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())) + "'");
                        }
                        datePart[partIdx] = datePart[partIdx] * 10 + b - 48;
                    }
                    if (datePart[0] == 0 && datePart[1] == 0 && datePart[2] == 0) {
                        if (this.options.zeroDateTimeBehavior.equalsIgnoreCase("exception")) {
                            if (this.getProtocol().isOracleMode()) throw new SQLException("Value '" + new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())) + "' can not be represented as java.sql.Date");
                            if (this.options.compatibleMysqlVersion != 8) throw new SQLException("Value '" + new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())) + "' can not be represented as java.sql.Date");
                            throw new SQLException("Zero date value prohibited");
                        }
                        this.lastValueNull |= 2;
                        return null;
                    }
                    if (!this.getProtocol().isOracleMode() && this.options.compatibleMysqlVersion == 8 && datePart[0] == 0) {
                        if (!this.useCalLenientFlag) {
                            throw new SQLException("ILLEGAL YEAR");
                        }
                        this.useCalLenientFlag = false;
                        this.yearIsZero = true;
                        return new Date(datePart[0] - 1900, datePart[1] - 1, datePart[2]);
                    }
                    this.yearIsZero = false;
                    return new Date(datePart[0] - 1900, datePart[1] - 1, datePart[2]);
                }
                case TIMESTAMP: 
                case TIMESTAMP_NANO: 
                case DATETIME: 
                case TIMESTAMP_LTZ: {
                    Timestamp timestamp;
                    if (!this.getProtocol().isOracleMode()) {
                        this.handleZeroDateException(columnInfo, Date.class);
                    }
                    if ((timestamp = this.getInternalTimestamp(columnInfo, cal, timeZone)) == null) {
                        return null;
                    }
                    if (timestamp == null) return new Date(timestamp.getTime());
                    if (!this.getProtocol().isOracleMode()) return new Date(timestamp.getTime());
                    timestamp.setNanos(0);
                    if (this.options.compatibleOjdbcVersion != 6) return new Date(timestamp.getTime());
                    timestamp.setHours(0);
                    timestamp.setMinutes(0);
                    timestamp.setSeconds(0);
                    return new Date(timestamp.getTime());
                }
                case TIMESTAMP_TZ: {
                    TIMESTAMPTZ timestamptz = this.getInternalTIMESTAMPTZ(columnInfo, cal, timeZone);
                    if (timestamptz != null) return timestamptz.dateValue();
                    return null;
                }
                case TIME: {
                    if (this.length != 0) {
                        Calendar dateCal;
                        int year = 0;
                        int month = 0;
                        int day = 0;
                        byte hour = 0;
                        byte minute = 0;
                        byte seconds = 0;
                        if (this.length != 0) {
                            hour = this.buf[this.pos + 5];
                            minute = this.buf[this.pos + 6];
                            seconds = this.buf[this.pos + 7];
                        }
                        year = 1970;
                        month = 1;
                        day = 1;
                        Calendar calendar = dateCal = this.getCalendarInstance(cal);
                        synchronized (calendar) {
                            java.util.Date origCalDate = dateCal.getTime();
                            try {
                                dateCal.clear();
                                dateCal.set(14, 0);
                                dateCal.set(year, month - 1, day, 0, 0, 0);
                                long dateAsMillis = dateCal.getTimeInMillis();
                                Date date = new Date(dateAsMillis);
                                return date;
                            }
                            finally {
                                dateCal.setTime(origCalDate);
                            }
                        }
                    }
                }
                case YEAR: {
                    if (!this.getProtocol().isOracleMode() && this.options.compatibleMysqlVersion == 5) {
                        this.handleZeroDateException(columnInfo, Date.class);
                    }
                    int year = 0;
                    for (int begin = this.pos; begin < this.pos + this.length; ++begin) {
                        year = year * 10 + this.buf[begin] - 48;
                    }
                    if (this.length == 2 && columnInfo.getLength() == 2L) {
                        year = year <= 69 ? (year += 2000) : (year += 1900);
                    }
                    if (this.options.compatibleMysqlVersion != 8) return new Date(year - 1900, 0, 1);
                    if (year >= 100) return new Date(year - 1900, 0, 1);
                    if (year <= 69) {
                        year += 100;
                    }
                    year += 1900;
                    return new Date(year - 1900, 0, 1);
                }
            }
            ColumnType type = columnInfo.getColumnType();
            if (!this.getProtocol().isOracleMode()) {
                if (type == ColumnType.STRING) return this.getDateFromString(new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())), cal, columnInfo);
                if (type == ColumnType.VARCHAR) return this.getDateFromString(new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())), cal, columnInfo);
                if (type == ColumnType.VARSTRING) {
                    return this.getDateFromString(new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())), cal, columnInfo);
                }
            }
            try {
                String s = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
                if (this.getProtocol().isOracleMode()) {
                    return Date.valueOf(s.trim());
                }
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                sdf.setTimeZone(timeZone);
                java.util.Date utilDate = sdf.parse(s);
                return new Date(utilDate.getTime());
            }
            catch (ParseException e) {
                throw ExceptionFactory.INSTANCE.create("Could not get object as Date : " + e.getMessage(), "S1009", e);
            }
        }
        catch (SQLException sqlException) {
            throw sqlException;
        }
        catch (IllegalArgumentException e) {
            throw new SQLException("bad format, " + e.getMessage());
        }
        catch (Exception e) {
            SQLException sqlException = new SQLException("Bad format for DATE " + new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())));
            sqlException.initCause(e);
            throw sqlException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Time getInternalTime(ColumnDefinition columnInfo, Calendar cal, TimeZone timeZone) throws SQLException {
        try {
            String[] rawPart;
            if (this.lastValueWasNull()) {
                return null;
            }
            if (this.getProtocol().isOracleMode()) {
                if (columnInfo.getColumnType() == ColumnType.INTERVALYM) throw new SQLException("Invalid column type, getTime not implemented for this type.");
                if (columnInfo.getColumnType() == ColumnType.INTERVALDS) {
                    throw new SQLException("Invalid column type, getTime not implemented for this type.");
                }
            }
            if (columnInfo.getColumnType() == ColumnType.TIMESTAMP || columnInfo.getColumnType() == ColumnType.TIMESTAMP_NANO || columnInfo.getColumnType() == ColumnType.DATETIME || columnInfo.getColumnType() == ColumnType.TIMESTAMP_TZ || columnInfo.getColumnType() == ColumnType.TIMESTAMP_LTZ) {
                Timestamp timestamp;
                if (!this.getProtocol().isOracleMode()) {
                    this.handleZeroDateException(columnInfo, Time.class);
                }
                if (!this.getProtocol().isOracleMode() && this.options.compatibleMysqlVersion == 8) {
                    this.useCalLenientFlag = true;
                }
                if (!this.getProtocol().isOracleMode()) {
                    cal = this.getCalendarInstance(cal);
                }
                if ((timestamp = this.getInternalTimestamp(columnInfo, cal, timeZone)) == null) {
                    return null;
                }
                Time time = new Time(timestamp.getTime());
                return time;
            }
            if (columnInfo.getColumnType() == ColumnType.DATE || columnInfo.getColumnType() == ColumnType.YEAR && this.options.compatibleMysqlVersion == 8) {
                Calendar calendar;
                if (this.length == 0) throw new SQLException("Cannot read Time using a Types.DATE field");
                this.handleZeroDateException(columnInfo, Time.class);
                Calendar calendar2 = calendar = this.getCalendarInstance(cal);
                synchronized (calendar2) {
                    java.util.Date origCalDate = calendar.getTime();
                    try {
                        calendar.clear();
                        Time time = new Time(calendar.getTimeInMillis());
                        return time;
                    }
                    finally {
                        calendar.setTime(origCalDate);
                    }
                }
            }
            String raw = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())).trim();
            if (!this.getProtocol().isOracleMode()) {
                try {
                    if (this.options.compatibleMysqlVersion != 8) return this.getTimeFromString(raw, cal);
                    Timestamp timestampFromString = this.getTimestampFromString(columnInfo, raw, cal = this.getCalendarInstance(cal), timeZone);
                    if (timestampFromString == null) {
                        return null;
                    }
                    Time time = new Time(timestampFromString.getTime());
                    return time;
                }
                catch (SQLException e) {
                    throw new SQLException("Time format \"" + raw + "\" incorrect, must be HH:mm:ss");
                }
            }
            Pattern pattern = Pattern.compile("^(?:(\\d{4}-\\d{2}-\\d{2})\\s)?\\d{2}:\\d{2}:\\d{2}$");
            if (!this.options.useLegacyDatetimeCode && !pattern.matcher(raw).find()) {
                throw new SQLException("Time format \"" + raw + "\" incorrect, must be HH:mm:ss");
            }
            boolean negate = raw.startsWith("-");
            if (negate) {
                raw = raw.substring(1);
            }
            if ((rawPart = raw.split(":")).length != 3) throw new SQLException(raw + " cannot be parse as time. time must have \"99:99:99\" format");
            int hour = Integer.parseInt(rawPart[0]);
            int minutes = Integer.parseInt(rawPart[1]);
            int seconds = Integer.parseInt(rawPart[2].substring(0, 2));
            Calendar calendar = this.getCalendarInstance(cal);
            if (this.options.useLegacyDatetimeCode) {
                calendar.setLenient(true);
            }
            calendar.clear();
            calendar.set(1970, 0, 1, (negate ? -1 : 1) * hour, minutes, seconds);
            int nanoseconds = this.extractNanos(raw);
            calendar.set(14, nanoseconds / 1000000);
            return new Time(calendar.getTimeInMillis());
        }
        catch (SQLException e) {
            if (!e.getMessage().equals("Zero date value prohibited")) throw e;
            if (this.getProtocol().isOracleMode()) throw e;
            if (this.options.compatibleMysqlVersion != 8) throw e;
            return Time.valueOf("00:00:00");
        }
        catch (IllegalArgumentException e) {
            if (this.getProtocol().isOracleMode()) {
                throw new SQLException("Time format incorrect, must be HH:mm:ss");
            }
            SQLException sqlException = new SQLException("Cannot convert value " + new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())) + " to TIMESTAMP.");
            sqlException.initCause(e);
            throw sqlException;
        }
    }

    @Override
    public Timestamp getInternalTimestamp(ColumnDefinition columnInfo, Calendar userCalendar, TimeZone timeZone) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.getProtocol().isOracleMode()) {
            if (columnInfo.getColumnType() == ColumnType.INTERVALYM || columnInfo.getColumnType() == ColumnType.INTERVALDS) {
                throw new SQLException("Invalid column type, getTimestamp not implemented for this type.");
            }
            TIMESTAMP timestamp = null;
            switch (columnInfo.getColumnType()) {
                case TIMESTAMP_TZ: {
                    Calendar cal = this.getCalendarInstanceWithTimezone(userCalendar, timeZone);
                    TIMESTAMPTZ oracleTimestampZ = this.getInternalTIMESTAMPTZ(columnInfo, userCalendar, timeZone);
                    timestamp = TIMESTAMPTZ.toTIMESTAMP(this.getProtocol(), oracleTimestampZ.toBytes());
                    return timestamp.timestampValue(cal);
                }
                case TIMESTAMP_LTZ: {
                    Calendar cal = this.getCalendarInstanceWithTimezone(userCalendar, timeZone);
                    TIMESTAMPLTZ oracleTimestampLTZ = this.getInternalTIMESTAMPLTZ(columnInfo, userCalendar, timeZone);
                    timestamp = TIMESTAMPLTZ.toTIMESTAMP(this.getProtocol(), oracleTimestampLTZ.getBytes());
                    return timestamp.timestampValue(cal);
                }
                case STRING: 
                case VARCHAR2: 
                case NVARCHAR2: 
                case NCHAR: {
                    try {
                        return Timestamp.valueOf(new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())).trim());
                    }
                    catch (Exception e) {
                        throw new SQLException("bad format, " + e.getMessage());
                    }
                }
            }
        }
        switch (columnInfo.getColumnType()) {
            case DATE: 
            case TIMESTAMP: 
            case DATETIME: 
            case VARSTRING: 
            case VARCHAR: 
            case STRING: 
            case VARCHAR2: {
                if (!this.getProtocol().isOracleMode()) {
                    ColumnType type = columnInfo.getColumnType();
                    userCalendar = this.options.compatibleMysqlVersion == 5 && !this.options.useLegacyDatetimeCode || this.options.compatibleMysqlVersion == 8 && type != ColumnType.DATE ? this.getCalendarInstanceWithTimezone(userCalendar, timeZone) : this.getCalendarInstance(userCalendar);
                }
                if (this.options.obDateTypeOptimization) {
                    return this.getTimestampFromBytes(columnInfo, userCalendar, timeZone);
                }
                String rawValue = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
                return this.getTimestampFromString(columnInfo, rawValue, userCalendar, timeZone);
            }
            case TIME: {
                String rawValue = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
                if (!this.getProtocol().isOracleMode()) {
                    userCalendar = this.options.compatibleMysqlVersion == 5 && !this.options.useLegacyDatetimeCode ? this.getCalendarInstanceWithTimezone(userCalendar, timeZone) : this.getCalendarInstance(userCalendar);
                }
                Timestamp tt = new Timestamp(this.getInternalTime(columnInfo, userCalendar, TimeZone.getDefault()).getTime());
                tt.setNanos(this.extractNanos(rawValue));
                return tt;
            }
            case TIMESTAMP_NANO: {
                Calendar cal = this.getCalendarInstance(userCalendar);
                return this.getInternalTIMESTAMP(columnInfo, userCalendar, TimeZone.getDefault()).timestampValue(cal);
            }
            case YEAR: {
                if (!this.getProtocol().isOracleMode() && this.options.compatibleMysqlVersion == 5) {
                    this.handleZeroDateException(columnInfo, Timestamp.class);
                }
                Date date = this.getInternalDate(columnInfo, userCalendar, TimeZone.getDefault());
                return new Timestamp(date.getTime());
            }
        }
        String value = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
        throw new SQLException("Value type \"" + columnInfo.getColumnType().getTypeName() + "\" with value \"" + value + "\" cannot be parse as Timestamp");
    }

    @Override
    public Array getInternalArray(ColumnDefinition columnInfo, ComplexDataType complexDataType, Connection connection) throws SQLException {
        return null;
    }

    @Override
    public Struct getInternalStruct(ColumnDefinition columnInfo, ComplexDataType complexDataType, Connection connection) throws SQLException {
        return null;
    }

    @Override
    public ComplexData getInternalComplexCursor(ColumnDefinition columnInfo, ComplexDataType complexDataType, Connection connection) throws SQLException {
        return null;
    }

    @Override
    public Object getInternalObject(ColumnDefinition columnInfo, TimeZone timeZone) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        switch (columnInfo.getColumnType()) {
            case BIT: {
                if (columnInfo.getLength() == 1L) {
                    return this.buf[this.pos] != 0;
                }
                byte[] dataBit = new byte[this.length];
                System.arraycopy(this.buf, this.pos, dataBit, 0, this.length);
                return dataBit;
            }
            case TINYINT: {
                if (this.options.tinyInt1isBit && columnInfo.getLength() == 1L) {
                    return this.buf[this.pos] != 48;
                }
                return this.getInternalInt(columnInfo);
            }
            case INTEGER: {
                if (!columnInfo.isSigned()) {
                    return this.getInternalLong(columnInfo);
                }
                return this.getInternalInt(columnInfo);
            }
            case BIGINT: {
                if (!columnInfo.isSigned()) {
                    return this.getInternalBigInteger(columnInfo);
                }
                return this.getInternalLong(columnInfo);
            }
            case DOUBLE: {
                return this.getInternalDouble(columnInfo);
            }
            case VARSTRING: 
            case VARCHAR: 
            case STRING: 
            case VARCHAR2: 
            case ENUM: {
                if (columnInfo.isBinary()) {
                    byte[] data = new byte[this.getLengthMaxFieldSize()];
                    System.arraycopy(this.buf, this.pos, data, 0, this.getLengthMaxFieldSize());
                    return data;
                }
                return this.getInternalString(columnInfo, null, timeZone);
            }
            case TIMESTAMP: 
            case TIMESTAMP_NANO: 
            case DATETIME: {
                if (columnInfo.getColumnType() == ColumnType.DATETIME && !this.options.mapDateToTimestamp && this.getProtocol().isOracleMode()) {
                    return this.getInternalDate(columnInfo, null, timeZone);
                }
                if (!this.getProtocol().isOracleMode() && this.options.compatibleMysqlVersion == 8) {
                    this.useCalLenientFlag = true;
                    if (columnInfo.getColumnType() == ColumnType.DATETIME) {
                        timeZone = TimeZone.getDefault();
                    }
                }
                Timestamp timestamp = this.getInternalTimestamp(columnInfo, null, timeZone);
                if (!this.getProtocol().isOracleMode() && this.options.compatibleMysqlVersion == 8 && columnInfo.getColumnType() == ColumnType.DATETIME) {
                    LocalDateTime localDateTime = timestamp.toLocalDateTime();
                    if (this.yearIsZero) {
                        this.yearIsZero = false;
                        localDateTime = localDateTime.withYear(0);
                    }
                    return localDateTime;
                }
                return timestamp;
            }
            case DATE: {
                return this.getInternalDate(columnInfo, null, timeZone);
            }
            case DECIMAL: 
            case OBDECIMAL: {
                return this.getInternalBigDecimal(columnInfo);
            }
            case BLOB: 
            case LONGBLOB: 
            case MEDIUMBLOB: 
            case TINYBLOB: {
                byte[] dataBlob = new byte[this.getLengthMaxFieldSize()];
                System.arraycopy(this.buf, this.pos, dataBlob, 0, this.getLengthMaxFieldSize());
                return dataBlob;
            }
            case NULL: {
                return null;
            }
            case YEAR: {
                if (this.options.yearIsDateType) {
                    return this.getInternalDate(columnInfo, null, timeZone);
                }
                return this.getInternalShort(columnInfo);
            }
            case SMALLINT: 
            case MEDIUMINT: {
                return this.getInternalInt(columnInfo);
            }
            case FLOAT: {
                return Float.valueOf(this.getInternalFloat(columnInfo));
            }
            case TIME: {
                return this.getInternalTime(columnInfo, null, timeZone);
            }
            case OLDDECIMAL: 
            case JSON: {
                return this.getInternalString(columnInfo, null, timeZone);
            }
            case GEOMETRY: {
                byte[] data = new byte[this.length];
                System.arraycopy(this.buf, this.pos, data, 0, this.length);
                return data;
            }
            case NEWDATE: {
                break;
            }
            case SET: {
                break;
            }
            case NUMBER_FLOAT: 
            case NUMBER: {
                return this.getInternalNumber(columnInfo).bigDecimalValue();
            }
            case BINARY_FLOAT: {
                Double d;
                if (this.getProtocol().isOracleMode() && (d = this.getNanAndInfForOracle(columnInfo)) != null) {
                    return Float.valueOf(d.floatValue());
                }
                return Float.valueOf(new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())));
            }
            case BINARY_DOUBLE: {
                Double d;
                if (this.getProtocol().isOracleMode() && (d = this.getNanAndInfForOracle(columnInfo)) != null) {
                    return d;
                }
                return Double.valueOf(new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())));
            }
            case NVARCHAR2: 
            case NCHAR: {
                return this.getInternalString(columnInfo, null, timeZone);
            }
            case TIMESTAMP_TZ: {
                return this.getInternalTIMESTAMPTZ(columnInfo, null, timeZone);
            }
            case TIMESTAMP_LTZ: {
                return this.getInternalTIMESTAMPLTZ(columnInfo, null, timeZone);
            }
            case INTERVALYM: {
                return this.getInternalINTERVALYM(columnInfo);
            }
            case INTERVALDS: {
                return this.getInternalINTERVALDS(columnInfo);
            }
            case RAW: {
                byte[] returnBytes = new byte[this.length];
                System.arraycopy(this.buf, this.pos, returnBytes, 0, this.length);
                return returnBytes;
            }
        }
        throw ExceptionFactory.INSTANCE.notSupported("Type '" + columnInfo.getColumnType().getTypeName() + "' is not supported");
    }

    @Override
    public boolean getInternalBoolean(ColumnDefinition columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return false;
        }
        if (columnInfo.getColumnType() == ColumnType.BIT) {
            return this.parseBit() != 0L;
        }
        long boolVal = 0L;
        switch (columnInfo.getColumnType()) {
            case DOUBLE: 
            case FLOAT: 
            case DECIMAL: 
            case OLDDECIMAL: 
            case YEAR: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case MEDIUMINT: 
            case BIGINT: {
                boolVal = this.getInternalLong(columnInfo);
                return boolVal > 0L || boolVal == -1L;
            }
        }
        if (columnInfo.isBinary()) {
            byte[] bytes = new byte[this.length];
            System.arraycopy(this.buf, this.pos, bytes, 0, this.length);
            return Utils.convertBytesToBoolean(bytes);
        }
        String rawVal = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
        return Utils.convertStringToBoolean(rawVal);
    }

    @Override
    public byte getInternalByte(ColumnDefinition columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return 0;
        }
        switch (columnInfo.getColumnType()) {
            case FLOAT: {
                float internalFloat = this.getInternalFloat(columnInfo);
                this.rangeCheck(Byte.class, -128.0, 127.0, internalFloat, columnInfo);
                return (byte)internalFloat;
            }
            case DOUBLE: {
                double internalDouble = this.getInternalDouble(columnInfo);
                this.rangeCheck(Byte.class, -128.0, 127.0, internalDouble, columnInfo);
                return (byte)internalDouble;
            }
            case DECIMAL: 
            case OLDDECIMAL: 
            case OBDECIMAL: {
                BigDecimal bigDecimal = this.getInternalBigDecimal(columnInfo);
                this.rangeCheck(Byte.class, -128.0, 127.0, bigDecimal.doubleValue(), columnInfo);
                return bigDecimal.byteValue();
            }
            case NUMBER_FLOAT: {
                BigDecimal bigDecimal = this.getInternalBigDecimal(columnInfo);
                this.rangeCheck(Byte.class, -128L, 127L, bigDecimal, columnInfo);
                return bigDecimal.byteValue();
            }
            case BINARY_FLOAT: 
            case BINARY_DOUBLE: {
                double internalDouble = this.getInternalDouble(columnInfo);
                return (byte)internalDouble;
            }
        }
        long value = this.getInternalLong(columnInfo);
        this.rangeCheck(Byte.class, -128.0, 127.0, value, columnInfo);
        return (byte)value;
    }

    @Override
    public short getInternalShort(ColumnDefinition columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return 0;
        }
        switch (columnInfo.getColumnType()) {
            case FLOAT: {
                float internalFloat = this.getInternalFloat(columnInfo);
                this.rangeCheck(Short.class, -32768.0, 32767.0, internalFloat, columnInfo);
                return (short)internalFloat;
            }
            case DOUBLE: {
                double internalDouble = this.getInternalDouble(columnInfo);
                this.rangeCheck(Short.class, -32768.0, 32767.0, internalDouble, columnInfo);
                return (short)internalDouble;
            }
            case DECIMAL: 
            case OLDDECIMAL: 
            case OBDECIMAL: {
                BigDecimal bigDecimal = this.getInternalBigDecimal(columnInfo);
                this.rangeCheck(Short.class, -32768.0, 32767.0, bigDecimal.doubleValue(), columnInfo);
                return bigDecimal.shortValue();
            }
            case NUMBER_FLOAT: {
                BigDecimal bigDecimal = this.getInternalBigDecimal(columnInfo);
                this.rangeCheck(Short.class, -32768L, 32767L, bigDecimal, columnInfo);
                return bigDecimal.shortValue();
            }
            case BINARY_FLOAT: 
            case BINARY_DOUBLE: {
                double internalDouble = this.getInternalDouble(columnInfo);
                return (short)internalDouble;
            }
        }
        long value = this.getInternalLong(columnInfo);
        this.rangeCheck(Short.class, -32768.0, 32767.0, value, columnInfo);
        return (short)value;
    }

    @Override
    public String getInternalTimeString(ColumnDefinition columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        String rawValue = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
        if ("0000-00-00".equals(rawValue)) {
            return null;
        }
        String newRawvalue = rawValue;
        if (rawValue.contains(".")) {
            String[] split = rawValue.split("\\.");
            newRawvalue = split[0];
        }
        if (!this.getProtocol().isOracleMode() && this.options.compatibleMysqlVersion == 5 && newRawvalue.length() != 5 && newRawvalue.length() != 8) {
            throw new SQLException("Time format \"" + rawValue + "\" incorrect, must be HH:mm:ss");
        }
        if (this.options.maximizeMysqlCompatibility && this.options.useLegacyDatetimeCode && rawValue.indexOf(".") > 0) {
            return rawValue.substring(0, rawValue.indexOf("."));
        }
        if (rawValue.contains(".")) {
            String[] internalTimeValue = rawValue.split("\\.");
            if (this.options.compatibleMysqlVersion == 5 || internalTimeValue[1].matches("0+")) {
                return internalTimeValue[0];
            }
        }
        return rawValue;
    }

    @Override
    public BigInteger getInternalBigInteger(ColumnDefinition columnInfo) {
        if (this.lastValueWasNull()) {
            return null;
        }
        return new BigInteger(new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())).trim());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ZonedDateTime getInternalZonedDateTime(ColumnDefinition columnInfo, Class clazz, TimeZone timeZone) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.length == 0) {
            this.lastValueNull |= 1;
            return null;
        }
        if (!this.getProtocol().isOracleMode()) {
            Timestamp timestamp = null;
            Calendar calendar = null;
            if (!this.options.useLegacyDatetimeCode && this.options.compatibleMysqlVersion == 5) {
                calendar = this.getCalendarInstanceWithTimezone(null, timeZone);
            }
            switch (columnInfo.getColumnType()) {
                case TIMESTAMP: 
                case DATETIME: 
                case VARSTRING: 
                case VARCHAR: 
                case STRING: {
                    timestamp = this.getInternalTimestamp(columnInfo, calendar, timeZone);
                    return ZonedDateTime.ofInstant(timestamp.toInstant(), timeZone.toZoneId());
                }
                case TIME: 
                case DATE: {
                    if (this.options.compatibleMysqlVersion == 8) {
                        timeZone = TimeZone.getDefault();
                    }
                    timestamp = this.getInternalTimestamp(columnInfo, calendar, timeZone);
                    return ZonedDateTime.ofInstant(timestamp.toInstant(), timeZone.toZoneId());
                }
            }
        }
        if (this.getProtocol().isOracleMode() && (columnInfo.getColumnType() == ColumnType.TIMESTAMP_NANO || columnInfo.getColumnType() == ColumnType.TIMESTAMP_TZ || columnInfo.getColumnType() == ColumnType.TIMESTAMP_LTZ)) {
            Timestamp oracleTimestamp = this.getInternalTimestamp(columnInfo, null, timeZone);
            if (oracleTimestamp == null) {
                return null;
            }
            LocalDateTime localDateTimeNoTimeZone = oracleTimestamp.toLocalDateTime();
            return localDateTimeNoTimeZone.atZone(timeZone.toZoneId());
        }
        String raw = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
        switch (columnInfo.getColumnType().getSqlType()) {
            case 91: 
            case 93: {
                LocalDateTime localDateTime;
                Calendar cal = Calendar.getInstance(timeZone);
                Timestamp timestamp = this.getInternalTimestamp(columnInfo, cal, TimeZone.getDefault());
                if (timestamp == null) {
                    return null;
                }
                try {
                    localDateTime = LocalDateTime.parse(timestamp.toString(), TEXT_LOCAL_DATE_TIME.withZone(timeZone.toZoneId()));
                    return ZonedDateTime.of(localDateTime, timeZone.toZoneId());
                }
                catch (DateTimeParseException dateParserEx) {
                    throw new SQLException(timestamp.toString() + " cannot be parse as LocalDateTime. time must have \"yyyy-MM-dd HH:mm:ss[.S]\" format");
                }
            }
            case -1: 
            case 1: 
            case 12: {
                LocalDateTime localDateTime;
                if (raw.startsWith("0000-00-00 00:00:00")) {
                    return null;
                }
                try {
                    if (this.getProtocol().isOracleMode()) {
                        localDateTime = LocalDateTime.parse(raw, TEXT_LOCAL_DATE_TIME.withZone(timeZone.toZoneId()));
                        return ZonedDateTime.of(localDateTime, timeZone.toZoneId());
                    }
                    Calendar cal = Calendar.getInstance(timeZone);
                    Timestamp timestamp = this.getInternalTimestamp(columnInfo, cal, TimeZone.getDefault());
                    if (timestamp == null) {
                        return null;
                    }
                    try {
                        localDateTime = LocalDateTime.parse(timestamp.toString(), TEXT_LOCAL_DATE_TIME.withZone(timeZone.toZoneId()));
                        return ZonedDateTime.of(localDateTime, timeZone.toZoneId());
                    }
                    catch (DateTimeParseException dateParserEx) {
                        throw new SQLException(timestamp.toString() + " cannot be parse as LocalDateTime. time must have \"yyyy-MM-dd HH:mm:ss[.S]\" format");
                    }
                }
                catch (DateTimeParseException dateParserEx) {
                    throw new SQLException(raw + " cannot be parse as ZonedDateTime. time must have \"yyyy-MM-dd[T/ ]HH:mm:ss[.S]\" with offset and timezone format (example : '2011-12-03 10:15:30+01:00[Europe/Paris]')");
                }
            }
            default: {
                throw new SQLException("Cannot read " + clazz.getName() + " using a " + columnInfo.getColumnType().getSqlTypeName() + " field");
            }
        }
    }

    @Override
    public OffsetTime getInternalOffsetTime(ColumnDefinition columnInfo, TimeZone timeZone) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.length == 0) {
            this.lastValueNull |= 1;
            return null;
        }
        ZoneId zoneId = timeZone.toZoneId().normalized();
        if (zoneId instanceof ZoneOffset) {
            ZoneOffset zoneOffset = (ZoneOffset)zoneId;
            String raw = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
            switch (columnInfo.getColumnType().getSqlType()) {
                case 93: {
                    if (raw.startsWith("0000-00-00 00:00:00")) {
                        return null;
                    }
                    try {
                        return ZonedDateTime.parse(raw, TEXT_LOCAL_DATE_TIME.withZone(zoneOffset)).toOffsetDateTime().toOffsetTime();
                    }
                    catch (DateTimeParseException dateParserEx) {
                        throw new SQLException(raw + " cannot be parse as OffsetTime. time must have \"yyyy-MM-dd HH:mm:ss[.S]\" format");
                    }
                }
                case 92: {
                    try {
                        LocalTime localTime = LocalTime.parse(raw, DateTimeFormatter.ISO_LOCAL_TIME.withZone(zoneOffset));
                        return OffsetTime.of(localTime, zoneOffset);
                    }
                    catch (DateTimeParseException dateParserEx) {
                        throw new SQLException(raw + " cannot be parse as OffsetTime (format is \"HH:mm:ss[.S]\" for data type \"" + (Object)((Object)columnInfo.getColumnType()) + "\")");
                    }
                }
                case -1: 
                case 1: 
                case 12: {
                    try {
                        return OffsetTime.parse(raw, DateTimeFormatter.ISO_OFFSET_TIME);
                    }
                    catch (DateTimeParseException dateParserEx) {
                        throw new SQLException(raw + " cannot be parse as OffsetTime (format is \"HH:mm:ss[.S]\" with offset for data type \"" + (Object)((Object)columnInfo.getColumnType()) + "\")");
                    }
                }
            }
            throw new SQLException("Cannot read " + OffsetTime.class.getName() + " using a " + columnInfo.getColumnType().getSqlTypeName() + " field");
        }
        if (!this.getProtocol().isOracleMode()) {
            String raw = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
            return OffsetTime.parse(raw, DateTimeFormatter.ISO_OFFSET_TIME);
        }
        if (this.options.useLegacyDatetimeCode) {
            throw new SQLException("Cannot return an OffsetTime for a TIME field when default timezone is '" + zoneId + "' (only possible for time-zone offset from Greenwich/UTC, such as +02:00)");
        }
        throw new SQLException("Cannot return an OffsetTime for a TIME field when server timezone '" + zoneId + "' (only possible for time-zone offset from Greenwich/UTC, such as +02:00)");
    }

    @Override
    public OffsetDateTime getInternalOffsetDateTime(ColumnDefinition columnInfo, TimeZone timeZone) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.length == 0) {
            this.lastValueNull |= 1;
            return null;
        }
        if (!this.getProtocol().isOracleMode() && this.options.compatibleMysqlVersion == 8) {
            Timestamp timestamp = null;
            switch (columnInfo.getColumnType()) {
                case TIMESTAMP: 
                case DATETIME: 
                case VARSTRING: 
                case VARCHAR: 
                case STRING: {
                    timestamp = this.getInternalTimestamp(columnInfo, null, timeZone);
                    return ZonedDateTime.ofInstant(timestamp.toInstant(), timeZone.toZoneId()).toOffsetDateTime();
                }
                case TIME: 
                case DATE: {
                    timestamp = this.getInternalTimestamp(columnInfo, null, TimeZone.getDefault());
                    return ZonedDateTime.ofInstant(timestamp.toInstant(), TimeZone.getDefault().toZoneId()).toOffsetDateTime();
                }
            }
        }
        String raw = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
        switch (columnInfo.getColumnType().getSqlType()) {
            case -1: 
            case 1: 
            case 12: 
            case 92: {
                try {
                    return OffsetDateTime.parse(raw.replace(" ", "T"));
                }
                catch (DateTimeParseException dateParserEx) {
                    throw new SQLException(raw + " cannot be parse as LocalTime (format is \"HH:mm:ss[.S]\" for data type \"" + (Object)((Object)columnInfo.getColumnType()) + "\")");
                }
            }
            case 93: {
                ZonedDateTime zonedDateTime = this.getInternalZonedDateTime(columnInfo, LocalTime.class, timeZone);
                return zonedDateTime == null ? null : zonedDateTime.withZoneSameInstant(ZoneId.systemDefault()).toOffsetDateTime();
            }
        }
        throw new SQLException("Cannot read LocalTime using a " + columnInfo.getColumnType().getSqlTypeName() + " field");
    }

    @Override
    public LocalTime getInternalLocalTime(ColumnDefinition columnInfo, TimeZone timeZone) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.length == 0) {
            this.lastValueNull |= 1;
            return null;
        }
        String raw = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
        switch (columnInfo.getColumnType().getSqlType()) {
            case -1: 
            case 1: 
            case 12: 
            case 92: {
                try {
                    return LocalTime.parse(raw, DateTimeFormatter.ISO_LOCAL_TIME.withZone(timeZone.toZoneId()));
                }
                catch (DateTimeParseException dateParserEx) {
                    throw new SQLException(raw + " cannot be parse as LocalTime (format is \"HH:mm:ss[.S]\" for data type \"" + (Object)((Object)columnInfo.getColumnType()) + "\")");
                }
            }
            case 93: {
                ZonedDateTime zonedDateTime = this.getInternalZonedDateTime(columnInfo, LocalTime.class, timeZone);
                return zonedDateTime == null ? null : zonedDateTime.withZoneSameInstant(ZoneId.systemDefault()).toLocalTime();
            }
        }
        throw new SQLException("Cannot read LocalTime using a " + columnInfo.getColumnType().getSqlTypeName() + " field");
    }

    @Override
    public LocalDate getInternalLocalDate(ColumnDefinition columnInfo, TimeZone timeZone) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.length == 0) {
            this.lastValueNull |= 1;
            return null;
        }
        String raw = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
        switch (columnInfo.getColumnType().getSqlType()) {
            case -1: 
            case 1: 
            case 12: 
            case 91: {
                if (raw.startsWith("0000-00-00")) {
                    return null;
                }
                try {
                    return LocalDate.parse(raw, DateTimeFormatter.ISO_LOCAL_DATE.withZone(timeZone.toZoneId()));
                }
                catch (DateTimeParseException dateParserEx) {
                    throw new SQLException(raw + " cannot be parse as LocalDate (format is \"yyyy-MM-dd\" for data type \"" + (Object)((Object)columnInfo.getColumnType()) + "\")");
                }
            }
            case 93: {
                ZonedDateTime zonedDateTime = this.getInternalZonedDateTime(columnInfo, LocalDate.class, timeZone);
                return zonedDateTime == null ? null : zonedDateTime.withZoneSameInstant(ZoneId.systemDefault()).toLocalDate();
            }
        }
        throw new SQLException("Cannot read LocalDate using a " + columnInfo.getColumnType().getSqlTypeName() + " field");
    }

    @Override
    public boolean isBinaryEncoded() {
        return false;
    }

    public NUMBER getInternalNumber(ColumnDefinition columnInfo) {
        if (this.lastValueWasNull()) {
            return new NUMBER("0".getBytes());
        }
        byte[] b = new byte[this.length];
        System.arraycopy(this.buf, this.pos, b, 0, this.length);
        return new NUMBER(b);
    }

    public NUMBER_FLOAT getInternalNumber_float(ColumnDefinition columnInfo) {
        if (this.lastValueWasNull()) {
            return new NUMBER_FLOAT(0.0f);
        }
        return new NUMBER_FLOAT(new Float(new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()))).floatValue());
    }

    public BINARY_DOUBLE getInternalBINARY_DOUBLE() {
        if (this.lastValueWasNull()) {
            return new BINARY_DOUBLE(0.0);
        }
        byte[] b = new byte[this.length];
        System.arraycopy(this.buf, this.pos, b, 0, this.length);
        return new BINARY_DOUBLE(b);
    }

    public BINARY_FLOAT getInternalBINARY_FLOAT() {
        if (this.lastValueWasNull()) {
            return new BINARY_FLOAT(0.0f);
        }
        byte[] b = new byte[this.length];
        System.arraycopy(this.buf, this.pos, b, 0, this.length);
        return new BINARY_FLOAT(this.buf);
    }

    @Override
    public INTERVALDS getInternalINTERVALDS(ColumnDefinition columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return new INTERVALDS("0 0:0:0.0");
        }
        byte[] b = new byte[this.length];
        System.arraycopy(this.buf, this.pos, b, 0, this.length);
        return new INTERVALDS(b);
    }

    @Override
    public INTERVALYM getInternalINTERVALYM(ColumnDefinition columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return new INTERVALYM("0-0");
        }
        byte[] b = new byte[this.length];
        System.arraycopy(this.buf, this.pos, b, 0, this.length);
        return new INTERVALYM(b);
    }

    private Double getNanAndInfForOracle(ColumnDefinition columnInfo) {
        String doubleStr = new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType()));
        if (doubleStr.toUpperCase(Locale.ROOT).startsWith("NAN")) {
            return Double.NaN;
        }
        if (doubleStr.toUpperCase(Locale.ROOT).startsWith("INF")) {
            return Double.POSITIVE_INFINITY;
        }
        if (doubleStr.toUpperCase(Locale.ROOT).startsWith("-INF")) {
            return Double.NEGATIVE_INFINITY;
        }
        return null;
    }

    private boolean isZeroDateOrTime(ColumnDefinition columnInfo) throws SQLException {
        int[] datePart = new int[]{0, 0, 0};
        if (columnInfo.getColumnType() == ColumnType.TIMESTAMP || columnInfo.getColumnType() == ColumnType.TIMESTAMP_NANO || columnInfo.getColumnType() == ColumnType.DATETIME || columnInfo.getColumnType() == ColumnType.TIMESTAMP_TZ || columnInfo.getColumnType() == ColumnType.TIMESTAMP_LTZ) {
            datePart = new int[]{0, 0, 0, 0, 0, 0};
        }
        int partIdx = 0;
        for (int begin = this.pos; begin < this.pos + this.length; ++begin) {
            byte b = this.buf[begin];
            if (b == 45 || b == 58 || b == 32) {
                ++partIdx;
                continue;
            }
            if ((b < 48 || b > 57) && columnInfo.getColumnType() == ColumnType.DATE) {
                throw new SQLException("cannot parse data in date string '" + new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())) + "'");
            }
            datePart[partIdx] = datePart[partIdx] * 10 + b - 48;
        }
        for (int j : datePart) {
            if (j == 0) continue;
            return false;
        }
        return true;
    }

    private void handleZeroDateException(ColumnDefinition columnInfo, Class clazz) throws SQLException {
        boolean zeroDateOrTime = this.isZeroDateOrTime(columnInfo);
        if (zeroDateOrTime && this.options.zeroDateTimeBehavior.equalsIgnoreCase("exception")) {
            if (!this.getProtocol().isOracleMode() && this.options.compatibleMysqlVersion == 8) {
                throw new SQLException("Zero date value prohibited");
            }
            throw new SQLException("Value '" + new String(this.buf, this.pos, this.length, this.getCurrentEncoding(columnInfo.getColumnType())) + "' can not be represented as " + clazz.getName());
        }
    }
}

