/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.send.authentication;

import com.oceanbase.jdbc.authentication.AuthenticationPlugin;
import com.oceanbase.jdbc.internal.com.read.Buffer;
import com.oceanbase.jdbc.internal.io.input.PacketInputStream;
import com.oceanbase.jdbc.internal.io.output.PacketOutputStream;
import com.oceanbase.jdbc.util.Options;
import java.io.IOException;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;

public class ClearPasswordPlugin
implements AuthenticationPlugin {
    public static final String TYPE = "mysql_clear_password";
    private String authenticationData;
    private String passwordCharacterEncoding;

    @Override
    public String name() {
        return "mysql clear password";
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public boolean mustUseSsl() {
        return true;
    }

    @Override
    public void initialize(String authenticationData, byte[] authData, Options options) {
        this.authenticationData = authenticationData;
        this.passwordCharacterEncoding = options.passwordCharacterEncoding;
    }

    @Override
    public Buffer process(PacketOutputStream out, PacketInputStream in, AtomicInteger sequence) throws IOException, SQLException {
        if (this.authenticationData == null || this.authenticationData.isEmpty()) {
            out.writeEmptyPacket(sequence.incrementAndGet());
        } else {
            out.startPacket(sequence.incrementAndGet());
            byte[] bytePwd = this.passwordCharacterEncoding != null && !this.passwordCharacterEncoding.isEmpty() ? this.authenticationData.getBytes(this.passwordCharacterEncoding) : this.authenticationData.getBytes();
            out.write(bytePwd);
            out.write(0);
            out.flush();
        }
        Buffer buffer = in.getPacket(true);
        sequence.set(in.getLastPacketSeq());
        return buffer;
    }
}

