/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.send.authentication.gssapi;

import com.oceanbase.jdbc.internal.com.read.Buffer;
import com.oceanbase.jdbc.internal.com.send.authentication.gssapi.GssapiAuth;
import com.oceanbase.jdbc.internal.io.input.PacketInputStream;
import com.oceanbase.jdbc.internal.io.output.PacketOutputStream;
import com.sun.jna.platform.win32.Sspi;
import com.sun.jna.platform.win32.SspiUtil;
import java.io.IOException;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;
import waffle.windows.auth.IWindowsSecurityContext;
import waffle.windows.auth.impl.WindowsSecurityContextImpl;

public class WindowsNativeSspiAuthentication
implements GssapiAuth {
    @Override
    public void authenticate(PacketOutputStream out, PacketInputStream in, AtomicInteger sequence, String servicePrincipalName, String mechanisms) throws IOException, SQLException {
        IWindowsSecurityContext clientContext = WindowsSecurityContextImpl.getCurrent((String)mechanisms, (String)servicePrincipalName);
        do {
            byte[] tokenForTheServerOnTheClient = clientContext.getToken();
            out.startPacket(sequence.incrementAndGet());
            out.write(tokenForTheServerOnTheClient);
            out.flush();
            if (!clientContext.isContinue()) continue;
            Buffer buffer = in.getPacket(true);
            sequence.set(in.getLastPacketSeq());
            byte[] tokenForTheClientOnTheServer = buffer.readBytes(buffer.remaining());
            SspiUtil.ManagedSecBufferDesc continueToken = new SspiUtil.ManagedSecBufferDesc(2, tokenForTheClientOnTheServer);
            clientContext.initialize(clientContext.getHandle(), (Sspi.SecBufferDesc)continueToken, servicePrincipalName);
        } while (clientContext.isContinue());
        clientContext.dispose();
    }
}

