/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.send.parameters;

import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.com.send.parameters.ParameterHolder;
import com.oceanbase.jdbc.internal.io.output.PacketOutputStream;
import java.io.IOException;

public class OBEmptyLobParameter
implements Cloneable,
ParameterHolder {
    int lobType = 0;
    private byte[] lobLocatorBinary = null;
    private static final byte[] EMPTY_CLOB = new byte[]{69, 77, 80, 84, 89, 95, 67, 76, 79, 66, 40, 41};
    private static final byte[] EMPTY_BLOB = new byte[]{69, 77, 80, 84, 89, 95, 66, 76, 79, 66, 40, 41};

    public OBEmptyLobParameter(int lobType) {
        this.lobType = lobType;
    }

    public OBEmptyLobParameter(int lobType, byte[] lobLocatorBinary) {
        this.lobType = lobType;
        this.lobLocatorBinary = lobLocatorBinary;
    }

    @Override
    public void writeTo(PacketOutputStream os) throws IOException {
        if (this.lobType == 0) {
            os.write(EMPTY_BLOB);
        } else {
            os.write(EMPTY_CLOB);
        }
    }

    @Override
    public void writeBinary(PacketOutputStream pos) throws IOException {
        if (this.lobLocatorBinary != null) {
            pos.writeFieldLength(this.lobLocatorBinary.length);
            pos.write(this.lobLocatorBinary, 0, this.lobLocatorBinary.length);
        }
    }

    @Override
    public int getApproximateTextProtocolLength() throws IOException {
        return 0;
    }

    @Override
    public boolean isNullData() {
        return this.lobLocatorBinary == null;
    }

    @Override
    public ColumnType getColumnType() {
        return this.lobLocatorBinary != null ? (this.lobType == 0 ? ColumnType.ORA_BLOB : ColumnType.ORA_CLOB) : ColumnType.STRING;
    }

    @Override
    public boolean isLongData() {
        return false;
    }
}

