/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.io.input;

import com.oceanbase.jdbc.internal.com.read.Buffer;
import com.oceanbase.jdbc.internal.io.LruTraceCache;
import com.oceanbase.jdbc.internal.io.input.DecompressPacketInputStream;
import com.oceanbase.jdbc.internal.io.input.Ob20PacketInputStream;
import com.oceanbase.jdbc.internal.io.input.PacketInputStream;
import com.oceanbase.jdbc.internal.io.input.StandardPacketInputStream;
import com.oceanbase.jdbc.internal.protocol.TimeTrace;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public abstract class AbstractPacketInputStream
implements PacketInputStream {
    protected InputStream inputStream;
    protected long threadId;
    protected int mysqlSeqNo;
    protected LruTraceCache traceCache = null;
    protected String serverThreadLog = "";
    protected int maxQuerySizeToLog;
    protected boolean enableNetworkStatistics = false;
    protected long timestampAfterRead = 0L;
    protected static final int REUSABLE_BUFFER_LENGTH = 1024;
    protected static final int MAX_PACKET_SIZE = 0xFFFFFF;
    protected final byte[] reusableArray = new byte[1024];
    protected TimeTrace timeTrace;
    protected int preMysqlSeqNo = -1;
    protected boolean mysqlSeqNoReset = false;

    @Override
    public abstract Buffer getPacket(boolean var1) throws IOException, SQLException;

    @Override
    public abstract byte[] getPacketArray(boolean var1) throws IOException, SQLException;

    protected abstract void readMysqlStream(byte[] var1, int var2, int var3) throws IOException;

    protected abstract void doTrace(int var1, int var2, byte[] var3);

    @Override
    public int getLastPacketSeq() {
        return this.mysqlSeqNo;
    }

    @Override
    public abstract int getCompressLastPacketSeq();

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public void setServerThreadId(long serverThreadId, Boolean isMaster) {
        this.serverThreadLog = "connectionId=" + serverThreadId + (isMaster != null ? "(" + (isMaster != false ? "M" : "S") + ")" : "");
    }

    @Override
    public void setTraceCache(LruTraceCache traceCache) {
        this.traceCache = traceCache;
    }

    @Override
    public void enableNetworkStatistics(boolean flag) {
        this.timestampAfterRead = 0L;
        this.enableNetworkStatistics = flag;
    }

    @Override
    public long getTimestampAfterRead() {
        return this.timestampAfterRead;
    }

    @Override
    public void clearNetworkStatistics() {
        this.timestampAfterRead = 0L;
    }

    @Override
    public void startReceiveResponse() {
        if (this.timeTrace != null) {
            this.timeTrace.startReceiveResponse();
        }
    }

    @Override
    public void endReceiveResponse(String sql) {
        if (this.timeTrace != null) {
            String protocol = null;
            if (this instanceof Ob20PacketInputStream) {
                protocol = "ob20";
            } else if (this instanceof StandardPacketInputStream) {
                protocol = "mysql";
            } else if (this instanceof DecompressPacketInputStream) {
                protocol = "compress";
            }
            this.timeTrace.endReceiveResponse(protocol, sql);
        }
    }

    @Override
    public void resetReadMysqlSeqNo() {
        this.preMysqlSeqNo = 0;
        this.mysqlSeqNoReset = true;
    }

    @Override
    public void setMysqlSeqNoReset(boolean mysqlSeqNoReset) {
        this.mysqlSeqNoReset = mysqlSeqNoReset;
    }

    public void checkMysqlSeqNo(int curMysqlSeqNo) throws SQLException {
        if (!this.mysqlSeqNoReset) {
            if (curMysqlSeqNo == -128 && this.preMysqlSeqNo != 127) {
                throw new SQLException("Packets out of order, expected packet # -128, but received packet # " + curMysqlSeqNo);
            }
            if (this.preMysqlSeqNo == -1 && curMysqlSeqNo != 0) {
                throw new SQLException("Packets out of order, expected packet # -1, but received packet # " + curMysqlSeqNo);
            }
            if (curMysqlSeqNo != -128 && this.preMysqlSeqNo != -1 && curMysqlSeqNo != this.preMysqlSeqNo + 1) {
                throw new SQLException("Packets out of order, expected packet # " + (this.preMysqlSeqNo + 1) + ", but received packet # " + curMysqlSeqNo);
            }
        } else {
            this.mysqlSeqNoReset = false;
        }
        this.preMysqlSeqNo = curMysqlSeqNo;
    }
}

