/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.io.output;

import com.oceanbase.jdbc.internal.io.TraceObject;
import com.oceanbase.jdbc.internal.io.output.AbstractPacketOutputStream;
import com.oceanbase.jdbc.internal.logging.Logger;
import com.oceanbase.jdbc.internal.logging.LoggerFactory;
import com.oceanbase.jdbc.internal.protocol.TimeTrace;
import com.oceanbase.jdbc.internal.util.Utils;
import com.oceanbase.jdbc.internal.util.exceptions.MaxAllowedPacketException;
import com.oceanbase.jdbc.util.Options;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;

public class StandardPacketOutputStream
extends AbstractPacketOutputStream {
    private static final Logger logger = LoggerFactory.getLogger(StandardPacketOutputStream.class);
    private static final int MAX_PACKET_LENGTH = 0x1000003;

    public StandardPacketOutputStream(OutputStream out, long threadId, Options options, TimeTrace timeTrace) {
        super(out, options.maxQuerySizeToLog, threadId, options.getCharacterEncoding(), timeTrace, options.encloseParamInParentheses);
        this.maxPacketLength = 0x1000003;
    }

    @Override
    public void startPacket(int seqNo) {
        this.mysqlSeqNo = seqNo;
        this.pos = 4;
        this.cmdLength = 0L;
        this.startSendRequest();
    }

    @Override
    public void setMaxAllowedPacket(int maxAllowedPacket) {
        this.maxAllowedPacket = maxAllowedPacket;
        this.maxPacketLength = Math.min(0x1000003, maxAllowedPacket + 4);
    }

    @Override
    public int initialPacketPos() {
        return 4;
    }

    @Override
    protected void flushBuffer(boolean commandEnd) throws IOException {
        if (this.enableNetworkStatistics) {
            this.timestampBeforeFlush = System.currentTimeMillis();
        }
        if (this.pos > 4) {
            this.buf[0] = (byte)(this.pos - 4);
            this.buf[1] = (byte)(this.pos - 4 >>> 8);
            this.buf[2] = (byte)(this.pos - 4 >>> 16);
            this.buf[3] = (byte)this.mysqlSeqNo++;
            this.cmdLength += (long)(this.pos - 4);
            if (this.cmdLength >= (long)this.maxAllowedPacket) {
                if (this.sendPacketBufList != null && !this.sendPacketBufList.isEmpty()) {
                    this.sendPacketBufList.clear();
                }
                throw new MaxAllowedPacketException("query size (" + this.cmdLength + ") is >= to max_allowed_packet (" + this.maxAllowedPacket + ")", false);
            }
            logger.debug("prepare to send: {}, packetLength = {}, packetNumber = {}", this.serverThreadLog, (this.buf[0] & 0xFF) + ((this.buf[1] & 0xFF) << 8) + ((this.buf[2] & 0xFF) << 16), this.buf[3] & 0xFF);
            if (!commandEnd) {
                byte[] bytes = Arrays.copyOf(this.buf, this.pos);
                if (this.sendPacketBufList == null) {
                    this.sendPacketBufList = new ArrayList();
                }
                this.sendPacketBufList.add(bytes);
            } else {
                if (this.sendPacketBufList != null && !this.sendPacketBufList.isEmpty()) {
                    for (byte[] bytes : this.sendPacketBufList) {
                        this.out.write(bytes);
                    }
                    this.sendPacketBufList.clear();
                }
                this.out.write(this.buf, 0, this.pos);
            }
            this.doTrace(this.pos);
            if (commandEnd && this.pos == 0x1000003) {
                this.writeEmptyPacket();
            }
            this.pos = 4;
        }
    }

    @Override
    public void writeEmptyPacket() throws IOException {
        if (this.enableNetworkStatistics) {
            this.timestampBeforeFlush = System.currentTimeMillis();
        }
        this.buf[0] = 0;
        this.buf[1] = 0;
        this.buf[2] = 0;
        this.buf[3] = (byte)this.mysqlSeqNo++;
        logger.debug("prepare to send: {}, packetLength = {}, packetNumber = {}", this.serverThreadLog, (this.buf[0] & 0xFF) + ((this.buf[1] & 0xFF) << 8) + ((this.buf[2] & 0xFF) << 16), this.buf[3] & 0xFF);
        this.out.write(this.buf, 0, 4);
        this.doTrace(4);
    }

    private void doTrace(int length) {
        if (this.traceCache != null && this.permitTrace) {
            this.traceCache.put(new TraceObject(true, 0, this.threadId, new byte[][]{Arrays.copyOfRange(this.buf, 0, Math.min(length, 1000))}));
        }
        if (logger.isTraceEnabled()) {
            logger.trace("send: {}{}", (Object)this.serverThreadLog, (Object)Utils.hexdump(this.maxQuerySizeToLog, 0, length, (byte[][])new byte[][]{this.buf}));
        }
    }
}

