/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.StripeException;
import com.stripe.model.ExternalAccount;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.param.ExternalAccountCollectionCreateParams;
import com.stripe.param.ExternalAccountCollectionListParams;
import com.stripe.param.ExternalAccountCollectionRetrieveParams;
import java.lang.reflect.Type;
import java.util.Map;

public class ExternalAccountCollection
extends StripeCollection<ExternalAccount> {
    public ExternalAccount create(Map<String, Object> params) throws StripeException {
        return this.create(params, (RequestOptions)null);
    }

    public ExternalAccount create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = this.getUrl();
        return (ExternalAccount)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, (Type)((Object)ExternalAccount.class), options, ApiMode.V1);
    }

    public ExternalAccount create(ExternalAccountCollectionCreateParams params) throws StripeException {
        return this.create(params, (RequestOptions)null);
    }

    public ExternalAccount create(ExternalAccountCollectionCreateParams params, RequestOptions options) throws StripeException {
        String path = this.getUrl();
        ApiResource.checkNullTypedParams(path, params);
        return (ExternalAccount)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)ExternalAccount.class), options, ApiMode.V1);
    }

    public ExternalAccountCollection list(Map<String, Object> params) throws StripeException {
        return this.list(params, (RequestOptions)null);
    }

    public ExternalAccountCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = this.getUrl();
        return (ExternalAccountCollection)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)ExternalAccountCollection.class), options, ApiMode.V1);
    }

    public ExternalAccountCollection list(ExternalAccountCollectionListParams params) throws StripeException {
        return this.list(params, (RequestOptions)null);
    }

    public ExternalAccountCollection list(ExternalAccountCollectionListParams params, RequestOptions options) throws StripeException {
        String path = this.getUrl();
        ApiResource.checkNullTypedParams(path, params);
        return (ExternalAccountCollection)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)ExternalAccountCollection.class), options, ApiMode.V1);
    }

    public ExternalAccount retrieve(String id) throws StripeException {
        return this.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public ExternalAccount retrieve(String id, RequestOptions options) throws StripeException {
        return this.retrieve(id, (Map<String, Object>)null, options);
    }

    public ExternalAccount retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("%s/%s", this.getUrl(), ApiResource.urlEncodeId(id));
        return (ExternalAccount)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)ExternalAccount.class), options, ApiMode.V1);
    }

    public ExternalAccount retrieve(String id, ExternalAccountCollectionRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("%s/%s", this.getUrl(), ApiResource.urlEncodeId(id));
        ApiResource.checkNullTypedParams(path, params);
        return (ExternalAccount)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)ExternalAccount.class), options, ApiMode.V1);
    }
}

