/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.Coupon;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.CouponCreateParams;
import com.stripe.param.CouponListParams;
import com.stripe.param.CouponRetrieveParams;
import com.stripe.param.CouponUpdateParams;
import java.lang.reflect.Type;

public final class CouponService
extends ApiService {
    public CouponService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<Coupon> list(CouponListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Coupon> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Coupon> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Coupon> list(CouponListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/coupons";
        return (StripeCollection)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), new TypeToken<StripeCollection<Coupon>>(){}.getType(), options, ApiMode.V1);
    }

    public Coupon create(CouponCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Coupon create(RequestOptions options) throws StripeException {
        return this.create(null, options);
    }

    public Coupon create() throws StripeException {
        return this.create(null, null);
    }

    public Coupon create(CouponCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/coupons";
        return (Coupon)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Coupon.class), options, ApiMode.V1);
    }

    public Coupon retrieve(String coupon, CouponRetrieveParams params) throws StripeException {
        return this.retrieve(coupon, params, null);
    }

    public Coupon retrieve(String coupon, RequestOptions options) throws StripeException {
        return this.retrieve(coupon, null, options);
    }

    public Coupon retrieve(String coupon) throws StripeException {
        return this.retrieve(coupon, null, null);
    }

    public Coupon retrieve(String coupon, CouponRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/coupons/%s", ApiResource.urlEncodeId(coupon));
        return (Coupon)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Coupon.class), options, ApiMode.V1);
    }

    public Coupon update(String coupon, CouponUpdateParams params) throws StripeException {
        return this.update(coupon, params, null);
    }

    public Coupon update(String coupon, RequestOptions options) throws StripeException {
        return this.update(coupon, null, options);
    }

    public Coupon update(String coupon) throws StripeException {
        return this.update(coupon, null, null);
    }

    public Coupon update(String coupon, CouponUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/coupons/%s", ApiResource.urlEncodeId(coupon));
        return (Coupon)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Coupon.class), options, ApiMode.V1);
    }

    public Coupon delete(String coupon) throws StripeException {
        return this.delete(coupon, null);
    }

    public Coupon delete(String coupon, RequestOptions options) throws StripeException {
        String path = String.format("/v1/coupons/%s", ApiResource.urlEncodeId(coupon));
        return (Coupon)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, null, (Type)((Object)Coupon.class), options, ApiMode.V1);
    }
}

