/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.stripe.exception.StripeException;
import com.stripe.model.PaymentSource;
import com.stripe.model.Source;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.SourceCreateParams;
import com.stripe.param.SourceDetachParams;
import com.stripe.param.SourceRetrieveParams;
import com.stripe.param.SourceUpdateParams;
import com.stripe.param.SourceVerifyParams;
import com.stripe.service.SourceTransactionService;
import java.lang.reflect.Type;

public final class SourceService
extends ApiService {
    public SourceService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public PaymentSource detach(String customer, String id, SourceDetachParams params) throws StripeException {
        return this.detach(customer, id, params, null);
    }

    public PaymentSource detach(String customer, String id, RequestOptions options) throws StripeException {
        return this.detach(customer, id, null, options);
    }

    public PaymentSource detach(String customer, String id) throws StripeException {
        return this.detach(customer, id, null, null);
    }

    public PaymentSource detach(String customer, String id, SourceDetachParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/customers/%s/sources/%s", ApiResource.urlEncodeId(customer), ApiResource.urlEncodeId(id));
        return (PaymentSource)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, ApiRequestParams.paramsToMap(params), (Type)((Object)PaymentSource.class), options, ApiMode.V1);
    }

    public Source retrieve(String source, SourceRetrieveParams params) throws StripeException {
        return this.retrieve(source, params, null);
    }

    public Source retrieve(String source, RequestOptions options) throws StripeException {
        return this.retrieve(source, null, options);
    }

    public Source retrieve(String source) throws StripeException {
        return this.retrieve(source, null, null);
    }

    public Source retrieve(String source, SourceRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/sources/%s", ApiResource.urlEncodeId(source));
        return (Source)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Source.class), options, ApiMode.V1);
    }

    public Source update(String source, SourceUpdateParams params) throws StripeException {
        return this.update(source, params, null);
    }

    public Source update(String source, RequestOptions options) throws StripeException {
        return this.update(source, null, options);
    }

    public Source update(String source) throws StripeException {
        return this.update(source, null, null);
    }

    public Source update(String source, SourceUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/sources/%s", ApiResource.urlEncodeId(source));
        return (Source)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Source.class), options, ApiMode.V1);
    }

    public Source create(SourceCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Source create(RequestOptions options) throws StripeException {
        return this.create(null, options);
    }

    public Source create() throws StripeException {
        return this.create(null, null);
    }

    public Source create(SourceCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/sources";
        return (Source)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Source.class), options, ApiMode.V1);
    }

    public Source verify(String source, SourceVerifyParams params) throws StripeException {
        return this.verify(source, params, null);
    }

    public Source verify(String source, SourceVerifyParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/sources/%s/verify", ApiResource.urlEncodeId(source));
        return (Source)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Source.class), options, ApiMode.V1);
    }

    public SourceTransactionService transactions() {
        return new SourceTransactionService(this.getResponseGetter());
    }
}

