/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.issuing;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.issuing.Cardholder;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.issuing.CardholderCreateParams;
import com.stripe.param.issuing.CardholderListParams;
import com.stripe.param.issuing.CardholderRetrieveParams;
import com.stripe.param.issuing.CardholderUpdateParams;
import java.lang.reflect.Type;

public final class CardholderService
extends ApiService {
    public CardholderService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<Cardholder> list(CardholderListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Cardholder> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Cardholder> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Cardholder> list(CardholderListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/cardholders";
        return (StripeCollection)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), new TypeToken<StripeCollection<Cardholder>>(){}.getType(), options, ApiMode.V1);
    }

    public Cardholder create(CardholderCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Cardholder create(CardholderCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/cardholders";
        return (Cardholder)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Cardholder.class), options, ApiMode.V1);
    }

    public Cardholder retrieve(String cardholder, CardholderRetrieveParams params) throws StripeException {
        return this.retrieve(cardholder, params, null);
    }

    public Cardholder retrieve(String cardholder, RequestOptions options) throws StripeException {
        return this.retrieve(cardholder, null, options);
    }

    public Cardholder retrieve(String cardholder) throws StripeException {
        return this.retrieve(cardholder, null, null);
    }

    public Cardholder retrieve(String cardholder, CardholderRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/cardholders/%s", ApiResource.urlEncodeId(cardholder));
        return (Cardholder)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Cardholder.class), options, ApiMode.V1);
    }

    public Cardholder update(String cardholder, CardholderUpdateParams params) throws StripeException {
        return this.update(cardholder, params, null);
    }

    public Cardholder update(String cardholder, RequestOptions options) throws StripeException {
        return this.update(cardholder, null, options);
    }

    public Cardholder update(String cardholder) throws StripeException {
        return this.update(cardholder, null, null);
    }

    public Cardholder update(String cardholder, CardholderUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/cardholders/%s", ApiResource.urlEncodeId(cardholder));
        return (Cardholder)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Cardholder.class), options, ApiMode.V1);
    }
}

