/*
 * Decompiled with CFR 0.152.
 */
package com.stripe;

import com.stripe.StripeContext;
import com.stripe.exception.SignatureVerificationException;
import com.stripe.exception.StripeException;
import com.stripe.model.Event;
import com.stripe.model.StripeObject;
import com.stripe.model.v2.core.EventNotification;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiResource;
import com.stripe.net.Authenticator;
import com.stripe.net.BaseAddress;
import com.stripe.net.BearerTokenAuthenticator;
import com.stripe.net.LiveStripeResponseGetter;
import com.stripe.net.RawApiRequest;
import com.stripe.net.RawRequestOptions;
import com.stripe.net.StripeResponse;
import com.stripe.net.StripeResponseGetter;
import com.stripe.net.StripeResponseGetterOptions;
import com.stripe.net.Webhook;
import com.stripe.service.AccountLinkService;
import com.stripe.service.AccountService;
import com.stripe.service.AccountSessionService;
import com.stripe.service.ApplePayDomainService;
import com.stripe.service.ApplicationFeeService;
import com.stripe.service.AppsService;
import com.stripe.service.BalanceService;
import com.stripe.service.BalanceSettingsService;
import com.stripe.service.BalanceTransactionService;
import com.stripe.service.BillingPortalService;
import com.stripe.service.BillingService;
import com.stripe.service.ChargeService;
import com.stripe.service.CheckoutService;
import com.stripe.service.ClimateService;
import com.stripe.service.ConfirmationTokenService;
import com.stripe.service.CountrySpecService;
import com.stripe.service.CouponService;
import com.stripe.service.CreditNoteService;
import com.stripe.service.CustomerService;
import com.stripe.service.CustomerSessionService;
import com.stripe.service.DisputeService;
import com.stripe.service.EntitlementsService;
import com.stripe.service.EphemeralKeyService;
import com.stripe.service.EventService;
import com.stripe.service.ExchangeRateService;
import com.stripe.service.FileLinkService;
import com.stripe.service.FileService;
import com.stripe.service.FinancialConnectionsService;
import com.stripe.service.ForwardingService;
import com.stripe.service.IdentityService;
import com.stripe.service.InvoiceItemService;
import com.stripe.service.InvoicePaymentService;
import com.stripe.service.InvoiceRenderingTemplateService;
import com.stripe.service.InvoiceService;
import com.stripe.service.IssuingService;
import com.stripe.service.MandateService;
import com.stripe.service.PaymentIntentService;
import com.stripe.service.PaymentLinkService;
import com.stripe.service.PaymentMethodConfigurationService;
import com.stripe.service.PaymentMethodDomainService;
import com.stripe.service.PaymentMethodService;
import com.stripe.service.PayoutService;
import com.stripe.service.PlanService;
import com.stripe.service.PriceService;
import com.stripe.service.ProductService;
import com.stripe.service.PromotionCodeService;
import com.stripe.service.QuoteService;
import com.stripe.service.RadarService;
import com.stripe.service.RefundService;
import com.stripe.service.ReportingService;
import com.stripe.service.ReviewService;
import com.stripe.service.SetupAttemptService;
import com.stripe.service.SetupIntentService;
import com.stripe.service.ShippingRateService;
import com.stripe.service.SigmaService;
import com.stripe.service.SourceService;
import com.stripe.service.SubscriptionItemService;
import com.stripe.service.SubscriptionScheduleService;
import com.stripe.service.SubscriptionService;
import com.stripe.service.TaxCodeService;
import com.stripe.service.TaxIdService;
import com.stripe.service.TaxRateService;
import com.stripe.service.TaxService;
import com.stripe.service.TerminalService;
import com.stripe.service.TestHelpersService;
import com.stripe.service.TokenService;
import com.stripe.service.TopupService;
import com.stripe.service.TransferService;
import com.stripe.service.TreasuryService;
import com.stripe.service.V1Services;
import com.stripe.service.V2Services;
import com.stripe.service.WebhookEndpointService;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import lombok.Generated;

public class StripeClient {
    private final StripeResponseGetter responseGetter;

    public StripeClient(String apiKey) {
        this.responseGetter = new LiveStripeResponseGetter(StripeClient.builder().setApiKey(apiKey).buildOptions(), null);
    }

    public StripeClient(StripeResponseGetter responseGetter) {
        this.responseGetter = responseGetter;
    }

    protected StripeResponseGetter getResponseGetter() {
        return this.responseGetter;
    }

    public EventNotification parseEventNotification(String payload, String sigHeader, String secret) throws SignatureVerificationException {
        return this.parseEventNotification(payload, sigHeader, secret, 300L);
    }

    public EventNotification parseEventNotification(String payload, String sigHeader, String secret, long tolerance) throws SignatureVerificationException {
        Webhook.Signature.verifyHeader(payload, sigHeader, secret, tolerance);
        return EventNotification.fromJson(payload, this);
    }

    public Event constructEvent(String payload, String sigHeader, String secret) throws SignatureVerificationException {
        Event event = Webhook.constructEvent(payload, sigHeader, secret);
        event.setResponseGetter(this.getResponseGetter());
        return event;
    }

    public Event constructEvent(String payload, String sigHeader, String secret, long tolerance) throws SignatureVerificationException {
        Event event = Webhook.constructEvent(payload, sigHeader, secret, tolerance);
        event.setResponseGetter(this.getResponseGetter());
        return event;
    }

    public V1Services v1() {
        return new V1Services(this.getResponseGetter());
    }

    public V2Services v2() {
        return new V2Services(this.getResponseGetter());
    }

    @Deprecated
    public AccountLinkService accountLinks() {
        return new AccountLinkService(this.getResponseGetter());
    }

    @Deprecated
    public AccountSessionService accountSessions() {
        return new AccountSessionService(this.getResponseGetter());
    }

    @Deprecated
    public AccountService accounts() {
        return new AccountService(this.getResponseGetter());
    }

    @Deprecated
    public ApplePayDomainService applePayDomains() {
        return new ApplePayDomainService(this.getResponseGetter());
    }

    @Deprecated
    public ApplicationFeeService applicationFees() {
        return new ApplicationFeeService(this.getResponseGetter());
    }

    @Deprecated
    public AppsService apps() {
        return new AppsService(this.getResponseGetter());
    }

    @Deprecated
    public BalanceService balance() {
        return new BalanceService(this.getResponseGetter());
    }

    @Deprecated
    public BalanceSettingsService balanceSettings() {
        return new BalanceSettingsService(this.getResponseGetter());
    }

    @Deprecated
    public BalanceTransactionService balanceTransactions() {
        return new BalanceTransactionService(this.getResponseGetter());
    }

    @Deprecated
    public BillingService billing() {
        return new BillingService(this.getResponseGetter());
    }

    @Deprecated
    public BillingPortalService billingPortal() {
        return new BillingPortalService(this.getResponseGetter());
    }

    @Deprecated
    public ChargeService charges() {
        return new ChargeService(this.getResponseGetter());
    }

    @Deprecated
    public CheckoutService checkout() {
        return new CheckoutService(this.getResponseGetter());
    }

    @Deprecated
    public ClimateService climate() {
        return new ClimateService(this.getResponseGetter());
    }

    @Deprecated
    public ConfirmationTokenService confirmationTokens() {
        return new ConfirmationTokenService(this.getResponseGetter());
    }

    @Deprecated
    public CountrySpecService countrySpecs() {
        return new CountrySpecService(this.getResponseGetter());
    }

    @Deprecated
    public CouponService coupons() {
        return new CouponService(this.getResponseGetter());
    }

    @Deprecated
    public CreditNoteService creditNotes() {
        return new CreditNoteService(this.getResponseGetter());
    }

    @Deprecated
    public CustomerSessionService customerSessions() {
        return new CustomerSessionService(this.getResponseGetter());
    }

    @Deprecated
    public CustomerService customers() {
        return new CustomerService(this.getResponseGetter());
    }

    @Deprecated
    public DisputeService disputes() {
        return new DisputeService(this.getResponseGetter());
    }

    @Deprecated
    public EntitlementsService entitlements() {
        return new EntitlementsService(this.getResponseGetter());
    }

    @Deprecated
    public EphemeralKeyService ephemeralKeys() {
        return new EphemeralKeyService(this.getResponseGetter());
    }

    @Deprecated
    public EventService events() {
        return new EventService(this.getResponseGetter());
    }

    @Deprecated
    public ExchangeRateService exchangeRates() {
        return new ExchangeRateService(this.getResponseGetter());
    }

    @Deprecated
    public FileLinkService fileLinks() {
        return new FileLinkService(this.getResponseGetter());
    }

    @Deprecated
    public FileService files() {
        return new FileService(this.getResponseGetter());
    }

    @Deprecated
    public FinancialConnectionsService financialConnections() {
        return new FinancialConnectionsService(this.getResponseGetter());
    }

    @Deprecated
    public ForwardingService forwarding() {
        return new ForwardingService(this.getResponseGetter());
    }

    @Deprecated
    public IdentityService identity() {
        return new IdentityService(this.getResponseGetter());
    }

    @Deprecated
    public InvoiceItemService invoiceItems() {
        return new InvoiceItemService(this.getResponseGetter());
    }

    @Deprecated
    public InvoicePaymentService invoicePayments() {
        return new InvoicePaymentService(this.getResponseGetter());
    }

    @Deprecated
    public InvoiceRenderingTemplateService invoiceRenderingTemplates() {
        return new InvoiceRenderingTemplateService(this.getResponseGetter());
    }

    @Deprecated
    public InvoiceService invoices() {
        return new InvoiceService(this.getResponseGetter());
    }

    @Deprecated
    public IssuingService issuing() {
        return new IssuingService(this.getResponseGetter());
    }

    @Deprecated
    public MandateService mandates() {
        return new MandateService(this.getResponseGetter());
    }

    @Deprecated
    public PaymentIntentService paymentIntents() {
        return new PaymentIntentService(this.getResponseGetter());
    }

    @Deprecated
    public PaymentLinkService paymentLinks() {
        return new PaymentLinkService(this.getResponseGetter());
    }

    @Deprecated
    public PaymentMethodConfigurationService paymentMethodConfigurations() {
        return new PaymentMethodConfigurationService(this.getResponseGetter());
    }

    @Deprecated
    public PaymentMethodDomainService paymentMethodDomains() {
        return new PaymentMethodDomainService(this.getResponseGetter());
    }

    @Deprecated
    public PaymentMethodService paymentMethods() {
        return new PaymentMethodService(this.getResponseGetter());
    }

    @Deprecated
    public PayoutService payouts() {
        return new PayoutService(this.getResponseGetter());
    }

    @Deprecated
    public PlanService plans() {
        return new PlanService(this.getResponseGetter());
    }

    @Deprecated
    public PriceService prices() {
        return new PriceService(this.getResponseGetter());
    }

    @Deprecated
    public ProductService products() {
        return new ProductService(this.getResponseGetter());
    }

    @Deprecated
    public PromotionCodeService promotionCodes() {
        return new PromotionCodeService(this.getResponseGetter());
    }

    @Deprecated
    public QuoteService quotes() {
        return new QuoteService(this.getResponseGetter());
    }

    @Deprecated
    public RadarService radar() {
        return new RadarService(this.getResponseGetter());
    }

    @Deprecated
    public RefundService refunds() {
        return new RefundService(this.getResponseGetter());
    }

    @Deprecated
    public ReportingService reporting() {
        return new ReportingService(this.getResponseGetter());
    }

    @Deprecated
    public ReviewService reviews() {
        return new ReviewService(this.getResponseGetter());
    }

    @Deprecated
    public SetupAttemptService setupAttempts() {
        return new SetupAttemptService(this.getResponseGetter());
    }

    @Deprecated
    public SetupIntentService setupIntents() {
        return new SetupIntentService(this.getResponseGetter());
    }

    @Deprecated
    public ShippingRateService shippingRates() {
        return new ShippingRateService(this.getResponseGetter());
    }

    @Deprecated
    public SigmaService sigma() {
        return new SigmaService(this.getResponseGetter());
    }

    @Deprecated
    public SourceService sources() {
        return new SourceService(this.getResponseGetter());
    }

    @Deprecated
    public SubscriptionItemService subscriptionItems() {
        return new SubscriptionItemService(this.getResponseGetter());
    }

    @Deprecated
    public SubscriptionScheduleService subscriptionSchedules() {
        return new SubscriptionScheduleService(this.getResponseGetter());
    }

    @Deprecated
    public SubscriptionService subscriptions() {
        return new SubscriptionService(this.getResponseGetter());
    }

    @Deprecated
    public TaxService tax() {
        return new TaxService(this.getResponseGetter());
    }

    @Deprecated
    public TaxCodeService taxCodes() {
        return new TaxCodeService(this.getResponseGetter());
    }

    @Deprecated
    public TaxIdService taxIds() {
        return new TaxIdService(this.getResponseGetter());
    }

    @Deprecated
    public TaxRateService taxRates() {
        return new TaxRateService(this.getResponseGetter());
    }

    @Deprecated
    public TerminalService terminal() {
        return new TerminalService(this.getResponseGetter());
    }

    @Deprecated
    public TestHelpersService testHelpers() {
        return new TestHelpersService(this.getResponseGetter());
    }

    @Deprecated
    public TokenService tokens() {
        return new TokenService(this.getResponseGetter());
    }

    @Deprecated
    public TopupService topups() {
        return new TopupService(this.getResponseGetter());
    }

    @Deprecated
    public TransferService transfers() {
        return new TransferService(this.getResponseGetter());
    }

    @Deprecated
    public TreasuryService treasury() {
        return new TreasuryService(this.getResponseGetter());
    }

    @Deprecated
    public WebhookEndpointService webhookEndpoints() {
        return new WebhookEndpointService(this.getResponseGetter());
    }

    public static StripeClientBuilder builder() {
        return new StripeClientBuilder();
    }

    public StripeResponse rawRequest(ApiResource.RequestMethod method, String relativeUrl, String content) throws StripeException {
        return this.rawRequest(method, relativeUrl, content, null);
    }

    public StripeResponse rawRequest(ApiResource.RequestMethod method, String relativeUrl, String content, RawRequestOptions options) throws StripeException {
        if (options == null) {
            options = RawRequestOptions.builder().build();
        }
        if (method != ApiResource.RequestMethod.POST && content != null && !content.equals("")) {
            throw new IllegalArgumentException("content is not allowed for non-POST requests. Please pass null and add request parameters to the query string of the URL.");
        }
        RawApiRequest req = new RawApiRequest(BaseAddress.API, method, relativeUrl, content, options);
        req = req.addUsage("stripe_client");
        req = req.addUsage("raw_request");
        return this.getResponseGetter().rawRequest(req);
    }

    public StripeObject deserialize(String rawJson, ApiMode apiMode) throws StripeException {
        return StripeObject.deserializeStripeObject(rawJson, this.getResponseGetter(), apiMode);
    }

    public static final class StripeClientBuilder {
        private Authenticator authenticator;
        private String clientId;
        private int connectTimeout = 30000;
        private int readTimeout = 80000;
        private int maxNetworkRetries;
        private Proxy connectionProxy;
        private PasswordAuthentication proxyCredential;
        private String apiBase = "https://api.stripe.com";
        private String filesBase = "https://files.stripe.com";
        private String connectBase = "https://connect.stripe.com";
        private String meterEventsBase = "https://meter-events.stripe.com";
        private String stripeAccount;
        private String stripeContext;

        public Authenticator getAuthenticator() {
            return this.authenticator;
        }

        public StripeClientBuilder setAuthenticator(Authenticator authenticator) {
            this.authenticator = authenticator;
            return this;
        }

        public String getApiKey() {
            if (this.authenticator instanceof BearerTokenAuthenticator) {
                return ((BearerTokenAuthenticator)this.authenticator).getApiKey();
            }
            return null;
        }

        public StripeClientBuilder setApiKey(String apiKey) {
            this.authenticator = apiKey == null ? null : new BearerTokenAuthenticator(apiKey);
            return this;
        }

        public StripeClientBuilder clearApiKey() {
            this.authenticator = null;
            return this;
        }

        public String getClientId() {
            return this.clientId;
        }

        public StripeClientBuilder setClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public int getConnectTimeout() {
            return this.connectTimeout;
        }

        public StripeClientBuilder setConnectTimeout(int timeout) {
            this.connectTimeout = timeout;
            return this;
        }

        public int getReadTimeout() {
            return this.readTimeout;
        }

        public StripeClientBuilder setReadTimeout(int timeout) {
            this.readTimeout = timeout;
            return this;
        }

        public int getMaxNetworkRetries() {
            return this.maxNetworkRetries;
        }

        public StripeClientBuilder setMaxNetworkRetries(int maxNetworkRetries) {
            this.maxNetworkRetries = maxNetworkRetries;
            return this;
        }

        public Proxy getConnectionProxy() {
            return this.connectionProxy;
        }

        public StripeClientBuilder setConnectionProxy(Proxy connectionProxy) {
            this.connectionProxy = connectionProxy;
            return this;
        }

        public PasswordAuthentication getProxyCredential() {
            return this.proxyCredential;
        }

        public StripeClientBuilder setProxyCredential(PasswordAuthentication proxyCredential) {
            this.proxyCredential = proxyCredential;
            return this;
        }

        public StripeClientBuilder setApiBase(String address) {
            this.apiBase = address;
            return this;
        }

        public String getApiBase() {
            return this.apiBase;
        }

        public StripeClientBuilder setFilesBase(String address) {
            this.filesBase = address;
            return this;
        }

        public String getFilesBase() {
            return this.filesBase;
        }

        public StripeClientBuilder setConnectBase(String address) {
            this.connectBase = address;
            return this;
        }

        public String getConnectBase() {
            return this.connectBase;
        }

        public StripeClientBuilder setMeterEventsBase(String address) {
            this.meterEventsBase = address;
            return this;
        }

        public String getMeterEventsBase() {
            return this.meterEventsBase;
        }

        public StripeClientBuilder setStripeAccount(String account) {
            this.stripeAccount = account;
            return this;
        }

        public String getStripeAccount() {
            return this.stripeAccount;
        }

        public StripeClientBuilder setStripeContext(String context) {
            this.stripeContext = context;
            return this;
        }

        public StripeClientBuilder setStripeContext(StripeContext context) {
            this.stripeContext = context == null ? null : context.toString();
            return this;
        }

        public String getStripeContext() {
            return this.stripeContext;
        }

        public StripeClient build() {
            return new StripeClient(new LiveStripeResponseGetter(this.buildOptions(), null));
        }

        StripeResponseGetterOptions buildOptions() {
            if (this.authenticator == null) {
                throw new IllegalArgumentException("No authentication settings provided. Use setApiKey to set the Stripe API key");
            }
            return new ClientStripeResponseGetterOptions(this.authenticator, this.clientId, this.connectTimeout, this.readTimeout, this.maxNetworkRetries, this.connectionProxy, this.proxyCredential, this.apiBase, this.filesBase, this.connectBase, this.meterEventsBase, this.stripeAccount, this.stripeContext);
        }
    }

    static class ClientStripeResponseGetterOptions
    extends StripeResponseGetterOptions {
        private final Authenticator authenticator;
        private final String clientId;
        private final int connectTimeout;
        private final int readTimeout;
        private final int maxNetworkRetries;
        private final Proxy connectionProxy;
        private final PasswordAuthentication proxyCredential;
        private final String apiBase;
        private final String filesBase;
        private final String connectBase;
        private final String meterEventsBase;
        private final String stripeAccount;
        private final String stripeContext;

        ClientStripeResponseGetterOptions(Authenticator authenticator, String clientId, int connectTimeout, int readTimeout, int maxNetworkRetries, Proxy connectionProxy, PasswordAuthentication proxyCredential, String apiBase, String filesBase, String connectBase, String meterEventsBase, String stripeAccount, String stripeContext) {
            this.authenticator = authenticator;
            this.clientId = clientId;
            this.connectTimeout = connectTimeout;
            this.readTimeout = readTimeout;
            this.maxNetworkRetries = maxNetworkRetries;
            this.connectionProxy = connectionProxy;
            this.proxyCredential = proxyCredential;
            this.apiBase = apiBase;
            this.filesBase = filesBase;
            this.connectBase = connectBase;
            this.meterEventsBase = meterEventsBase;
            this.stripeAccount = stripeAccount;
            this.stripeContext = stripeContext;
        }

        @Override
        @Generated
        public Authenticator getAuthenticator() {
            return this.authenticator;
        }

        @Override
        @Generated
        public String getClientId() {
            return this.clientId;
        }

        @Override
        @Generated
        public int getConnectTimeout() {
            return this.connectTimeout;
        }

        @Override
        @Generated
        public int getReadTimeout() {
            return this.readTimeout;
        }

        @Override
        @Generated
        public int getMaxNetworkRetries() {
            return this.maxNetworkRetries;
        }

        @Override
        @Generated
        public Proxy getConnectionProxy() {
            return this.connectionProxy;
        }

        @Override
        @Generated
        public PasswordAuthentication getProxyCredential() {
            return this.proxyCredential;
        }

        @Override
        @Generated
        public String getApiBase() {
            return this.apiBase;
        }

        @Override
        @Generated
        public String getFilesBase() {
            return this.filesBase;
        }

        @Override
        @Generated
        public String getConnectBase() {
            return this.connectBase;
        }

        @Override
        @Generated
        public String getMeterEventsBase() {
            return this.meterEventsBase;
        }

        @Override
        @Generated
        public String getStripeAccount() {
            return this.stripeAccount;
        }

        @Override
        @Generated
        public String getStripeContext() {
            return this.stripeContext;
        }
    }
}

