/*
 * Decompiled with CFR 0.152.
 */
package com.stripe;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public final class StripeContext {
    private final List<String> segments;

    public StripeContext() {
        this(null);
    }

    public StripeContext(List<String> segments) {
        this.segments = segments == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(segments));
    }

    public StripeContext push(String segment) {
        ArrayList<String> newSegments = new ArrayList<String>(this.segments);
        newSegments.add(segment);
        return new StripeContext(newSegments);
    }

    public StripeContext pop() {
        if (this.segments.isEmpty()) {
            throw new IllegalStateException("Cannot pop from an empty StripeContext");
        }
        ArrayList<String> newSegments = new ArrayList<String>(this.segments);
        newSegments.remove(newSegments.size() - 1);
        return new StripeContext(newSegments);
    }

    public String toString() {
        return String.join((CharSequence)"/", this.segments);
    }

    public static StripeContext parse(String contextStr) {
        if (contextStr == null || contextStr.isEmpty()) {
            return new StripeContext();
        }
        List<String> segments = Arrays.asList(contextStr.split("/"));
        return new StripeContext(segments);
    }

    public List<String> getSegments() {
        return this.segments;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StripeContext)) {
            return false;
        }
        StripeContext other = (StripeContext)o;
        List<String> this$segments = this.getSegments();
        List<String> other$segments = other.getSegments();
        return !(this$segments == null ? other$segments != null : !((Object)this$segments).equals(other$segments));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $segments = this.getSegments();
        result = result * 59 + ($segments == null ? 43 : ((Object)$segments).hashCode());
        return result;
    }
}

