/*
 * Decompiled with CFR 0.152.
 */
package com.talanlabs.avatargenerator;

import com.talanlabs.avatargenerator.AvatarException;
import com.talanlabs.avatargenerator.IAvatarInfo;
import com.talanlabs.avatargenerator.cache.ICache;
import com.talanlabs.avatargenerator.element.ElementInfo;
import com.talanlabs.avatargenerator.element.ElementRegistry;
import com.talanlabs.avatargenerator.layers.ILayer;
import com.talanlabs.avatargenerator.utils.AvatarUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import javax.imageio.ImageIO;

public class Avatar {
    private int width = 128;
    private int height = 128;
    private int padding = 0;
    private int margin = 0;
    private ElementRegistry elementRegistry = null;
    private IColorizeFunction colorizeFunction = null;
    private ILayer[] layers;
    private ICache cache;

    private Avatar() {
    }

    public static AvatarBuilder newBuilder() {
        return new AvatarBuilder();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getPadding() {
        return this.padding;
    }

    public int getMargin() {
        return this.margin;
    }

    public BufferedImage create(long code) {
        Random random = new Random(code);
        MyAvatarInfo avatarInfo = new MyAvatarInfo(code, random);
        if (this.cache != null) {
            return this.cache.get(avatarInfo, this::buildAll);
        }
        return this.buildAll(avatarInfo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] createAsPngBytes(long code) {
        BufferedImage src = this.create(code);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)src, "png", baos);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new AvatarException("Failed to write png for code=" + code, e);
        }
    }

    public void createAsPngToFile(long code, File file) {
        BufferedImage src = this.create(code);
        try {
            ImageIO.write((RenderedImage)src, "png", file);
        }
        catch (IOException e) {
            throw new AvatarException("Failed to write png for code=" + code, e);
        }
    }

    private BufferedImage buildAll(IAvatarInfo avatarInfo) {
        try {
            BufferedImage bufferedImage = this.buildAvatarImage(avatarInfo);
            int wm = this.width - this.margin * 2;
            int hm = this.height - this.margin * 2;
            int wmp = wm - this.padding * 2;
            int hmp = hm - this.padding * 2;
            bufferedImage = AvatarUtils.resizeImage(bufferedImage, wmp, hmp);
            bufferedImage = AvatarUtils.planImage(bufferedImage, wm, hm);
            if (this.layers != null && this.layers.length > 0) {
                for (ILayer layer : this.layers) {
                    bufferedImage = layer.apply(avatarInfo, bufferedImage);
                }
            }
            bufferedImage = AvatarUtils.resizeImage(bufferedImage, wm, hm);
            bufferedImage = AvatarUtils.planImage(bufferedImage, this.width, this.height);
            return bufferedImage;
        }
        catch (Exception e) {
            throw new AvatarException("Failed to build avatar", e);
        }
    }

    private BufferedImage buildAvatarImage(IAvatarInfo avatarInfo) throws IOException {
        int d;
        ElementInfo[] elements;
        if (this.elementRegistry == null) {
            return new BufferedImage(this.width - (this.margin + this.padding) * 2, this.height - (this.margin + this.padding) * 2, 2);
        }
        Random random = avatarInfo.getRandom();
        int xmin = Integer.MAX_VALUE;
        int ymin = Integer.MAX_VALUE;
        int xmax = Integer.MIN_VALUE;
        int ymax = Integer.MIN_VALUE;
        ArrayList<ImageInfo> imageInfos = new ArrayList<ImageInfo>();
        int groupCount = this.elementRegistry.getGroupCount(avatarInfo);
        if (groupCount > 0 && (elements = this.elementRegistry.getGroup(avatarInfo, d = random.nextInt(groupCount))) != null && elements.length > 0) {
            for (ElementInfo element : elements) {
                int elementCount = this.elementRegistry.getElementCount(avatarInfo, element.name);
                if (elementCount <= 0) continue;
                int index = random.nextInt(elementCount);
                BufferedImage bufferedImage = AvatarUtils.toARGBImage(this.elementRegistry.getElement(avatarInfo, element.name, index));
                xmin = Math.min(xmin, -bufferedImage.getWidth() / 2 + element.offsetX);
                xmax = Math.max(xmax, bufferedImage.getWidth() / 2 + element.offsetX);
                ymin = Math.min(ymin, -bufferedImage.getHeight() / 2 + element.offsetY);
                ymax = Math.max(ymax, bufferedImage.getHeight() / 2 + element.offsetY);
                imageInfos.add(new ImageInfo(element.name, bufferedImage, element.offsetX, element.offsetY));
            }
        }
        int w = xmax - xmin;
        int h = ymax - ymin;
        BufferedImage dest = new BufferedImage(w, h, 2);
        Graphics2D g2 = dest.createGraphics();
        AvatarUtils.activeAntialiasing(g2);
        for (ImageInfo imageInfo : imageInfos) {
            this.copyImage(g2, avatarInfo, imageInfo, w, h);
        }
        g2.dispose();
        return dest;
    }

    private void copyImage(Graphics2D g2, IAvatarInfo avatarInfo, ImageInfo imageInfo, int width, int height) throws IOException {
        Color color;
        BufferedImage img = imageInfo.image;
        if (this.colorizeFunction != null && (color = this.colorizeFunction.colorize(avatarInfo, imageInfo.element)) != null) {
            img = AvatarUtils.tintImage(img, color);
        }
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        int x = (width - w) / 2 + imageInfo.offsetX;
        int y = (height - h) / 2 + imageInfo.offsetY;
        g2.drawImage(img, x, y, w, h, null);
    }

    static /* synthetic */ ILayer[] access$802(Avatar x0, ILayer[] x1) {
        x0.layers = x1;
        return x1;
    }

    private class MyAvatarInfo
    implements IAvatarInfo {
        private long code;
        private Random random;

        public MyAvatarInfo(long code, Random random) {
            this.code = code;
            this.random = random;
        }

        @Override
        public long getCode() {
            return this.code;
        }

        @Override
        public Random getRandom() {
            return this.random;
        }

        @Override
        public int getWidth() {
            return Avatar.this.width;
        }

        @Override
        public int getHeight() {
            return Avatar.this.height;
        }

        @Override
        public int getPadding() {
            return Avatar.this.padding;
        }

        @Override
        public int getMargin() {
            return Avatar.this.margin;
        }
    }

    private static class ImageInfo {
        public final String element;
        public final BufferedImage image;
        public final int offsetX;
        public final int offsetY;

        ImageInfo(String element, BufferedImage image, int offsetX, int offsetY) {
            this.element = element;
            this.image = image;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
        }
    }

    public static class AvatarBuilder {
        private int width = 128;
        private int height = 128;
        private int padding = 0;
        private int margin = 0;
        private ElementRegistry elementRegistry = null;
        private IColorizeFunction colorizeFunction = null;
        private ILayer[] layers;
        private ICache cache;

        private AvatarBuilder() {
        }

        public AvatarBuilder elementRegistry(ElementRegistry elementRegistry) {
            this.elementRegistry = elementRegistry;
            return this;
        }

        public AvatarBuilder size(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public AvatarBuilder padding(int padding) {
            this.padding = padding;
            return this;
        }

        public AvatarBuilder margin(int margin) {
            this.margin = margin;
            return this;
        }

        public AvatarBuilder layers(ILayer ... layers) {
            this.layers = layers;
            return this;
        }

        public AvatarBuilder color(Color color) {
            return this.colorizeFunction((c, e) -> color);
        }

        public AvatarBuilder colorizeFunction(IColorizeFunction colorizeFunction) {
            this.colorizeFunction = colorizeFunction;
            return this;
        }

        public AvatarBuilder cache(ICache cache) {
            this.cache = cache;
            return this;
        }

        public Avatar build() {
            Avatar avatar = new Avatar();
            avatar.width = this.width;
            avatar.height = this.height;
            avatar.padding = this.padding;
            avatar.margin = this.margin;
            avatar.elementRegistry = this.elementRegistry;
            avatar.colorizeFunction = this.colorizeFunction;
            Avatar.access$802(avatar, this.layers != null ? Arrays.copyOf(this.layers, this.layers.length) : null);
            avatar.cache = this.cache;
            return avatar;
        }
    }

    public static interface IColorizeFunction {
        public Color colorize(IAvatarInfo var1, String var2);
    }
}

