/*
 * Decompiled with CFR 0.152.
 */
package com.talanlabs.avatargenerator.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.talanlabs.avatargenerator.IAvatarInfo;
import com.talanlabs.avatargenerator.cache.ICache;
import java.awt.image.BufferedImage;
import java.util.concurrent.ExecutionException;

public class MemoryCache
implements ICache {
    private Cache<String, BufferedImage> cache = CacheBuilder.newBuilder().softValues().build();

    @Override
    public BufferedImage get(IAvatarInfo avatarInfo, ICache.ILoader loader) {
        String key = avatarInfo.getWidth() + "-" + avatarInfo.getHeight() + "-" + avatarInfo.getMargin() + "-" + avatarInfo.getPadding() + "-" + avatarInfo.getCode();
        try {
            return (BufferedImage)this.cache.get((Object)key, () -> loader.load(avatarInfo));
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Failed to get image from " + key, e);
        }
    }
}

