/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.rs;

import com.taosdata.jdbc.AbstractDriver;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.rs.ConnectionParam;
import com.taosdata.jdbc.rs.RestfulConnection;
import com.taosdata.jdbc.utils.HttpClientPoolUtil;
import com.taosdata.jdbc.utils.StringUtils;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Base64;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class RestfulDriver
extends AbstractDriver {
    private static final Logger log = LoggerFactory.getLogger(RestfulDriver.class);
    public static final String URL_PREFIX = "jdbc:TAOS-RS://";

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (url == null || url.trim().isEmpty() || url.trim().replaceAll("\\s", "").isEmpty()) {
            throw TSDBError.createSQLException(8978);
        }
        if (!this.acceptsURL(url)) {
            return null;
        }
        Properties props = StringUtils.parseUrl(url, info);
        String batchLoad = info.getProperty("batchfetch");
        if (Boolean.parseBoolean(batchLoad)) {
            ConnectionParam param = ConnectionParam.getParamWs(props);
            return this.getWSConnection(url, param, props);
        }
        HttpClientPoolUtil.init(props);
        ConnectionParam param = ConnectionParam.getParam(props);
        String auth = null;
        if (param.getUser() != null && param.getPassword() != null) {
            auth = Base64.getEncoder().encodeToString((param.getUser() + ":" + param.getPassword()).getBytes(StandardCharsets.UTF_8));
        }
        RestfulConnection conn = new RestfulConnection(param.getEndpoints().get(0).getHost(), String.valueOf(param.getEndpoints().get(0).getPort()), props, param.getDatabase(), url, auth, param.isUseSsl(), param.getCloudToken(), param.getTz());
        if (param.getDatabase() != null && !param.getDatabase().trim().replaceAll("\\s", "").isEmpty()) {
            try (Statement stmt = conn.createStatement();){
                stmt.execute("use " + param.getDatabase());
            }
        }
        return conn;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            throw TSDBError.createSQLException(8978);
        }
        return url.trim().length() > 0 && url.startsWith(URL_PREFIX);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        if (info == null) {
            info = new Properties();
        }
        if (this.acceptsURL(url)) {
            info = StringUtils.parseUrl(url, info);
        }
        return this.getPropertyInfo(info);
    }

    @Override
    public int getMajorVersion() {
        return 3;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    static {
        try {
            DriverManager.registerDriver(new RestfulDriver());
        }
        catch (SQLException e) {
            throw TSDBError.createRuntimeException(8978, e);
        }
    }
}

