/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws;

import com.taosdata.jdbc.AbstractConnection;
import com.taosdata.jdbc.rs.ConnectionParam;
import com.taosdata.jdbc.utils.ReqId;
import com.taosdata.jdbc.utils.StmtUtils;
import com.taosdata.jdbc.utils.Utils;
import com.taosdata.jdbc.ws.Transport;
import com.taosdata.jdbc.ws.WSStatement;
import com.taosdata.jdbc.ws.entity.Action;
import com.taosdata.jdbc.ws.entity.Code;
import com.taosdata.jdbc.ws.entity.Request;
import com.taosdata.jdbc.ws.stmt2.entity.RequestFactory;
import com.taosdata.jdbc.ws.stmt2.entity.ResultResp;
import com.taosdata.jdbc.ws.stmt2.entity.Stmt2ExecResp;
import com.taosdata.jdbc.ws.stmt2.entity.Stmt2PrepareResp;
import com.taosdata.jdbc.ws.stmt2.entity.Stmt2Resp;
import com.taosdata.jdbc.ws.stmt2.entity.StmtInfo;
import io.netty.buffer.ByteBuf;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSRetryableStmt
extends WSStatement {
    private static final Logger log = LoggerFactory.getLogger(WSRetryableStmt.class);
    private static final int OPERATION_TYPE_WRITE = 1;
    private static final int OPERATION_TYPE_QUERY = 2;
    protected final ConnectionParam param;
    protected StmtInfo stmtInfo;
    protected volatile SQLException lastError = null;
    protected final AtomicInteger batchInsertedRows;
    private long reconnectCount;

    public WSRetryableStmt(AbstractConnection connection, ConnectionParam param, String database, Transport transport, Long instanceId, StmtInfo stmtInfo, AtomicInteger batchInsertedRows) {
        super(transport, database, connection, instanceId, param.getZoneId());
        this.param = param;
        this.stmtInfo = stmtInfo;
        this.batchInsertedRows = batchInsertedRows;
        this.reconnectCount = transport.getReconnectCount();
    }

    public void initStmt(int retryTimes) throws SQLException {
        Stmt2PrepareResp prepareResp = StmtUtils.initStmtWithRetry(this.transport, this.stmtInfo.getSql(), retryTimes);
        this.stmtInfo.setStmtId(prepareResp.getStmtId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyStmtIdAndReqId(ByteBuf rawBlock, long stmtId, long reqId) {
        int originalWriterIndex = rawBlock.writerIndex();
        try {
            rawBlock.writerIndex(0);
            rawBlock.writeLongLE(reqId);
            rawBlock.writeLongLE(stmtId);
        }
        finally {
            rawBlock.writerIndex(originalWriterIndex);
        }
    }

    public void writeBlockWithRetry(ByteBuf rawBlock) throws SQLException {
        Utils.retainByteBuf(rawBlock);
        try {
            this.executeWithRetry(rawBlock, 1, this.param.isEnableAutoConnect());
        }
        finally {
            Utils.releaseByteBuf(rawBlock);
        }
    }

    public void writeBlockWithRetrySync(ByteBuf rawBlock) throws SQLException {
        Utils.retainByteBuf(rawBlock);
        try {
            this.executeWithRetry(rawBlock, 1, this.param.isEnableAutoConnect());
            if (this.lastError != null) {
                SQLException e = this.lastError;
                this.lastError = null;
                throw e;
            }
        }
        finally {
            Utils.releaseByteBuf(rawBlock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultResp queryWithRetry(ByteBuf rawBlock) throws SQLException {
        Utils.retainByteBuf(rawBlock);
        try {
            ResultResp resultResp = (ResultResp)this.executeWithRetry(rawBlock, 2, this.param.isEnableAutoConnect());
            if (this.lastError != null) {
                SQLException e = this.lastError;
                this.lastError = null;
                throw e;
            }
            ResultResp resultResp2 = resultResp;
            return resultResp2;
        }
        finally {
            Utils.releaseByteBuf(rawBlock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeWithRetry(ByteBuf orgRawBlock, int operationType, boolean isRetry) throws SQLException {
        ByteBuf rawBlock = orgRawBlock.duplicate();
        int originalReaderIndex = orgRawBlock.readerIndex();
        int originalWriterIndex = orgRawBlock.writerIndex();
        int retryCount = 1;
        if (isRetry) {
            retryCount = this.param.getRetryTimes();
        }
        for (int i = 0; i < retryCount; ++i) {
            block17: {
                Stmt2ExecResp resp;
                Request request;
                long reqId;
                block16: {
                    if (i > 0) {
                        rawBlock = orgRawBlock.copy();
                        rawBlock.readerIndex(originalReaderIndex);
                        rawBlock.writerIndex(originalWriterIndex);
                    }
                    reqId = ReqId.getReqID();
                    if (this.reconnectCount != (long)this.transport.getReconnectCount() && this.param.isEnableAutoConnect()) {
                        this.initStmt(1);
                        this.reconnectCount = this.transport.getReconnectCount();
                    }
                    this.modifyStmtIdAndReqId(rawBlock, this.stmtInfo.getStmtId(), reqId);
                    Stmt2Resp bindResp = (Stmt2Resp)this.transport.send(Action.STMT2_BIND.getAction(), reqId, rawBlock, false, this.getQueryTimeoutInMs());
                    if (Code.SUCCESS.getCode() != bindResp.getCode()) {
                        throw new SQLException("(0x" + Integer.toHexString(bindResp.getCode()) + "):" + bindResp.getMessage());
                    }
                    reqId = ReqId.getReqID();
                    request = RequestFactory.generateExec(this.stmtInfo.getStmtId(), reqId);
                    resp = (Stmt2ExecResp)this.transport.send(request, false, this.getQueryTimeoutInMs());
                    if (Code.SUCCESS.getCode() != resp.getCode()) {
                        throw new SQLException("(0x" + Integer.toHexString(resp.getCode()) + "):" + resp.getMessage());
                    }
                    if (operationType != 1) break block16;
                    int affectedRows = resp.getAffected();
                    this.batchInsertedRows.addAndGet(affectedRows);
                    Integer n = affectedRows;
                    log.trace("buffer {}, refCnt: {}", (Object)Integer.toHexString(System.identityHashCode(rawBlock)), (Object)rawBlock.refCnt());
                    return n;
                }
                if (operationType != 2) break block17;
                reqId = ReqId.getReqID();
                request = RequestFactory.generateUseResult(this.stmtInfo.getStmtId(), reqId);
                ResultResp useResultResp = (ResultResp)this.transport.send(request, false, this.getQueryTimeoutInMs());
                if (Code.SUCCESS.getCode() != resp.getCode()) {
                    throw new SQLException("(0x" + Integer.toHexString(resp.getCode()) + "):" + resp.getMessage());
                }
                ResultResp resultResp = useResultResp;
                log.trace("buffer {}, refCnt: {}", (Object)Integer.toHexString(System.identityHashCode(rawBlock)), (Object)rawBlock.refCnt());
                return resultResp;
            }
            try {
                throw new IllegalArgumentException("Unknown operation type: " + operationType);
            }
            catch (SQLException e) {
                boolean shouldContinue = this.handleException(e, i, this.reconnectCount, operationType);
                if (!shouldContinue) {
                    this.lastError = e;
                    log.trace("buffer {}, refCnt: {}", (Object)Integer.toHexString(System.identityHashCode(rawBlock)), (Object)rawBlock.refCnt());
                    break;
                }
                try {
                    if (this.reconnectCount == (long)this.transport.getReconnectCount()) continue;
                    log.error("connection reestablished, need to init stmt obj");
                    this.initStmt(1);
                    this.reconnectCount = this.transport.getReconnectCount();
                    continue;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    log.trace("buffer {}, refCnt: {}", (Object)Integer.toHexString(System.identityHashCode(rawBlock)), (Object)rawBlock.refCnt());
                }
            }
        }
        return null;
    }

    private boolean handleException(SQLException e, int retryCount, long reconnectCount, int operationType) {
        String operationName;
        String string = operationName = operationType == 1 ? "writeBlockWithRetry" : "queryWithRetry";
        if (retryCount == this.param.getRetryTimes() - 1) {
            this.lastError = e;
            return false;
        }
        log.error("Error in {}, stmt id: {}, retry times: {}, code: {}, msg: {}", new Object[]{operationName, this.stmtInfo.getStmtId(), retryCount, e.getErrorCode(), e.getMessage()});
        return this.shouldRetry(e, reconnectCount);
    }

    private boolean shouldRetry(SQLException e, long reconnectCount) {
        int realReconnectCount = this.transport.getReconnectCount();
        if (reconnectCount != (long)realReconnectCount) {
            return true;
        }
        if (e.getErrorCode() == 8990) {
            return true;
        }
        return e.getErrorCode() == 8961 || e.getErrorCode() == 8984;
    }

    public void releaseStmt() throws SQLException {
        if (this.stmtInfo.getStmtId() != 0L && this.transport.isConnected()) {
            long reqId = ReqId.getReqID();
            Request close = RequestFactory.generateClose(this.stmtInfo.getStmtId(), reqId);
            this.transport.send(close, this.getQueryTimeoutInMs());
        }
    }
}

