/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.spring.bean;

import com.qq.tars.client.Communicator;
import com.qq.tars.client.CommunicatorConfig;
import com.qq.tars.client.ServantProxyConfig;
import com.qq.tars.common.util.StringUtils;
import com.qq.tars.protocol.annotation.Servant;
import com.qq.tars.server.config.ConfigurationManager;
import com.qq.tars.spring.annotation.TarsClient;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public class CommunicatorBeanPostProcessor
implements BeanPostProcessor {
    private final Communicator communicator;

    public CommunicatorBeanPostProcessor(Communicator communicator) {
        this.communicator = communicator;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Class<?> clazz = bean.getClass();
        this.processFields(bean, clazz.getDeclaredFields());
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private void processFields(Object bean, Field[] declaredFields) {
        for (Field field : declaredFields) {
            TarsClient annotation = (TarsClient)AnnotationUtils.getAnnotation((AnnotatedElement)field, TarsClient.class);
            if (annotation == null) continue;
            if (field.getType().getAnnotation(Servant.class) == null) {
                throw new RuntimeException("[TARS] autowire client failed: target field is not  tars  client");
            }
            String objName = annotation.name();
            if (StringUtils.isEmpty((String)annotation.value())) {
                throw new RuntimeException("[TARS] autowire client failed: objName is empty");
            }
            ServantProxyConfig config = new ServantProxyConfig(objName);
            CommunicatorConfig communicatorConfig = ConfigurationManager.getInstance().getServerConfig().getCommunicatorConfig();
            config.setModuleName(communicatorConfig.getModuleName(), communicatorConfig.isEnableSet(), communicatorConfig.getSetDivision());
            if (StringUtils.isNotEmpty((String)communicatorConfig.getSetDivision())) {
                config.setSetDivision(communicatorConfig.getSetDivision());
            }
            if (StringUtils.isNotEmpty((String)annotation.setDivision())) {
                config.setSetDivision(communicatorConfig.getSetDivision());
                config.setEnableSet(annotation.enableSet());
            }
            config.setConnections(annotation.connections());
            config.setConnectTimeout(annotation.connectTimeout());
            config.setSyncTimeout(annotation.syncTimeout());
            config.setAsyncTimeout(annotation.asyncTimeout());
            config.setTcpNoDelay(annotation.tcpNoDelay());
            config.setCharsetName(annotation.charsetName());
            Object proxy = this.communicator.stringToProxy(field.getType(), config);
            ReflectionUtils.makeAccessible((Field)field);
            ReflectionUtils.setField((Field)field, (Object)bean, (Object)proxy);
        }
    }
}

