/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.server.apps;

import com.qq.tars.common.util.StringUtils;
import com.qq.tars.protocol.annotation.Servant;
import com.qq.tars.protocol.util.TarsHelper;
import com.qq.tars.server.apps.BaseAppContext;
import com.qq.tars.server.config.ConfigurationManager;
import com.qq.tars.server.config.ServantAdapterConfig;
import com.qq.tars.server.config.ServerConfig;
import com.qq.tars.server.core.AppContext;
import com.qq.tars.server.core.AppContextListener;
import com.qq.tars.server.core.AppService;
import com.qq.tars.server.core.ServantAdapter;
import com.qq.tars.server.core.ServantHomeSkeleton;
import com.qq.tars.spring.config.ListenerConfig;
import com.qq.tars.spring.config.ServantConfig;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringAppContext
extends BaseAppContext {
    private ApplicationContext applicationContext = null;

    protected void loadServants() {
        this.applicationContext = new ClassPathXmlApplicationContext("servants-spring.xml");
        this.loadAppContextListeners(this.applicationContext);
        this.loadAppServants(this.applicationContext);
        this.loadDefaultFilter();
        this.loadAppFilters(this.applicationContext);
    }

    private void loadAppContextListeners(ApplicationContext applicationContext) {
        Map servantMap = applicationContext.getBeansOfType(ListenerConfig.class);
        for (Map.Entry entry : servantMap.entrySet()) {
            AppContextListener listener = (AppContextListener)applicationContext.getBean(((ListenerConfig)entry.getValue()).getRef());
            this.listeners.add(listener);
        }
    }

    private void loadAppServants(ApplicationContext applicationContext) {
        Map servantMap = applicationContext.getBeansOfType(ServantConfig.class);
        for (Map.Entry entry : servantMap.entrySet()) {
            try {
                ServantHomeSkeleton skeleton = this.loadServant((ServantConfig)entry.getValue());
                this.skeletonMap.put(skeleton.name(), skeleton);
                this.appServantStarted((AppService)skeleton);
            }
            catch (Exception e) {
                System.err.println("init a service failed");
                e.printStackTrace();
            }
        }
    }

    private void loadAppFilters(ApplicationContext applicationContext) {
    }

    private ServantHomeSkeleton loadServant(ServantConfig servantConfig) throws Exception {
        String servantName;
        String homeName = null;
        String homeApiName = null;
        Class<?> homeApiClazz = null;
        Class codecClazz = null;
        Class processorClazz = null;
        Object homeClassImpl = null;
        ServantHomeSkeleton skeleton = null;
        int maxLoadLimit = -1;
        ServerConfig serverCfg = ConfigurationManager.getInstance().getServerConfig();
        homeName = servantConfig.getName();
        if (StringUtils.isEmpty((String)homeName)) {
            throw new RuntimeException("servant name is null.");
        }
        homeName = String.format("%s.%s.%s", serverCfg.getApplication(), serverCfg.getServerName(), homeName);
        homeApiName = servantConfig.getInterface();
        homeApiClazz = Class.forName(homeApiName);
        homeClassImpl = this.applicationContext.getBean(servantConfig.getRef());
        if (TarsHelper.isServant(homeApiClazz) && !StringUtils.isEmpty((String)(servantName = homeApiClazz.getAnnotation(Servant.class).name())) && servantName.matches("^[\\w]+\\.[\\w]+\\.[\\w]+$")) {
            homeName = servantName;
        }
        ServantAdapterConfig servantAdapterConfig = (ServantAdapterConfig)serverCfg.getServantAdapterConfMap().get(homeName);
        ServantAdapter ServerAdapter = new ServantAdapter(servantAdapterConfig);
        skeleton = new ServantHomeSkeleton(homeName, homeClassImpl, homeApiClazz, codecClazz, processorClazz, maxLoadLimit);
        skeleton.setAppContext((AppContext)this);
        ServerAdapter.bind((AppService)skeleton);
        this.servantAdapterMap.put(homeName, ServerAdapter);
        return skeleton;
    }
}

