/*
 * Decompiled with CFR 0.152.
 */
package com.tencent;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.RandomUtil;
import com.tencent.asr.constant.AsrConstant;
import com.tencent.asr.model.AsrConfig;
import com.tencent.asr.model.Credential;
import com.tencent.asr.model.SpeechRecognitionRequest;
import com.tencent.asr.model.SpeechRecognitionSysConfig;
import com.tencent.asr.service.FlashRecognizer;
import com.tencent.asr.service.SpeechHttpRecognizer;
import com.tencent.asr.service.SpeechRecognitionListener;
import com.tencent.asr.service.SpeechRecognizer;
import com.tencent.asr.service.SpeechWsRecognizer;
import com.tencent.core.model.GlobalConfig;
import com.tencent.core.service.StatService;
import com.tencent.tts.model.SpeechSynthesisConfig;
import com.tencent.tts.model.SpeechSynthesisRequest;
import com.tencent.tts.service.SpeechSynthesisListener;
import com.tencent.tts.service.SpeechSynthesizer;

public class SpeechClient {
    private static SpeechClient speechClient;
    private String appId;
    private String secretId;
    private String secretKey;
    private String token;

    private SpeechClient() {
    }

    public static SpeechClient newInstance(String appId, String secretId, String secretKey) {
        return SpeechClient.newInstance(appId, secretId, secretKey, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SpeechClient newInstance(String appId, String secretId, String secretKey, String token) {
        Assert.isFalse((appId == null ? 1 : 0) != 0, (String)"appId Cannot be empty", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)secretKey, (String)"secretKey Cannot be empty", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)secretId, (String)"secretId Cannot be empty", (Object[])new Object[0]);
        if (speechClient != null) return speechClient;
        Class<SpeechClient> clazz = SpeechClient.class;
        synchronized (SpeechClient.class) {
            if (speechClient != null) return speechClient;
            speechClient = new SpeechClient();
            speechClient.setAppId(appId);
            speechClient.setSecretId(secretId);
            speechClient.setSecretKey(secretKey);
            speechClient.setToken(token);
            if (!GlobalConfig.ifOpenStat.booleanValue()) return speechClient;
            StatService.setConfig(secretId, secretKey, appId, token);
            StatService.startReportStat();
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return speechClient;
        }
    }

    public void setSpeechClientConfig(String appId, String secretId, String secretKey, String token) {
        if (speechClient != null) {
            speechClient.setAppId(appId);
            speechClient.setSecretId(secretId);
            speechClient.setSecretKey(secretKey);
            speechClient.setToken(token);
            if (GlobalConfig.ifOpenStat.booleanValue()) {
                StatService.setConfig(secretId, secretKey, appId, token);
            }
        }
    }

    public SpeechSynthesizer newSpeechSynthesizer(SpeechSynthesisRequest speechSynthesisRequest, SpeechSynthesisListener eventListener) {
        SpeechSynthesisConfig config = SpeechSynthesisConfig.builder().appId(Long.valueOf(this.appId)).secretId(this.secretId).secretKey(this.secretKey).token(this.token).build();
        return new SpeechSynthesizer(config, speechSynthesisRequest, eventListener);
    }

    public SpeechRecognizer newSpeechRecognizer(SpeechRecognitionRequest request, SpeechRecognitionListener speechRecognitionListener) {
        AsrConfig config = AsrConfig.builder().appId(this.appId).secretId(this.secretId).secretKey(this.secretKey).token(this.token).build();
        if (request.getEngineModelType() == null) {
            throw new RuntimeException("engineModelType can not be null,please set SpeechRecognitionRequest EngineModelType !!");
        }
        if (AsrConstant.RequestWay.Http.equals((Object)SpeechRecognitionSysConfig.requestWay)) {
            return new SpeechHttpRecognizer(RandomUtil.randomString((int)8), config, request, speechRecognitionListener);
        }
        return new SpeechWsRecognizer(RandomUtil.randomString((int)8), config, request, speechRecognitionListener);
    }

    public static FlashRecognizer newFlashRecognizer(String appId, Credential credential) {
        AsrConfig config = AsrConfig.builder().appId(appId).secretId(credential.getSecretId()).secretKey(credential.getSecretKey()).token(credential.getToken()).build();
        return new FlashRecognizer(config);
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setSecretId(String secretId) {
        this.secretId = secretId;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getSecretId() {
        return this.secretId;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getToken() {
        return this.token;
    }
}

