/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.asr.service;

import cn.hutool.core.map.MapUtil;
import com.tencent.asr.constant.AsrConstant;
import com.tencent.asr.model.AsrConfig;
import com.tencent.asr.model.AsrRequestContent;
import com.tencent.asr.model.SpeechRecognitionRequest;
import com.tencent.asr.model.SpeechRecognitionResponse;
import com.tencent.asr.model.SpeechRecognitionSysConfig;
import com.tencent.asr.service.SpeechRecognitionListener;
import com.tencent.asr.service.SpeechRecognitionSignService;
import com.tencent.asr.service.SpeechRecognizer;
import com.tencent.asr.service.TractionManager;
import com.tencent.asr.service.WsClientService;
import com.tencent.asr.utils.AsrUtils;
import com.tencent.core.service.ReportService;
import com.tencent.core.utils.JsonUtil;
import com.tencent.core.utils.SignBuilder;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;

public class SpeechWsRecognizer
implements SpeechRecognizer {
    protected AsrConfig asrConfig;
    protected SpeechRecognitionRequest asrRequest;
    protected AsrRequestContent asrRequestContent;
    protected SpeechRecognitionListener listener;
    protected WebSocket webSocket;
    protected int reConnectMaxNum = 10;
    protected int connectNum = 0;
    protected volatile boolean isConnect = false;
    protected volatile AtomicBoolean endFlag = new AtomicBoolean(false);
    protected volatile AtomicBoolean startFlag = new AtomicBoolean(false);
    protected SpeechRecognitionSignService speechRecognitionSignService = new SpeechRecognitionSignService();
    private ReentrantLock lock = new ReentrantLock();
    private boolean begin = false;
    private AtomicLong adder = new AtomicLong(0L);
    private TractionManager tractionManager;

    public SpeechWsRecognizer(String streamId, AsrConfig config, SpeechRecognitionRequest request, SpeechRecognitionListener listener) {
        this.asrConfig = config;
        this.asrRequest = request;
        this.asrRequestContent = AsrRequestContent.builder().seq(0).end(0).streamId(streamId).voiceId(AsrUtils.getVoiceId(config.getAppId())).build();
        this.listener = listener;
        this.tractionManager = new TractionManager(config.getAppId());
    }

    @Override
    public void start() {
        this.startFlag.set(true);
        this.createWebsocket();
        if (this.listener != null) {
            SpeechRecognitionResponse recognitionResponse = new SpeechRecognitionResponse();
            recognitionResponse.setCode(0);
            recognitionResponse.setStreamId(this.asrRequestContent.getStreamId());
            recognitionResponse.setFinalSpeech(0);
            recognitionResponse.setVoiceId(this.asrRequestContent.getVoiceId());
            recognitionResponse.setMessage("success");
            this.listener.onRecognitionStart(recognitionResponse);
        }
        this.tractionManager.beginTraction(this.asrRequestContent.getStreamId());
    }

    @Override
    public void write(byte[] data) {
        if (!this.startFlag.get()) {
            throw new RuntimeException("please call start method!!");
        }
        if (!this.endFlag.get()) {
            this.createWebsocket();
            ReportService.ifLogMessage(this.getId(), "send " + this.adder.get() + " package", false);
            boolean success = this.webSocket.send(ByteString.of((byte[])data));
            ReportService.ifLogMessage(this.getId(), "send " + this.adder.get() + " package " + success, false);
            this.adder.incrementAndGet();
            if (!success) {
                for (int i = 0; i < SpeechRecognitionSysConfig.retryRequestNum && !(success = this.webSocket.send(ByteString.of((byte[])data))); ++i) {
                }
            }
        }
    }

    private void write(String data) {
        if (!this.endFlag.get()) {
            this.createWebsocket();
            ReportService.ifLogMessage(this.getId(), "send " + this.adder.get() + " end package", false);
            this.adder.incrementAndGet();
            this.webSocket.send(data);
        }
    }

    @Override
    public Boolean stop() {
        if (this.endFlag.get()) {
            return true;
        }
        this.write(JsonUtil.toJson(MapUtil.builder().put((Object)"type", (Object)"end").build()));
        this.endFlag.set(true);
        return true;
    }

    private WebSocketListener createWebSocketListener() {
        return new WebSocketListener(){

            public void onClosed(WebSocket webSocket, int code, String reason) {
                super.onClosed(webSocket, code, reason);
                ReportService.ifLogMessage(SpeechWsRecognizer.this.getId(), "ws onClosed" + reason, false);
                SpeechWsRecognizer.this.isConnect = false;
            }

            public void onClosing(WebSocket webSocket, int code, String reason) {
                super.onClosing(webSocket, code, reason);
                ReportService.ifLogMessage(SpeechWsRecognizer.this.getId(), "ws onClosing", false);
                SpeechWsRecognizer.this.isConnect = false;
            }

            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                super.onFailure(webSocket, t, response);
                SpeechWsRecognizer.this.isConnect = false;
                if (t.getMessage() != null && !t.getMessage().equals("Socket closed")) {
                    ReportService.ifLogMessage(SpeechWsRecognizer.this.getId(), "onFailure:reconnect," + t.getMessage() + t.getLocalizedMessage(), true);
                    SpeechWsRecognizer.this.reconnect(new byte[0]);
                    return;
                }
                if (response != null) {
                    ReportService.ifLogMessage(SpeechWsRecognizer.this.getId(), "onFailure:" + response.message() + "_" + t.getMessage(), false);
                    SpeechRecognitionResponse rs = new SpeechRecognitionResponse();
                    rs.setCode(AsrConstant.Code.EXCEPTION.getCode());
                    rs.setMessage(response.message());
                    rs.setStreamId(SpeechWsRecognizer.this.asrRequestContent.getStreamId());
                    rs.setVoiceId(SpeechWsRecognizer.this.asrRequestContent.getVoiceId());
                    ReportService.ifLogMessage(SpeechWsRecognizer.this.getId(), "onFailure", false);
                    ReportService.report(false, String.valueOf(rs.getCode()), SpeechWsRecognizer.this.asrConfig, SpeechWsRecognizer.this.getId(), SpeechWsRecognizer.this.asrRequest, rs, SpeechWsRecognizer.this.asrConfig.getWsUrl(), t.getMessage());
                    SpeechWsRecognizer.this.listener.onFail(rs);
                }
            }

            public void onMessage(WebSocket webSocket, String text) {
                super.onMessage(webSocket, text);
                ReportService.ifLogMessage(SpeechWsRecognizer.this.getId(), "onMessage:" + text, false);
                SpeechRecognitionResponse response = JsonUtil.fromJson(text, SpeechRecognitionResponse.class);
                if (SpeechWsRecognizer.this.listener != null) {
                    if (response.getCode() == 0) {
                        SpeechWsRecognizer.this.resultCallBack(response);
                        ReportService.report(true, String.valueOf(response.getCode()), SpeechWsRecognizer.this.asrConfig, SpeechWsRecognizer.this.getId(), SpeechWsRecognizer.this.asrRequest, response, SpeechWsRecognizer.this.asrConfig.getWsUrl(), response.getMessage());
                    } else {
                        ReportService.report(false, String.valueOf(response.getCode()), SpeechWsRecognizer.this.asrConfig, SpeechWsRecognizer.this.getId(), SpeechWsRecognizer.this.asrRequest, response, SpeechWsRecognizer.this.asrConfig.getWsUrl(), response.getMessage());
                        response.setStreamId(SpeechWsRecognizer.this.asrRequestContent.getStreamId());
                        response.setVoiceId(SpeechWsRecognizer.this.asrRequestContent.getVoiceId());
                        SpeechWsRecognizer.this.endFlag.set(true);
                        ReportService.report(false, String.valueOf(response.getCode()), SpeechWsRecognizer.this.asrConfig, SpeechWsRecognizer.this.getId(), SpeechWsRecognizer.this.asrRequest, response, SpeechWsRecognizer.this.asrConfig.getWsUrl(), response.getMessage());
                        SpeechWsRecognizer.this.listener.onFail(response);
                    }
                }
            }

            public void onMessage(WebSocket webSocket, ByteString bytes) {
                super.onMessage(webSocket, bytes);
            }

            public void onOpen(WebSocket webSocket, Response response) {
                super.onOpen(webSocket, response);
                ReportService.ifLogMessage(SpeechWsRecognizer.this.getId(), "onOpen:" + JsonUtil.toJson(response), false);
                boolean bl = SpeechWsRecognizer.this.isConnect = response.code() == 101;
                if (!SpeechWsRecognizer.this.isConnect) {
                    ReportService.ifLogMessage(SpeechWsRecognizer.this.getId(), "onOpen: fail", false);
                    webSocket.close(1001, "onOpen");
                }
            }
        };
    }

    private void resultCallBack(SpeechRecognitionResponse response) {
        response.setStreamId(this.asrRequestContent.getStreamId());
        if (response.getFinalSpeech() == null) {
            response.setFinalSpeech(0);
        }
        if (response.getResult() != null) {
            if (response.getResult().getSliceType() == 0) {
                this.begin = true;
                this.listener.onSentenceBegin(response);
            } else if (response.getResult().getSliceType() == 2) {
                if (!this.begin) {
                    SpeechRecognitionResponse beginResp = JsonUtil.fromJson(JsonUtil.toJson(response), SpeechRecognitionResponse.class);
                    beginResp.getResult().setSliceType(0);
                    this.listener.onSentenceBegin(beginResp);
                }
                this.begin = false;
                this.listener.onSentenceEnd(response);
            } else {
                this.listener.onRecognitionResultChange(response);
            }
        }
        if (response.getFinalSpeech() != null && response.getFinalSpeech() == 1 && this.listener != null) {
            SpeechRecognitionResponse recognizerResponse = new SpeechRecognitionResponse();
            recognizerResponse.setCode(0);
            recognizerResponse.setVoiceId(this.asrRequestContent.getVoiceId());
            recognizerResponse.setFinalSpeech(1);
            recognizerResponse.setStreamId(this.asrRequestContent.getStreamId());
            recognizerResponse.setMessage("success");
            recognizerResponse.setMessageId(response.getMessageId());
            this.listener.onRecognitionComplete(recognizerResponse);
        }
    }

    private String getId() {
        return this.asrRequestContent.getStreamId() + "_" + this.asrRequestContent.getVoiceId();
    }

    private void reconnect(byte[] data) {
        if (this.endFlag.get()) {
            return;
        }
        if (this.connectNum <= this.reConnectMaxNum) {
            try {
                Thread.sleep(10L);
                this.write(data);
                ++this.connectNum;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createWebsocket() {
        if (!this.isConnect || this.webSocket == null) {
            try {
                this.lock.lock();
                if (!this.isConnect || this.webSocket == null) {
                    ReportService.ifLogMessage(this.getId(), "create websocket", false);
                    this.asrRequest.setTimestamp(System.currentTimeMillis() / 1000L);
                    this.asrRequest.setExpired(System.currentTimeMillis() / 1000L + 86400L);
                    String url = this.speechRecognitionSignService.signWsUrl(this.asrConfig, this.asrRequest, this.asrRequestContent);
                    String sign = SignBuilder.createGetSign(url, this.asrConfig.getSecretKey(), this.asrRequest);
                    WebSocketListener webSocketListener = this.createWebSocketListener();
                    this.webSocket = WsClientService.asrWebSocket(url, sign, webSocketListener);
                    this.isConnect = true;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

