/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tts.service;

import cn.hutool.core.util.RandomUtil;
import com.google.gson.JsonParser;
import com.tencent.core.service.ReportService;
import com.tencent.core.utils.ByteUtils;
import com.tencent.core.utils.JsonUtil;
import com.tencent.core.utils.SignBuilder;
import com.tencent.tts.model.SpeechSynthesisConfig;
import com.tencent.tts.model.SpeechSynthesisRequest;
import com.tencent.tts.model.SpeechSynthesisRequestContent;
import com.tencent.tts.model.SpeechSynthesisResponse;
import com.tencent.tts.service.SpeechSynthesisListener;
import com.tencent.tts.service.SpeechSynthesisSignService;
import com.tencent.tts.utils.LineSplitUtils;
import com.tencent.tts.utils.Ttsutils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.HttpClients;

public class SpeechSynthesizer {
    private SpeechSynthesisConfig speechSynthesisConfig;
    private SpeechSynthesisRequest speechSynthesisRequest;
    private SpeechSynthesisListener eventListener;
    private SpeechSynthesisSignService speechSynthesisSignService = new SpeechSynthesisSignService();
    private String sessionParentId;
    private AtomicInteger index;
    private long time;

    public SpeechSynthesizer(SpeechSynthesisConfig speechSynthesisConfig, SpeechSynthesisRequest speechSynthesisRequest, SpeechSynthesisListener eventListener) {
        this.speechSynthesisConfig = speechSynthesisConfig;
        this.speechSynthesisRequest = speechSynthesisRequest;
        this.eventListener = eventListener;
        this.sessionParentId = speechSynthesisConfig.getAppId() + "_tts_" + System.currentTimeMillis() + RandomUtil.randomString((int)4);
        this.index = new AtomicInteger(0);
    }

    public SpeechSynthesizer synthesis(String texts) {
        if (StringUtils.isEmpty((CharSequence)texts)) {
            ReportService.ifLogMessage(this.sessionParentId, "text is empty", false);
            return this;
        }
        SpeechSynthesisResponse response = null;
        byte[] audioData = new byte[]{};
        response = this.speechRequest(texts, this.index.intValue(), this.sessionParentId);
        if (response != null && response.getSuccess().booleanValue() && response.getAudio() != null && response.getAudio().length > 0) {
            audioData = ByteUtils.concat(audioData, response.getAudio());
        }
        response.setSeq(-1);
        response.setEnd(true);
        response.setAudio(audioData);
        if (response.getSuccess().booleanValue()) {
            this.eventListener.onComplete(response);
        } else {
            this.eventListener.onFail(response);
        }
        this.index.incrementAndGet();
        return this;
    }

    public SpeechSynthesizer synthesisLongText(String texts) {
        if (StringUtils.isEmpty((CharSequence)texts)) {
            ReportService.ifLogMessage(this.sessionParentId, "text is empty", false);
            return this;
        }
        SpeechSynthesisResponse response = null;
        byte[] audioData = new byte[]{};
        List<String> longTexts = LineSplitUtils.smartSplit(texts);
        for (String text : longTexts) {
            response = this.speechRequest(text, this.index.intValue(), this.sessionParentId);
            if (response == null || !response.getSuccess().booleanValue() || response.getAudio() == null || response.getAudio().length <= 0) continue;
            audioData = ByteUtils.concat(audioData, response.getAudio());
        }
        response.setEnd(true);
        response.setAudio(audioData);
        if (response.getSuccess().booleanValue()) {
            this.eventListener.onComplete(response);
        } else {
            this.eventListener.onFail(response);
        }
        this.index.incrementAndGet();
        return this;
    }

    private SpeechSynthesisResponse speechRequest(String text, Integer seq, String sessionParentId) {
        SpeechSynthesisResponse response = this.request(text, seq, sessionParentId);
        if (!response.getSuccess().booleanValue() && "-1".equals(response.getCode())) {
            int retryNum = 2;
            for (int i = 0; i < retryNum; ++i) {
                response = this.request(text, seq, sessionParentId);
                if (response.getSuccess().booleanValue()) {
                    ReportService.ifLogMessage(response.getSessionId(), "retry success:" + i, false);
                    break;
                }
                ReportService.ifLogMessage(response.getSessionId(), "retry fail:" + i, false);
            }
        }
        if (!response.getSuccess().booleanValue()) {
            ReportService.filterRepeatError(this.speechSynthesisConfig, sessionParentId, this.speechSynthesisRequest, response, this.speechSynthesisConfig.getTtsUrl(), response.getMessage());
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private SpeechSynthesisResponse request(String text, Integer seq, String sessionParentId) {
        block31: {
            block29: {
                sessionId = sessionParentId + "_" + seq;
                synthesizerResponse = new SpeechSynthesisResponse();
                synthesizerResponse.setSeq(seq);
                synthesizerResponse.setSessionId(sessionId);
                synthesizerResponse.setEnd(false);
                content = SpeechSynthesisRequestContent.builder().text(text).sessionId(sessionId).build();
                this.speechSynthesisRequest.setTimestamp(System.currentTimeMillis() / 1000L);
                this.speechSynthesisRequest.setExpired(this.speechSynthesisRequest.getTimestamp() + 86400L);
                map = SpeechSynthesisSignService.getParams(this.speechSynthesisConfig, this.speechSynthesisRequest, content);
                url = this.speechSynthesisSignService.signUrl(this.speechSynthesisConfig, this.speechSynthesisRequest, content, map);
                sign = SignBuilder.createPostSign(url, this.speechSynthesisConfig.getSecretKey(), this.speechSynthesisRequest);
                httpclient = HttpClients.createDefault();
                httpPost = new HttpPost(this.speechSynthesisConfig.getTtsUrl());
                httpPost.addHeader("Authorization", sign);
                httpPost.addHeader("Content-Type", "application/json");
                httpEntity = new ByteArrayEntity(JsonUtil.toJson(map).getBytes(Charset.forName("utf-8")));
                httpPost.setEntity((HttpEntity)httpEntity);
                ReportService.ifLogMessage("tt request:", url, false);
                this.time = System.currentTimeMillis();
                response = httpclient.execute((HttpUriRequest)httpPost);
                synthesizerResponse.setCode(String.valueOf(response.getStatusLine().getStatusCode()));
                if ("200".equals(synthesizerResponse.getCode())) break block29;
                ReportService.ifLogMessage(sessionId, response.getStatusLine().toString(), true);
                synthesizerResponse.setSuccess(false);
                var14_18 = synthesizerResponse;
                response.close();
                return var14_18;
            }
            if (!response.getEntity().getContentType().getValue().contains("text/plain") || response.getEntity().isChunked()) ** break block30
            synthesizerResponse.setSuccess(false);
            try {
                inputStream = response.getEntity().getContent();
                data = new byte[]{};
                resp = ByteUtils.subToSmallBytes(inputStream, 500);
                for (byte[] item : resp) {
                    data = ByteUtils.concat(data, item);
                }
                result = new String(data, "utf-8");
                ReportService.ifLogMessage(sessionId, result, true);
                jsonObject = new JsonParser().parse(result).getAsJsonObject();
                synthesizerResponse.setMessage(jsonObject.getAsJsonObject("Response").getAsJsonObject("Error").getAsJsonPrimitive("Message").getAsString());
                synthesizerResponse.setCode(jsonObject.getAsJsonObject("Response").getAsJsonObject("Error").getAsJsonPrimitive("Code").getAsString());
                synthesizerResponse.setRequestId(jsonObject.getAsJsonObject("Response").getAsJsonPrimitive("RequestId").getAsString());
            }
            catch (Exception e) {
                ReportService.ifLogMessage("request error:", e.getMessage(), true);
            }
            e = synthesizerResponse;
            response.close();
            return e;
            {
                inputStream = response.getEntity().getContent();
                synthesizerResponse.setAudio(this.read(inputStream, response));
                synthesizerResponse.setMessage("success");
                synthesizerResponse.setSuccess(true);
                var15_25 = synthesizerResponse;
                response.close();
            }
            return var15_25;
            {
                catch (Throwable var19_30) {
                    try {
                        response.close();
                        throw var19_30;
                    }
                    catch (ClientProtocolException e) {
                        synthesizerResponse.setSuccess(false);
                        synthesizerResponse.setCode("-1");
                        synthesizerResponse.setMessage("ClientProtocolException:" + e.getMessage());
                        break block31;
                    }
                    catch (IOException exception) {
                        synthesizerResponse.setSuccess(false);
                        synthesizerResponse.setCode("-1");
                        synthesizerResponse.setMessage("IOException:" + exception.getMessage());
                        break block31;
                    }
                }
            }
            finally {
                try {
                    httpclient.close();
                }
                catch (IOException var11_15) {}
            }
        }
        return synthesizerResponse;
    }

    public byte[] read(InputStream inputStream, CloseableHttpResponse response) {
        return this.readStream(inputStream, response);
    }

    public byte[] readStream(InputStream inputStream, CloseableHttpResponse response) {
        byte[] responseDatas = new byte[]{};
        AtomicInteger adder = new AtomicInteger(0);
        while (true) {
            block6: {
                byte[] pcmData = new byte[10240];
                try {
                    int readSize = Ttsutils.fill(inputStream, pcmData);
                    if (readSize == 0) break;
                    if (readSize < pcmData.length) {
                        pcmData = ByteUtils.subBytes(pcmData, 0, readSize);
                    }
                    responseDatas = ByteUtils.concat(responseDatas, pcmData);
                    ReportService.ifLogMessage("execution time", "[" + (System.currentTimeMillis() - this.time) + "ms]", false);
                    if (this.eventListener != null) {
                        this.eventListener.onMessage(pcmData);
                    }
                    if (this.eventListener.ifCancel()) {
                        response.close();
                        this.eventListener.setIfCancel(true);
                        break;
                    }
                }
                catch (IOException e) {
                    SpeechSynthesisResponse synthesizerResponse = new SpeechSynthesisResponse();
                    synthesizerResponse.setSeq(this.index.get());
                    synthesizerResponse.setSessionId(this.sessionParentId + "_" + this.index.get() + "_" + adder.get());
                    synthesizerResponse.setEnd(false);
                    synthesizerResponse.setSuccess(false);
                    synthesizerResponse.setCode("-1");
                    synthesizerResponse.setMessage(e.getMessage());
                    if (this.eventListener == null) break block6;
                    this.eventListener.onFail(synthesizerResponse);
                }
            }
            adder.incrementAndGet();
        }
        return responseDatas;
    }

    protected static byte[] readChunkData(InputStream in) throws IOException {
        int currentRead;
        byte[] sum = new byte[]{};
        do {
            byte[] temp;
            if ((currentRead = in.read(temp = new byte[4096], 0, temp.length)) <= 0) continue;
            if (currentRead < temp.length) {
                temp = ByteUtils.subBytes(temp, 0, currentRead);
            }
            sum = ByteUtils.concat(sum, temp);
        } while (in.available() != 0 && currentRead != -1);
        return sum;
    }
}

