/*
 * Decompiled with CFR 0.152.
 */
package com.tencent;

import cn.hutool.core.util.RandomUtil;
import com.tencent.asr.constant.AsrConstant;
import com.tencent.asr.model.AsrConfig;
import com.tencent.asr.model.Credential;
import com.tencent.asr.model.SpeechRecognitionRequest;
import com.tencent.asr.model.SpeechRecognitionSysConfig;
import com.tencent.asr.model.SpeechWebsocketConfig;
import com.tencent.asr.model.VirtualNumberRequest;
import com.tencent.asr.model.VirtualNumberServerConfig;
import com.tencent.asr.service.FlashRecognizer;
import com.tencent.asr.service.SdkRunException;
import com.tencent.asr.service.SpeechHttpRecognizer;
import com.tencent.asr.service.SpeechRecognitionListener;
import com.tencent.asr.service.SpeechRecognizer;
import com.tencent.asr.service.SpeechWsRecognizer;
import com.tencent.asr.service.VirtualNumberRecognitionListener;
import com.tencent.asr.service.VirtualNumberRecognizer;
import com.tencent.asr.service.WsClientService;
import com.tencent.core.model.GlobalConfig;
import com.tencent.core.service.ReportService;
import com.tencent.core.service.StatService;
import com.tencent.tts.model.SpeechSynthesisConfig;
import com.tencent.tts.model.SpeechSynthesisRequest;
import com.tencent.tts.model.SpeechWsSynthesisRequest;
import com.tencent.tts.model.SpeechWsSynthesisServerConfig;
import com.tencent.tts.service.SpeechSynthesisListener;
import com.tencent.tts.service.SpeechSynthesizer;
import com.tencent.tts.service.SpeechWsSynthesisListener;
import com.tencent.tts.service.SpeechWsSynthesizer;
import net.jodah.expiringmap.internal.Assert;
import org.apache.commons.lang3.StringUtils;

public class SpeechClient {
    private static SpeechClient speechClient;
    private String appId;
    private String secretId;
    private String secretKey;
    private String token;
    private WsClientService wsClientService;

    private SpeechClient() {
    }

    public static SpeechClient newInstance(String appId, String secretId, String secretKey) {
        return SpeechClient.newInstance(appId, secretId, secretKey, null);
    }

    public static SpeechClient newInstance(String appId, String secretId, String secretKey, String token) {
        return SpeechClient.newInstance(appId, secretId, secretKey, token, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SpeechClient newInstance(String appId, String secretId, String secretKey, String token, SpeechWebsocketConfig config) {
        if (StringUtils.isEmpty((CharSequence)secretId)) {
            throw new SdkRunException(AsrConstant.Code.CODE_10009);
        }
        if (StringUtils.isEmpty((CharSequence)secretKey)) {
            throw new SdkRunException(AsrConstant.Code.CODE_10009);
        }
        if (speechClient != null) return speechClient;
        Class<SpeechClient> clazz = SpeechClient.class;
        synchronized (SpeechClient.class) {
            if (speechClient != null) return speechClient;
            speechClient = new SpeechClient();
            speechClient.setAppId(appId);
            speechClient.setSecretId(secretId);
            speechClient.setSecretKey(secretKey);
            speechClient.setToken(token);
            if (AsrConstant.RequestWay.Websocket.equals((Object)SpeechRecognitionSysConfig.requestWay)) {
                if (config == null) {
                    config = SpeechWebsocketConfig.init();
                }
                SpeechClient.speechClient.wsClientService = new WsClientService(config);
            }
            if (!GlobalConfig.ifOpenStat.booleanValue()) return speechClient;
            StatService.setConfig(secretId, secretKey, appId, token);
            StatService.startReportStat();
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return speechClient;
        }
    }

    public void setSpeechClientConfig(String appId, String secretId, String secretKey, String token) {
        if (speechClient != null) {
            speechClient.setAppId(appId);
            speechClient.setSecretId(secretId);
            speechClient.setSecretKey(secretKey);
            speechClient.setToken(token);
            if (GlobalConfig.ifOpenStat.booleanValue()) {
                StatService.setConfig(secretId, secretKey, appId, token);
            }
        }
    }

    public SpeechSynthesizer newSpeechSynthesizer(SpeechSynthesisRequest speechSynthesisRequest, SpeechSynthesisListener eventListener) {
        SpeechSynthesisConfig config = SpeechSynthesisConfig.builder().appId(Long.valueOf(this.appId)).secretId(this.secretId).secretKey(this.secretKey).token(this.token).build();
        return new SpeechSynthesizer(config, speechSynthesisRequest, eventListener);
    }

    public SpeechRecognizer newSpeechRecognizer(SpeechRecognitionRequest request, SpeechRecognitionListener speechRecognitionListener) {
        AsrConfig config = AsrConfig.builder().appId(this.appId).secretId(this.secretId).secretKey(this.secretKey).token(this.token).build();
        if (request.getEngineModelType() == null) {
            throw new RuntimeException("engineModelType can not be null,please set SpeechRecognitionRequest EngineModelType !!");
        }
        if (AsrConstant.RequestWay.Http.equals((Object)SpeechRecognitionSysConfig.requestWay)) {
            return new SpeechHttpRecognizer(RandomUtil.randomString((int)8), config, request, speechRecognitionListener);
        }
        return this.newWsSpeechRecognizer(request, speechRecognitionListener);
    }

    public SpeechRecognizer newWsSpeechRecognizer(SpeechRecognitionRequest request, SpeechRecognitionListener speechRecognitionListener) {
        AsrConfig config = AsrConfig.builder().appId(this.appId).secretId(this.secretId).secretKey(this.secretKey).token(this.token).build();
        if (request.getEngineModelType() == null) {
            throw new RuntimeException("engineModelType can not be null,please set SpeechRecognitionRequest EngineModelType !!");
        }
        return new SpeechWsRecognizer(this.wsClientService, RandomUtil.randomString((int)8), config, request, speechRecognitionListener);
    }

    public static SpeechRecognizer newSpeechWsRecognizer(Credential credential, WsClientService clientService, SpeechRecognitionRequest request, SpeechRecognitionListener speechRecognitionListener) {
        AsrConfig config = AsrConfig.builder().appId(credential.getAppid()).secretId(credential.getSecretId()).secretKey(credential.getSecretKey()).token(credential.getToken()).build();
        if (request.getEngineModelType() == null) {
            throw new RuntimeException("engineModelType can not be null,please set SpeechRecognitionRequest EngineModelType !!");
        }
        return new SpeechWsRecognizer(clientService, RandomUtil.randomString((int)8), config, request, speechRecognitionListener);
    }

    public static FlashRecognizer newFlashRecognizer(String appId, Credential credential) {
        AsrConfig config = AsrConfig.builder().appId(appId).secretId(credential.getSecretId()).secretKey(credential.getSecretKey()).token(credential.getToken()).build();
        return new FlashRecognizer(config);
    }

    public static FlashRecognizer newFlashRecognizer(AsrConfig config) {
        Assert.notNull((Object)config, (String)"AsrConfig");
        return new FlashRecognizer(config);
    }

    public static VirtualNumberRecognizer newVirtualNumberRecognizer(VirtualNumberRequest request, VirtualNumberRecognitionListener listener) {
        return SpeechClient.newVirtualNumberRecognizer(VirtualNumberServerConfig.InitVirtualNumberServerConfig(), request, listener);
    }

    public static VirtualNumberRecognizer newVirtualNumberRecognizer(VirtualNumberServerConfig config, VirtualNumberRequest request, VirtualNumberRecognitionListener listener) {
        if (config == null || request == null || listener == null) {
            ReportService.ifLogMessage("", "Please check config or request or listener,maybe null ", false);
            throw new SdkRunException(AsrConstant.Code.CODE_10010);
        }
        if (request.getAppId() == null || request.getSecretId() == null || request.getSecretKey() == null) {
            ReportService.ifLogMessage("", "Please check appid or secretid or secretkey,maybe null ", false);
            throw new SdkRunException(AsrConstant.Code.CODE_10010);
        }
        return new VirtualNumberRecognizer(config, request, listener);
    }

    private static SpeechWsSynthesizer newSpeechWsSynthesizer(SpeechWsSynthesisRequest request, SpeechWsSynthesisListener listener) {
        return SpeechClient.newSpeechWsSynthesizer(SpeechWsSynthesisServerConfig.initSpeechWsSynthesisServerConfig(), request, listener);
    }

    public static SpeechWsSynthesizer newSpeechWsSynthesizer(SpeechWsSynthesisServerConfig config, SpeechWsSynthesisRequest request, SpeechWsSynthesisListener listener) {
        if (config == null || request == null || listener == null) {
            ReportService.ifLogMessage("", "Please check config or request or listener,maybe null ", false);
            throw new SdkRunException(AsrConstant.Code.CODE_10010);
        }
        if (config.getClient() == null) {
            throw new SdkRunException(AsrConstant.Code.CODE_10010);
        }
        if (request.getAppId() == null || request.getSecretId() == null || request.getSecretKey() == null) {
            ReportService.ifLogMessage("", "Please check appid or secretid or secretkey,maybe null ", false);
            throw new SdkRunException(AsrConstant.Code.CODE_10010);
        }
        return new SpeechWsSynthesizer(config, request, listener);
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setSecretId(String secretId) {
        this.secretId = secretId;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setWsClientService(WsClientService wsClientService) {
        this.wsClientService = wsClientService;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getSecretId() {
        return this.secretId;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getToken() {
        return this.token;
    }

    public WsClientService getWsClientService() {
        return this.wsClientService;
    }
}

