/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.asr.service;

import cn.hutool.core.lang.Assert;
import com.tencent.asr.constant.AsrConstant;
import com.tencent.asr.model.AsrConfig;
import com.tencent.asr.model.AsrRequest;
import com.tencent.asr.model.AsrResponse;
import com.tencent.asr.service.HttpStreamService;
import com.tencent.asr.service.SpeechHttpRecognizer;
import com.tencent.core.handler.BaseEventListener;
import com.tencent.core.handler.RealTimeEventListener;
import com.tencent.core.model.GlobalConfig;
import com.tencent.core.service.ReportService;
import com.tencent.core.service.StatService;
import com.tencent.core.service.TCall;
import com.tencent.core.service.TClient;
import com.tencent.core.utils.Tutils;
import java.util.concurrent.ThreadPoolExecutor;

public class AsrClient
implements TClient {
    private AsrConfig asrConfig;
    private ThreadPoolExecutor executor;

    public AsrClient(AsrConfig config, ThreadPoolExecutor executorService) {
        this.checkConfig(config);
        this.asrConfig = config;
        this.executor = executorService;
    }

    public static AsrClient newInstance(AsrConfig config) {
        return new AsrClient(config, null);
    }

    public static AsrClient newInstance(AsrConfig config, ThreadPoolExecutor executorService) {
        return new AsrClient(config, executorService);
    }

    @Override
    public void start() {
        if (GlobalConfig.ifOpenStat.booleanValue()) {
            StatService.setConfig(this.asrConfig.getSecretId(), this.asrConfig.getSecretKey(), String.valueOf(this.asrConfig.getAppId()), null);
            StatService.startReportStat();
        }
    }

    @Override
    public void close() {
        Tutils.closeThreadPool(this.executor);
        ReportService.ifLogMessage("close", "Close the request thread pool", false);
    }

    public TCall newCall(String streamId, AsrRequest request, BaseEventListener<AsrResponse> baseEventListener, RealTimeEventListener realTimeEventListener, AsrConstant.DataType type) {
        if (AsrConstant.DataType.BYTE.equals((Object)type)) {
            SpeechHttpRecognizer speechRecognizer = new SpeechHttpRecognizer(streamId, this.asrConfig, request, realTimeEventListener, baseEventListener);
            speechRecognizer.start();
            return speechRecognizer;
        }
        HttpStreamService call = new HttpStreamService(streamId, this.asrConfig, request, realTimeEventListener, this.executor, baseEventListener);
        call.start();
        return call;
    }

    public TCall newCall(String streamId, AsrRequest request, RealTimeEventListener realTimeEventListener, AsrConstant.DataType type) {
        return this.newCall(streamId, request, null, realTimeEventListener, type);
    }

    private void checkConfig(AsrConfig asrConfig) {
        Assert.isFalse((asrConfig == null ? 1 : 0) != 0, (String)"asrConfig Cannot be empty", (Object[])new Object[0]);
        Assert.isFalse((asrConfig.getAppId() == null ? 1 : 0) != 0, (String)"appId Cannot be empty", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)asrConfig.getSecretKey(), (String)"secretKey Cannot be empty", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)asrConfig.getSecretId(), (String)"secretId Cannot be empty", (Object[])new Object[0]);
    }
}

