/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.core.ws;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateMachine {
    private static Logger logger = LoggerFactory.getLogger(StateMachine.class);
    protected State state = State.STATE_INIT;

    public State getState() {
        return this.state;
    }

    public static enum State {
        STATE_FAIL(-1){

            @Override
            public void checkStart() {
                throw new RuntimeException("can't start,current state is " + (Object)((Object)this));
            }

            @Override
            public void checkSend() {
                throw new RuntimeException("can't send,current state is " + (Object)((Object)this));
            }

            @Override
            public void checkStop() {
                throw new RuntimeException("can't stop,current state is " + (Object)((Object)this));
            }

            @Override
            public State init() {
                return this;
            }

            @Override
            public State start() {
                return this;
            }

            @Override
            public State fail() {
                return this;
            }

            @Override
            public State complete() {
                return this;
            }

            @Override
            public State closed() {
                return this;
            }

            @Override
            public State send() {
                return this;
            }

            @Override
            public State stopSend() {
                return this;
            }
        }
        ,
        STATE_INIT(0){

            @Override
            public void checkStart() {
            }

            @Override
            public void checkSend() {
                throw new RuntimeException("can't send,current state is " + (Object)((Object)this));
            }

            @Override
            public void checkStop() {
                throw new RuntimeException("can't stop,current state is " + (Object)((Object)this));
            }

            @Override
            public State init() {
                return this;
            }

            @Override
            public State start() {
                return STATE_START;
            }

            @Override
            public State fail() {
                return this;
            }

            @Override
            public State complete() {
                return this;
            }

            @Override
            public State closed() {
                return this;
            }

            @Override
            public State send() {
                return this;
            }

            @Override
            public State stopSend() {
                return this;
            }
        }
        ,
        STATE_START(1){

            @Override
            public void checkSend() {
            }

            @Override
            public void checkStart() {
                throw new RuntimeException("can't start,current state is " + (Object)((Object)this));
            }

            @Override
            public void checkStop() {
                throw new RuntimeException("can't stop,current state is " + (Object)((Object)this));
            }

            @Override
            public State init() {
                return this;
            }

            @Override
            public State start() {
                return this;
            }

            @Override
            public State fail() {
                return STATE_FAIL;
            }

            @Override
            public State complete() {
                return STATE_COMPLETE;
            }

            @Override
            public State closed() {
                return STATE_CLOSED;
            }

            @Override
            public State send() {
                return STATE_SEND;
            }

            @Override
            public State stopSend() {
                return STATE_STOP_SENT;
            }
        }
        ,
        STATE_SEND(2){

            @Override
            public void checkSend() {
            }

            @Override
            public void checkStart() {
                throw new RuntimeException("can't start,current state is " + (Object)((Object)this));
            }

            @Override
            public void checkStop() {
            }

            @Override
            public State init() {
                return this;
            }

            @Override
            public State start() {
                return this;
            }

            @Override
            public State fail() {
                return STATE_FAIL;
            }

            @Override
            public State complete() {
                return STATE_COMPLETE;
            }

            @Override
            public State closed() {
                return STATE_CLOSED;
            }

            @Override
            public State send() {
                return this;
            }

            @Override
            public State stopSend() {
                return STATE_STOP_SENT;
            }
        }
        ,
        STATE_STOP_SENT(3){

            @Override
            public void checkSend() {
                throw new RuntimeException("only STATE_REQUEST_CONFIRMED can send,current state is " + (Object)((Object)this));
            }

            @Override
            public void checkStart() {
                throw new RuntimeException("can't start,current state is " + (Object)((Object)this));
            }

            @Override
            public void checkStop() {
            }

            @Override
            public State init() {
                return this;
            }

            @Override
            public State start() {
                return this;
            }

            @Override
            public State fail() {
                return STATE_FAIL;
            }

            @Override
            public State complete() {
                return STATE_COMPLETE;
            }

            @Override
            public State closed() {
                return STATE_CLOSED;
            }

            @Override
            public State send() {
                return this;
            }

            @Override
            public State stopSend() {
                return STATE_STOP_SENT;
            }
        }
        ,
        STATE_COMPLETE(4){

            @Override
            public void checkSend() {
                logger.warn("task is completed before sending binary");
            }

            @Override
            public void checkStart() {
            }

            @Override
            public void checkStop() {
                logger.warn("task is completed before sending stop command");
            }

            @Override
            public State init() {
                return this;
            }

            @Override
            public State start() {
                return this;
            }

            @Override
            public State fail() {
                return STATE_FAIL;
            }

            @Override
            public State complete() {
                return this;
            }

            @Override
            public State closed() {
                return STATE_CLOSED;
            }

            @Override
            public State send() {
                return this;
            }

            @Override
            public State stopSend() {
                return this;
            }
        }
        ,
        STATE_CLOSED(6){

            @Override
            public void checkSend() {
                throw new RuntimeException("can't send,current state is " + (Object)((Object)this));
            }

            @Override
            public void checkStart() {
                throw new RuntimeException("can't start,current state is " + (Object)((Object)this));
            }

            @Override
            public void checkStop() {
                throw new RuntimeException("can't stop,current state is " + (Object)((Object)this));
            }

            @Override
            public State init() {
                return this;
            }

            @Override
            public State start() {
                return this;
            }

            @Override
            public State fail() {
                return this;
            }

            @Override
            public State complete() {
                return this;
            }

            @Override
            public State closed() {
                return this;
            }

            @Override
            public State send() {
                return this;
            }

            @Override
            public State stopSend() {
                return this;
            }
        };

        int value;

        public abstract void checkSend();

        public abstract void checkStart();

        public abstract void checkStop();

        public abstract State init();

        public abstract State start();

        public abstract State fail();

        public abstract State complete();

        public abstract State closed();

        public abstract State send();

        public abstract State stopSend();

        private State(int value) {
            this.value = value;
        }
    }
}

