/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ttsv2;

import com.google.gson.Gson;
import com.tencent.core.help.SignHelper;
import com.tencent.core.utils.SignBuilder;
import com.tencent.core.ws.Connection;
import com.tencent.core.ws.ConnectionProfile;
import com.tencent.core.ws.Credential;
import com.tencent.core.ws.SpeechClient;
import com.tencent.core.ws.StateMachine;
import com.tencent.ttsv2.FlowingSpeechSynthesizerListener;
import com.tencent.ttsv2.FlowingSpeechSynthesizerRequest;
import com.tencent.ttsv2.TtsConstant;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowingSpeechSynthesizer
extends StateMachine {
    static Logger logger = LoggerFactory.getLogger(FlowingSpeechSynthesizer.class);
    private final Map<String, Object> ctx = new HashMap<String, Object>();
    private final String sessionId = UUID.randomUUID().toString();
    private final CountDownLatch stopLatch;
    private final CountDownLatch startLatch;
    protected long lastSendTime = -1L;
    protected Connection conn;
    private Credential credential;
    private FlowingSpeechSynthesizerRequest request;
    private SpeechClient client;
    private FlowingSpeechSynthesizerListener listener;

    public Credential getCredential() {
        return this.credential;
    }

    public void setCredential(Credential credential) {
        this.credential = credential;
    }

    public FlowingSpeechSynthesizerRequest getRequest() {
        return this.request;
    }

    public void setRequest(FlowingSpeechSynthesizerRequest request) {
        this.request = request;
    }

    public SpeechClient getClient() {
        return this.client;
    }

    public void setClient(SpeechClient client) {
        this.client = client;
    }

    public FlowingSpeechSynthesizerListener getListener() {
        return this.listener;
    }

    public void setListener(FlowingSpeechSynthesizerListener listener) {
        this.listener = listener;
    }

    public FlowingSpeechSynthesizer(SpeechClient client, Credential credential, FlowingSpeechSynthesizerRequest request, FlowingSpeechSynthesizerListener listener) throws Exception {
        Optional.ofNullable(client).orElseThrow(() -> new RuntimeException("client cannot be null"));
        Optional.ofNullable(request).orElseThrow(() -> new RuntimeException("request cannot be null"));
        Optional.ofNullable(credential).orElseThrow(() -> new RuntimeException("credential cannot be null"));
        Optional.ofNullable(listener).orElseThrow(() -> new RuntimeException("listener cannot be null"));
        if (request.getSessionId() == null) {
            request.setSessionId(this.sessionId);
        }
        request.setAction("TextToStreamAudioWSv2");
        request.setAppId(Integer.valueOf(credential.getAppid()));
        this.request = request;
        this.credential = credential;
        this.client = client;
        this.listener = listener;
        this.stopLatch = new CountDownLatch(1);
        this.startLatch = new CountDownLatch(1);
        listener.setSpeechSynthesizer(this);
    }

    public void start() throws Exception {
        this.start(TtsConstant.DEFAULT_START_TIMEOUT_MILLISECONDS);
    }

    public void start(long milliSeconds) throws Exception {
        this.state.checkStart();
        logger.debug("sessionId:{},start change state from {} ", (Object)this.sessionId, (Object)this.state);
        this.state = this.state.start();
        logger.debug("sessionId:{},start change state to {} ", (Object)this.sessionId, (Object)this.state);
        this.request.setSecretid(this.credential.getSecretId());
        this.request.setTimestamp(System.currentTimeMillis() / 1000L);
        this.request.setExpired(System.currentTimeMillis() / 1000L + 86400L);
        Map<String, Object> sortParamMap = this.request.toTreeMap();
        String signUrl = TtsConstant.DEFAULT_TTS_V2_SIGN_PREFIX + SignHelper.createUrl(sortParamMap);
        logger.debug(signUrl);
        String sign = SignBuilder.base64_hmac_sha1(signUrl, this.credential.getSecretKey());
        String serverUrl = SignHelper.createUrl(SignHelper.encode(sortParamMap));
        String url = TtsConstant.DEFAULT_TTS_V2_REQ_URL + serverUrl + "&Signature=" + URLEncoder.encode(sign, "UTF-8");
        logger.debug(url);
        ConnectionProfile connectionProfile = new ConnectionProfile(sign, url, TtsConstant.DEFAULT_HOST, this.credential.getToken());
        this.conn = this.client.connect(connectionProfile, this.listener);
        HashMap<String, Long> network = new HashMap<String, Long>();
        network.put("connectingLatency", this.conn.getConnectingLatency());
        network.put("handshakeLatency", this.conn.getHandshakeLatency());
        this.ctx.put("network", network);
        boolean result = this.startLatch.await(milliSeconds, TimeUnit.MILLISECONDS);
        if (!result) {
            String msg = String.format("timeout after %d ms waiting for start confirmation.sessionId:%s,state:%s", new Object[]{milliSeconds, this.sessionId, this.state});
            logger.error(msg);
            throw new Exception(msg);
        }
    }

    public void process(String text) {
        long sendInterval;
        if (this.state == StateMachine.State.STATE_COMPLETE) {
            logger.info("state is {} stop send", (Object)StateMachine.State.STATE_COMPLETE);
            return;
        }
        if (this.lastSendTime != -1L && (sendInterval = System.currentTimeMillis() - this.lastSendTime) > 5000L) {
            logger.warn("too large binary send interval: {} million second", (Object)sendInterval);
        }
        this.state.checkSend();
        try {
            String message = this.newWsRequestMessage(text, TtsConstant.getFlowingSpeechSynthesizer_ACTION_SYNTHESIS());
            this.conn.sendText(message);
            this.lastSendTime = System.currentTimeMillis();
        }
        catch (Exception e) {
            logger.error("fail to send binary,current_task_id:{},state:{}", new Object[]{this.sessionId, this.state, e});
            throw new RuntimeException(e);
        }
    }

    public void reset() {
        if (this.state == StateMachine.State.STATE_COMPLETE) {
            logger.info("state is {} stop send", (Object)StateMachine.State.STATE_COMPLETE);
            return;
        }
        this.state.checkSend();
        try {
            String message = this.newWsRequestMessage("", TtsConstant.getFlowingSpeechSynthesizer_ACTION_RESET());
            this.conn.sendText(message);
            this.lastSendTime = System.currentTimeMillis();
        }
        catch (Exception e) {
            logger.error("fail to reset ,current_task_id:{},state:{}", new Object[]{this.sessionId, this.state, e});
            throw new RuntimeException(e);
        }
    }

    private String newWsRequestMessage(String text, String action) {
        HashMap<String, String> message = new HashMap<String, String>();
        message.put("session_id", this.request.getSessionId());
        message.put("message_id", UUID.randomUUID().toString());
        message.put("data", text);
        message.put("action", action);
        return new Gson().toJson(message);
    }

    public void stop() throws Exception {
        this.stop(TtsConstant.DEFAULT_TTS_FLOWING_STOP_TIMEOUT_MILLISECONDS);
    }

    public void stop(long milliSeconds) throws Exception {
        if (this.state == StateMachine.State.STATE_COMPLETE) {
            logger.info("state is {} stop message is discarded", (Object)StateMachine.State.STATE_COMPLETE);
            return;
        }
        this.state.checkStop();
        this.state = this.state.stopSend();
        if (this.conn != null) {
            String end = this.newWsRequestMessage("", TtsConstant.getFlowingSpeechSynthesizer_ACTION_COMPLETE());
            logger.debug(end);
            this.conn.sendText(end);
            if (milliSeconds > 0L) {
                boolean result = this.stopLatch.await(milliSeconds, TimeUnit.MILLISECONDS);
                if (!result) {
                    String msg = String.format("timeout after %d ms waiting for stop confirmation.sessionId:%s,state:%s", new Object[]{milliSeconds, this.sessionId, this.state});
                    logger.error(msg);
                    throw new Exception(msg);
                }
            } else {
                this.stopLatch.await();
            }
        }
    }

    private void waitComplete(int interval) {
        while (this.conn.isActive()) {
            try {
                Thread.sleep(interval);
            }
            catch (Exception e) {
                break;
            }
        }
    }

    public void close() {
        try {
            if (this.conn != null) {
                this.conn.close();
            }
            if (TtsConstant.DEFAULT_TTS_FLOWING_CLOSE_SLEEP_MILLISECONDS > 0) {
                Thread.sleep(TtsConstant.DEFAULT_TTS_FLOWING_CLOSE_SLEEP_MILLISECONDS);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void markReady() {
        logger.debug("sessionId:{},markReady change state from {} ", (Object)this.sessionId, (Object)this.state);
        this.state = this.state.send();
        logger.debug("sessionId:{},markReady change state to {} ", (Object)this.sessionId, (Object)this.state);
        if (this.startLatch != null) {
            this.startLatch.countDown();
        }
    }

    void markComplete() {
        logger.debug("sessionId:{},markComplete change state from {} ", (Object)this.sessionId, (Object)this.state);
        this.state = this.state.complete();
        logger.debug("sessionId:{},markComplete change state to {} ", (Object)this.sessionId, (Object)this.state);
        if (this.stopLatch != null) {
            this.stopLatch.countDown();
        }
    }

    void markFail() {
        logger.debug("sessionId:{},markFail change state from {} ", (Object)this.sessionId, (Object)this.state);
        this.state = this.state.fail();
        logger.debug("sessionId:{},markFail change state to {} ", (Object)this.sessionId, (Object)this.state);
        if (this.startLatch != null) {
            this.startLatch.countDown();
        }
        if (this.stopLatch != null) {
            this.stopLatch.countDown();
        }
    }

    void markClosed() {
        logger.debug("sessionId:{},markClosed change state from {} ", (Object)this.sessionId, (Object)this.state);
        this.state = this.state.closed();
        logger.debug("sessionId:{},markClosed change state to {} ", (Object)this.sessionId, (Object)this.state);
        if (this.startLatch != null) {
            this.startLatch.countDown();
        }
        if (this.stopLatch != null) {
            this.stopLatch.countDown();
        }
    }
}

