/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ttsv2;

import com.google.gson.Gson;
import com.tencent.core.help.SignHelper;
import com.tencent.core.utils.SignBuilder;
import com.tencent.core.ws.Connection;
import com.tencent.core.ws.ConnectionProfile;
import com.tencent.core.ws.Credential;
import com.tencent.core.ws.SpeechClient;
import com.tencent.core.ws.StateMachine;
import com.tencent.ttsv2.SpeechSynthesizerListener;
import com.tencent.ttsv2.SpeechSynthesizerRequest;
import com.tencent.ttsv2.TtsConstant;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeechSynthesizer
extends StateMachine {
    static Logger logger = LoggerFactory.getLogger(SpeechSynthesizer.class);
    private final Map<String, Object> ctx = new HashMap<String, Object>();
    private final String recUuid = UUID.randomUUID().toString();
    private final CountDownLatch stopLatch;
    private final CountDownLatch startLatch;
    protected long lastSendTime = -1L;
    protected Connection conn;
    private Credential credential;
    private SpeechSynthesizerRequest request;
    private SpeechClient client;
    private SpeechSynthesizerListener listener;

    public Credential getCredential() {
        return this.credential;
    }

    public void setCredential(Credential credential) {
        this.credential = credential;
    }

    public SpeechSynthesizerRequest getRequest() {
        return this.request;
    }

    public void setRequest(SpeechSynthesizerRequest request) {
        this.request = request;
    }

    public SpeechClient getClient() {
        return this.client;
    }

    public void setClient(SpeechClient client) {
        this.client = client;
    }

    public SpeechSynthesizerListener getListener() {
        return this.listener;
    }

    public void setListener(SpeechSynthesizerListener listener) {
        this.listener = listener;
    }

    public SpeechSynthesizer(SpeechClient client, Credential credential, SpeechSynthesizerRequest request, SpeechSynthesizerListener listener) throws Exception {
        Optional.ofNullable(client).orElseThrow(() -> new RuntimeException("client cannot be null"));
        Optional.ofNullable(request).orElseThrow(() -> new RuntimeException("request cannot be null"));
        Optional.ofNullable(credential).orElseThrow(() -> new RuntimeException("credential cannot be null"));
        Optional.ofNullable(listener).orElseThrow(() -> new RuntimeException("listener cannot be null"));
        if (request.getSessionId() == null) {
            request.setSessionId(this.recUuid);
        }
        request.setAction("TextToStreamAudioWS");
        request.setAppId(Integer.valueOf(credential.getAppid()));
        this.request = request;
        this.credential = credential;
        this.client = client;
        this.listener = listener;
        this.stopLatch = new CountDownLatch(1);
        this.startLatch = new CountDownLatch(1);
        listener.setSpeechSynthesizer(this);
    }

    public void start() throws Exception {
        this.start(TtsConstant.DEFAULT_START_TIMEOUT_MILLISECONDS);
    }

    public void start(long milliSeconds) throws Exception {
        this.state.checkStart();
        logger.debug("recUuid:{},start change state from {} ", (Object)this.recUuid, (Object)this.state);
        this.state = this.state.start();
        logger.debug("recUuid:{},start change state to {} ", (Object)this.recUuid, (Object)this.state);
        this.request.setSecretid(this.credential.getSecretId());
        this.request.setTimestamp(System.currentTimeMillis() / 1000L);
        this.request.setExpired(System.currentTimeMillis() / 1000L + 86400L);
        Map<String, Object> sortParamMap = this.request.toTreeMap();
        String signUrl = TtsConstant.DEFAULT_TTS_SIGN_PREFIX + SignHelper.createUrl(sortParamMap);
        logger.debug(signUrl);
        String sign = SignBuilder.base64_hmac_sha1(signUrl, this.credential.getSecretKey());
        String serverUrl = SignHelper.createUrl(SignHelper.encode(sortParamMap));
        String url = TtsConstant.DEFAULT_TTS_REQ_URL + serverUrl + "&Signature=" + URLEncoder.encode(sign, "UTF-8");
        logger.debug(url);
        ConnectionProfile connectionProfile = new ConnectionProfile(sign, url, TtsConstant.DEFAULT_HOST, this.credential.getToken());
        this.conn = this.client.connect(connectionProfile, this.listener);
        HashMap<String, Long> network = new HashMap<String, Long>();
        network.put("connectingLatency", this.conn.getConnectingLatency());
        network.put("handshakeLatency", this.conn.getHandshakeLatency());
        this.ctx.put("network", network);
        boolean result = this.startLatch.await(milliSeconds, TimeUnit.MILLISECONDS);
        if (!result) {
            String msg = String.format("timeout after %d ms waiting for start confirmation.recUuid:%s,state:%s", new Object[]{milliSeconds, this.recUuid, this.state});
            logger.error(msg);
            throw new Exception(msg);
        }
    }

    public void stop() throws Exception {
        this.stop(TtsConstant.DEFAULT_START_TIMEOUT_MILLISECONDS);
    }

    public void stop(long milliSeconds) throws Exception {
        if (this.state == StateMachine.State.STATE_COMPLETE) {
            logger.info("state is {} stop message is discarded", (Object)StateMachine.State.STATE_COMPLETE);
            return;
        }
        this.state.checkStop();
        this.state = this.state.stopSend();
        if (this.conn != null) {
            HashMap<String, String> end = new HashMap<String, String>();
            end.put("type", "end");
            this.conn.sendText(new Gson().toJson(end));
            boolean result = this.stopLatch.await(milliSeconds, TimeUnit.MILLISECONDS);
            if (!result) {
                String msg = String.format("timeout after %d ms waiting for stop confirmation.recUuid:%s,state:%s", new Object[]{milliSeconds, this.recUuid, this.state});
                logger.error(msg);
                throw new Exception(msg);
            }
        }
    }

    public void close() {
        if (this.conn != null) {
            this.conn.close();
        }
    }

    void markReady() {
        logger.debug("recUuid:{},markReady change state from {} ", (Object)this.recUuid, (Object)this.state);
        this.state = this.state.send();
        logger.debug("recUuid:{},markReady change state to {} ", (Object)this.recUuid, (Object)this.state);
        if (this.startLatch != null) {
            this.startLatch.countDown();
        }
    }

    void markComplete() {
        logger.debug("recUuid:{},markComplete change state from {} ", (Object)this.recUuid, (Object)this.state);
        this.state = this.state.complete();
        logger.debug("recUuid:{},markComplete change state to {} ", (Object)this.recUuid, (Object)this.state);
        if (this.stopLatch != null) {
            this.stopLatch.countDown();
        }
    }

    void markFail() {
        logger.debug("recUuid:{},markFail change state from {} ", (Object)this.recUuid, (Object)this.state);
        this.state = this.state.fail();
        logger.debug("recUuid:{},markFail change state to {} ", (Object)this.recUuid, (Object)this.state);
        if (this.startLatch != null) {
            this.startLatch.countDown();
        }
        if (this.stopLatch != null) {
            this.stopLatch.countDown();
        }
    }

    void markClosed() {
        logger.debug("recUuid:{},markClosed change state from {} ", (Object)this.recUuid, (Object)this.state);
        this.state = this.state.closed();
        logger.debug("recUuid:{},markClosed change state to {} ", (Object)this.recUuid, (Object)this.state);
        if (this.startLatch != null) {
            this.startLatch.countDown();
        }
        if (this.stopLatch != null) {
            this.stopLatch.countDown();
        }
    }
}

