/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.virtualnumber;

import com.google.gson.Gson;
import com.tencent.core.ws.ConnectionListener;
import com.tencent.virtualnumber.VirtualNumberRecognizer;
import com.tencent.virtualnumber.VirtualNumberRecognizerResponse;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VirtualNumberRecognizerListener
implements ConnectionListener {
    Logger logger = LoggerFactory.getLogger(VirtualNumberRecognizerListener.class);
    protected VirtualNumberRecognizer recognizer;
    private String status = "init";

    public void setVirtualNumberRecognizer(VirtualNumberRecognizer recognizer) {
        this.recognizer = recognizer;
    }

    public abstract void onRecognitionStart(VirtualNumberRecognizerResponse var1);

    public abstract void onRecognitionComplete(VirtualNumberRecognizerResponse var1);

    public abstract void onFail(VirtualNumberRecognizerResponse var1);

    public abstract void onMessage(VirtualNumberRecognizerResponse var1);

    @Override
    public void onOpen() {
        this.logger.debug("onOpen is ok");
    }

    @Override
    public void onClose(int closeCode, String reason) {
        if (this.recognizer != null) {
            this.recognizer.markClosed();
        }
        this.logger.debug("connection is closed due to {},code:{}", (Object)reason, (Object)closeCode);
    }

    @Override
    public void onMessage(String message) {
        if (message == null || message.trim().length() == 0) {
            return;
        }
        this.logger.debug("on message:{}", (Object)message);
        Gson gson = new Gson();
        VirtualNumberRecognizerResponse response = (VirtualNumberRecognizerResponse)gson.fromJson(message, VirtualNumberRecognizerResponse.class);
        this.onMessage(response);
        if (this.isRecReady(response)) {
            this.onRecognitionStart(response);
            this.recognizer.markReady();
        } else if (!this.isRecResult(response) || response.getResult() == null) {
            if (this.isRecComplete(response)) {
                this.onRecognitionComplete(response);
                this.recognizer.markComplete();
            } else if (this.isTaskFailed(response)) {
                this.onFail(response);
                this.recognizer.markFail();
            } else {
                this.logger.error(message);
            }
        }
    }

    @Override
    public void onMessage(ByteBuffer message) {
    }

    private boolean isRecReady(VirtualNumberRecognizerResponse response) {
        if (response.getCode() == 0 && Objects.equals(this.status, "init") && response.getEnd() != 1) {
            this.status = "rec";
            return true;
        }
        return false;
    }

    private boolean isRecResult(VirtualNumberRecognizerResponse response) {
        return response.getCode() == 0 && Objects.equals(this.status, "rec") && response.getEnd() != 1;
    }

    private boolean isRecComplete(VirtualNumberRecognizerResponse response) {
        if (response.getCode() == 0 && response.getEnd() == 1) {
            this.status = "complete";
            return true;
        }
        return false;
    }

    private boolean isTaskFailed(VirtualNumberRecognizerResponse response) {
        int code = response.getCode();
        if (code != 0) {
            this.status = "failed";
            return true;
        }
        return false;
    }
}

