/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.core;

import com.vertica.security.TrustStoreResolver;
import com.vertica.shaded.google.gson.Gson;
import com.vertica.shaded.google.gson.JsonElement;
import com.vertica.shaded.google.gson.JsonObject;
import com.vertica.shaded.google.gson.JsonParser;
import com.vertica.shaded.google.gson.JsonSyntaxException;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public class OAuthBrowserFlow {
    String authCode = "";
    String clientSecret = "";
    String clientId = "";
    String redirectUrl = "";
    String authUrl = "";
    String tokenUrl = "";
    String scope = "";
    String discoveryUrl = "";
    boolean validateHost = true;
    static final String grant_type = "authorization_code";
    String codeVerifier = "";
    String codeChallenge = "";
    TrustStoreResolver trustStore;

    public void init(String string, TrustStoreResolver trustStoreResolver) throws RuntimeException {
        this.trustStore = trustStoreResolver;
        try {
            this.ParseJsonConfig(string);
            this.SetTokenAndAuthUrlFromDiscoveryUrl();
            this.EnsureRequiredFieldsEntered();
        }
        catch (Exception exception) {
            throw new JsonConfigurationException("Error initializing from JSON configuration file: " + exception.getMessage());
        }
    }

    private void ParseJsonConfig(String string) throws RuntimeException {
        if (string == null || string.isEmpty()) {
            throw new JsonConfigurationException("A Json configuration must be included when doing browser OAuth flow.");
        }
        try {
            Gson gson = new Gson();
            JsonElement jsonElement = gson.fromJson(string, JsonElement.class);
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            String string2 = "";
            string2 = this.ParseJsonField(jsonObject, "OAuthTokenUrl");
            if (!string2.isEmpty()) {
                this.tokenUrl = string2;
            }
            if (!(string2 = this.ParseJsonField(jsonObject, "OAuthAuthUrl")).isEmpty()) {
                this.authUrl = string2;
            }
            if (!(string2 = this.ParseJsonField(jsonObject, "OAuthClientId")).isEmpty()) {
                this.clientId = string2;
            }
            if (!(string2 = this.ParseJsonField(jsonObject, "OAuthClientSecret")).isEmpty()) {
                this.clientSecret = string2;
            }
            if (!(string2 = this.ParseJsonField(jsonObject, "OAuthDiscoveryUrl")).isEmpty()) {
                this.discoveryUrl = string2;
            }
            if (!(string2 = this.ParseJsonField(jsonObject, "OAuthScope")).isEmpty()) {
                this.scope = string2;
            }
            if (!(string2 = this.ParseJsonField(jsonObject, "OAuthValidateHostname")).isEmpty() && string2.equals("false")) {
                this.validateHost = false;
            }
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            throw new JsonConfigurationException("Invalid JSON string provided for OAuth configuration: " + jsonSyntaxException.getMessage());
        }
    }

    private String ParseJsonField(JsonObject jsonObject, String string) {
        JsonElement jsonElement = jsonObject.get(string);
        if (jsonElement != null) {
            return jsonElement.getAsString();
        }
        JsonElement jsonElement2 = jsonObject.get(string.toLowerCase());
        if (jsonElement2 != null) {
            return jsonElement2.getAsString();
        }
        return "";
    }

    private void SetTokenAndAuthUrlFromDiscoveryUrl() {
        if (this.discoveryUrl.isEmpty() || !this.tokenUrl.isEmpty() && !this.authUrl.isEmpty()) {
            return;
        }
        try {
            StringBuilder stringBuilder;
            BufferedReader bufferedReader;
            URL uRL = new URL(this.discoveryUrl);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            this.SetCustomizedSSLSocketFactory(httpURLConnection);
            this.SetHostnameValidation(httpURLConnection);
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                String string;
                bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                stringBuilder = new StringBuilder();
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string);
                }
            } else {
                throw new OAuthURLFormattingException("Error getting authorization and token urls. Response code: " + n);
            }
            bufferedReader.close();
            JsonObject jsonObject = JsonParser.parseString(stringBuilder.toString()).getAsJsonObject();
            String string = jsonObject.get("authorization_endpoint").getAsString();
            String string2 = jsonObject.get("token_endpoint").getAsString();
            this.authUrl = this.getValueOrEmpty(string);
            this.tokenUrl = this.getValueOrEmpty(string2);
        }
        catch (IOException iOException) {
            throw new OAuthBrowserException("Error using discovery url: " + iOException.getMessage());
        }
    }

    private void EnsureRequiredFieldsEntered() throws RuntimeException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Client Id", this.clientId);
        hashMap.put("Auth url", this.authUrl);
        hashMap.put("Token url", this.tokenUrl);
        for (String string : hashMap.keySet()) {
            String string2 = (String)hashMap.get(string);
            if (string2 != null && !string2.isEmpty()) continue;
            throw new OAuthBrowserMissingFieldException("Missing field for browser auth flow: " + string);
        }
    }

    public String doAuth() throws RuntimeException {
        this.setRedirectUrl();
        this.setAuthCode();
        return this.setAccessToken();
    }

    private void setRedirectUrl() {
        int n = -1;
        try (ServerSocket serverSocket = new ServerSocket(0);){
            int n2;
            n = n2 = serverSocket.getLocalPort();
        }
        catch (IOException iOException) {
            throw new ServerStartException("Unable to assign an open port to redirect url: " + iOException.getMessage());
        }
        this.redirectUrl = "http://localhost:" + n;
    }

    private void setAuthCode() throws RuntimeException {
        Object object;
        String string = UUID.randomUUID().toString();
        this.codeVerifier = this.setCodeVerifier();
        this.codeChallenge = this.setCodeChallenge();
        String string2 = this.authUrl + "?client_id=" + this.clientId + "&response_type=code&redirect_uri=" + this.redirectUrl + "&state=" + string + "&code_challenge=" + this.codeChallenge + "&code_challenge_method=S256";
        this.scope = this.getValueOrEmpty(this.scope);
        if (!this.scope.isEmpty()) {
            string2 = string2 + "&scope=" + this.scope;
        }
        if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            throw new UnsupportedEnvironmentException("Can't open browser in this environment.");
        }
        int n = -1;
        String string3 = "";
        try {
            object = new URI(this.redirectUrl);
            n = ((URI)object).getPort();
            string3 = ((URI)object).getHost();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new OAuthURLFormattingException("Redirect URL improperly formatted: " + uRISyntaxException.getMessage());
        }
        object = null;
        try {
            object = new ServerSocket(n, 0, InetAddress.getByName(string3));
            ((ServerSocket)object).setSoTimeout(60000);
        }
        catch (IOException iOException) {
            throw new ServerStartException("Unable to start server on port " + n + ": " + iOException.getMessage());
        }
        try {
            Desktop.getDesktop().browse(new URI(string2));
        }
        catch (IOException | URISyntaxException exception) {
            throw new OAuthURLFormattingException("Unable to open URL: " + exception.getMessage());
        }
        Socket socket = null;
        if (object != null) {
            try {
                socket = ((ServerSocket)object).accept();
            }
            catch (IOException iOException) {
                throw new ServerStartException("Unable to start server on port " + n + ": " + iOException.getMessage());
            }
        }
        try {
            String[] stringArray;
            String string4;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string4 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string4).append("\r\n");
                if (!string4.isEmpty()) continue;
            }
            for (String string5 : stringArray = stringBuilder.toString().split("\r\n")) {
                if (!string5.contains("code=")) continue;
                String string6 = string5.substring(6, string5.indexOf(32, 8));
                HashMap<String, String> hashMap = new HashMap<String, String>();
                for (String string7 : string6.split("&")) {
                    String[] stringArray2 = string7.split("=");
                    hashMap.put(stringArray2[0], stringArray2[1]);
                }
                String string8 = (String)hashMap.get("state");
                this.authCode = (String)hashMap.get("code");
                if (this.authCode == null || this.authCode.isEmpty()) {
                    throw new RuntimeException("Didn't get an authorization code from endpoint!");
                }
                if (!string8.equalsIgnoreCase(string)) {
                    throw new RuntimeException("State token doesn't match!");
                }
                this.returnToBrowser(socket);
                break;
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            throw new ServerStopException("Timeout waiting for response from client: " + socketTimeoutException.getMessage());
        }
        catch (IOException iOException) {
            throw new RuntimeException("An error occurred during browser flow: " + iOException.getMessage());
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    throw new ServerStopException("Problem closing socket object: " + iOException.getMessage());
                }
            }
            if (object != null) {
                try {
                    ((ServerSocket)object).close();
                }
                catch (IOException iOException) {
                    throw new ServerStopException("Problem closing server socket: " + iOException.getMessage());
                }
            }
        }
    }

    private void returnToBrowser(Socket socket) {
        try {
            PrintWriter printWriter = new PrintWriter(socket.getOutputStream(), true);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("HTTP/1.0 200 OK");
            arrayList.add("Content-Type: text/html");
            String string = "<!DOCTYPE html><html><head><meta charset=\"UTF-8\"/><title>OAuth Response for Vertica JDBC</title></head><body>Your identity was confirmed and propagated to Vertica JDBC driver. You can close this window and go back to where you started.</body></html>";
            arrayList.add(String.format("Content-Length: %s", string.length()));
            arrayList.add("");
            arrayList.add(string);
            for (int i = 0; i < arrayList.size(); ++i) {
                if (i > 0) {
                    printWriter.print("\r\n");
                }
                printWriter.print((String)arrayList.get(i));
            }
            printWriter.flush();
        }
        catch (IOException iOException) {
            throw new OAuthBrowserException("Error displaying response from redirect url: " + iOException.getMessage());
        }
    }

    private String setAccessToken() throws RuntimeException {
        try {
            Object object;
            Object object2;
            URL uRL = new URL(this.tokenUrl);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("accept", "application/json");
            httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            if (!this.clientSecret.isEmpty()) {
                object2 = Base64.getEncoder().encodeToString((this.clientId + ":" + this.clientSecret).getBytes(StandardCharsets.UTF_8));
                httpURLConnection.setRequestProperty("Authorization", "Basic " + (String)object2);
            }
            this.SetCustomizedSSLSocketFactory(httpURLConnection);
            this.SetHostnameValidation(httpURLConnection);
            httpURLConnection.setDoOutput(true);
            object2 = new DataOutputStream(httpURLConnection.getOutputStream());
            Serializable serializable = null;
            try {
                object = "grant_type=authorization_code&redirect_uri=" + this.redirectUrl + "&code=" + this.authCode + "&client_id=" + this.clientId + "&code_verifier=" + this.codeVerifier;
                ((DataOutputStream)object2).writeBytes((String)object);
            }
            catch (Throwable throwable) {
                serializable = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (serializable != null) {
                        try {
                            ((FilterOutputStream)object2).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)serializable).addSuppressed(throwable);
                        }
                    } else {
                        ((FilterOutputStream)object2).close();
                    }
                }
            }
            int n = httpURLConnection.getResponseCode();
            if (n == 400) {
                throw new OAuthBrowserException("Server responded with a Bad Request (HTTP 400) when trying to get access token");
            }
            serializable = new StringBuilder();
            object = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            Throwable throwable = null;
            try {
                String string;
                while ((string = ((BufferedReader)object).readLine()) != null) {
                    ((StringBuilder)serializable).append(string);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((BufferedReader)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((BufferedReader)object).close();
                    }
                }
            }
            object = JsonParser.parseString(((StringBuilder)serializable).toString()).getAsJsonObject();
            return ((JsonObject)object).get("access_token").getAsString();
        }
        catch (MalformedURLException malformedURLException) {
            throw new OAuthURLFormattingException("Invalid token URL: " + this.tokenUrl + ": " + malformedURLException.getMessage());
        }
        catch (IOException iOException) {
            throw new OAuthURLFormattingException("Error while opening token URL: " + this.tokenUrl + ": " + iOException.getMessage());
        }
    }

    private void SetHostnameValidation(HttpURLConnection httpURLConnection) {
        if (!this.validateHost && httpURLConnection instanceof HttpsURLConnection) {
            HostnameVerifier hostnameVerifier = new HostnameVerifier(){

                @Override
                public boolean verify(String string, SSLSession sSLSession) {
                    return true;
                }
            };
            ((HttpsURLConnection)httpURLConnection).setHostnameVerifier(hostnameVerifier);
        }
    }

    private void SetCustomizedSSLSocketFactory(HttpURLConnection httpURLConnection) {
        if (httpURLConnection instanceof HttpsURLConnection) {
            try {
                KeyStore keyStore = this.trustStore.getKeyStore();
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(keyStore);
                SSLContext sSLContext = SSLContext.getInstance("TLSv1.2");
                sSLContext.init(null, trustManagerFactory.getTrustManagers(), null);
                SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
                ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(sSLSocketFactory);
            }
            catch (Exception exception) {
                throw new OAuthBrowserException("Cannot set Customized SSLSocketFactory:" + exception.getMessage());
            }
        }
    }

    private String setCodeVerifier() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[32];
        secureRandom.nextBytes(byArray);
        Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
        return encoder.encodeToString(byArray);
    }

    private String setCodeChallenge() {
        try {
            byte[] byArray = this.codeVerifier.getBytes();
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(byArray);
            byte[] byArray2 = messageDigest.digest();
            Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
            return encoder.encodeToString(byArray2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new OAuthBrowserException("Unable to authenticate without client secret using PKCE: " + noSuchAlgorithmException.getMessage());
        }
    }

    private String getValueOrEmpty(String string) {
        return string != null ? string : "";
    }

    private class OAuthBrowserException
    extends RuntimeException {
        private OAuthBrowserException(String string) {
            super(string);
        }
    }

    private class ServerStopException
    extends RuntimeException {
        private ServerStopException(String string) {
            super(string);
        }
    }

    private class ServerStartException
    extends RuntimeException {
        private ServerStartException(String string) {
            super(string);
        }
    }

    private class OAuthURLFormattingException
    extends RuntimeException {
        private OAuthURLFormattingException(String string) {
            super(string);
        }
    }

    private class UnsupportedEnvironmentException
    extends RuntimeException {
        private UnsupportedEnvironmentException(String string) {
            super(string);
        }
    }

    private class JsonConfigurationException
    extends RuntimeException {
        private JsonConfigurationException(String string) {
            super(string);
        }
    }

    private class OAuthBrowserMissingFieldException
    extends RuntimeException {
        private OAuthBrowserMissingFieldException(String string) {
            super(string);
        }
    }
}

