/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.io;

import com.vertica.io.MessageType;
import com.vertica.io.RequestMessage;
import com.vertica.io.VStream;
import com.vertica.util.ProtocolUtils;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class PasswordRequestMessage
extends RequestMessage {
    private PasswordType m_passwordType;
    private byte[] m_passwordBytes;

    public PasswordRequestMessage(String string) {
        this.m_passwordBytes = ProtocolUtils.encodeUTF8(string);
        this.m_passwordType = PasswordType.PLAINTEXT;
    }

    public PasswordRequestMessage(byte[] byArray, PasswordType passwordType) {
        this.m_passwordBytes = byArray;
        this.m_passwordType = passwordType;
    }

    public PasswordRequestMessage(String string, String string2, byte[] byArray) {
        this.m_passwordBytes = PasswordRequestMessage.encode(string, string2, byArray);
        this.m_passwordType = PasswordType.MD5;
    }

    public PasswordRequestMessage(byte[] byArray, String string, byte[] byArray2) {
        this.m_passwordBytes = PasswordRequestMessage.encodeSHA512(byArray, string, byArray2);
        this.m_passwordType = PasswordType.SHA512;
    }

    @Override
    protected void send(VStream vStream) throws IOException {
        vStream.SendChar(112);
        vStream.SendInteger4(4 + this.m_passwordBytes.length + (this.m_passwordType == PasswordType.GSS ? 0 : 1));
        vStream.Send(this.m_passwordBytes);
        if (this.m_passwordType != PasswordType.GSS) {
            vStream.SendChar(0);
        }
    }

    @Override
    public MessageType getType() {
        return MessageType.Password;
    }

    public static byte[] encode(String string, String string2, byte[] byArray) {
        return PasswordRequestMessage.encode(string, string2, byArray, true, null);
    }

    public static byte[] encodeSHA512(byte[] byArray, String string, byte[] byArray2) {
        return PasswordRequestMessage.encode(null, string, byArray2, false, byArray);
    }

    public static byte[] encode(String string, String string2, byte[] byArray, boolean bl, byte[] byArray2) {
        byte[] byArray3 = null;
        try {
            int n = bl ? 3 : 6;
            int n2 = bl ? 16 : 64;
            byArray3 = new byte[n + n2 * 2];
            MessageDigest messageDigest = bl ? MessageDigest.getInstance("MD5") : MessageDigest.getInstance("SHA-512");
            messageDigest.update(ProtocolUtils.encodeUTF8(string2));
            messageDigest.update(bl ? ProtocolUtils.encodeUTF8(string) : byArray2);
            byte[] byArray4 = messageDigest.digest();
            PasswordRequestMessage.bytesToHex(byArray4, byArray3, 0, n2);
            messageDigest.update(byArray3, 0, n2 * 2);
            messageDigest.update(byArray);
            byte[] byArray5 = messageDigest.digest();
            PasswordRequestMessage.bytesToHex(byArray5, byArray3, n, n2);
            String string3 = bl ? "md5" : "sha512";
            System.arraycopy(string3.getBytes(), 0, byArray3, 0, string3.length());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return byArray3;
    }

    private static void bytesToHex(byte[] byArray, byte[] byArray2, int n, int n2) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            int n4 = byArray[i] & 0xFF;
            int n5 = n4 >> 4;
            byArray2[n3++] = (byte)cArray[n5];
            n5 = n4 & 0xF;
            byArray2[n3++] = (byte)cArray[n5];
        }
    }

    public static enum PasswordType {
        PLAINTEXT,
        GSS,
        MD5,
        SHA512,
        OAUTH,
        SESSION_TRANSFER;

    }
}

