/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.io;

import com.vertica.io.MessageType;
import com.vertica.io.ResponseMessage;
import com.vertica.io.VStream;
import java.io.IOException;

public final class RedirectMessage
extends ResponseMessage {
    private String m_destinationHost;
    private int m_destinationPort;
    private byte[] m_sessionInfo;

    protected RedirectMessage(VStream vStream) {
        super(vStream);
    }

    @Override
    protected void buildMessage(int n) throws IOException {
        this.m_destinationHost = this.m_vStream.ReceiveString();
        this.m_destinationPort = this.m_vStream.ReceiveIntegerR(4);
        int n2 = this.m_vStream.ReceiveIntegerR(8);
        this.m_sessionInfo = new byte[n2];
        this.m_vStream.Receive(this.m_sessionInfo, 0, n2);
    }

    public String getDestinationHost() {
        return this.m_destinationHost;
    }

    public int getDestinationPort() {
        return this.m_destinationPort;
    }

    public byte[] getSessionInfo() {
        return this.m_sessionInfo;
    }

    @Override
    public MessageType getType() {
        return MessageType.Redirect;
    }
}

