/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.io;

import com.vertica.io.MessageType;
import com.vertica.io.RequestMessage;
import com.vertica.io.VStream;
import com.vertica.util.ProtocolUtils;
import java.io.File;
import java.io.IOException;

public final class VerifiedFilesRequestMessage
extends RequestMessage {
    private File[] m_files;

    public VerifiedFilesRequestMessage(File[] fileArray) {
        this.m_files = fileArray;
    }

    @Override
    void send(VStream vStream) throws IOException {
        int n;
        byte[][] byArrayArray = new byte[this.m_files.length][];
        int n2 = vStream.getConnection().getEffectiveProtocolVersion().isAtLeast(ProtocolUtils.ProtocolVersion.PROTOCOL_VERSION_3_15) ? 8 + 9 * this.m_files.length : 6 + 9 * this.m_files.length;
        for (n = 0; n < this.m_files.length; ++n) {
            byArrayArray[n] = ProtocolUtils.encodeUTF8(this.m_files[n].getAbsolutePath());
            n2 += byArrayArray[n].length;
        }
        vStream.SendChar(70);
        vStream.SendInteger4(n2);
        if (vStream.getConnection().getEffectiveProtocolVersion().isAtLeast(ProtocolUtils.ProtocolVersion.PROTOCOL_VERSION_3_15)) {
            vStream.SendInteger2(0);
        }
        vStream.SendInteger2(this.m_files.length);
        for (n = 0; n < this.m_files.length; ++n) {
            vStream.Send(byArrayArray[n]);
            vStream.SendChar(0);
            vStream.SendInteger8(this.m_files[n].length());
        }
    }

    @Override
    public MessageType getType() {
        return MessageType.VerifiedFiles;
    }

    @Override
    public Object[] getDebugInfo() {
        Object[] objectArray = new Object[this.m_files.length + 1];
        objectArray[0] = this.getType();
        for (int i = 0; i < this.m_files.length; ++i) {
            objectArray[i + 1] = this.m_files[i].getAbsolutePath();
        }
        return objectArray;
    }
}

