/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc;

import com.vertica.core.VConnection;
import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.dsi.core.interfaces.IStatement;
import com.vertica.jdbc.VerticaJdbc42ConnectionHandle;
import com.vertica.jdbc.VerticaJdbc42ConnectionImpl;
import com.vertica.jdbc.VerticaJdbc42PreparedStatementImpl;
import com.vertica.jdbc.VerticaJdbc42StatementImpl;
import com.vertica.jdbc.common.SCallableStatement;
import com.vertica.jdbc.common.SConnection;
import com.vertica.jdbc.common.SConnectionHandle;
import com.vertica.jdbc.common.SPooledConnection;
import com.vertica.jdbc.common.SPreparedStatement;
import com.vertica.jdbc.common.SStatement;
import com.vertica.jdbc.hybrid.HybridJDBCObjectFactory;
import com.vertica.jdbc.jdbc42.S42Connection;
import com.vertica.jdbc.kv.VerticaJdbc42RoutableConnectionImpl;
import com.vertica.utilities.JDBCVersion;
import java.sql.SQLException;
import javax.sql.PooledConnection;

final class VJDBCObjectFactory
extends HybridJDBCObjectFactory {
    private final JDBCVersion m_JDBCVersion;

    protected VJDBCObjectFactory(JDBCVersion jDBCVersion) {
        super(jDBCVersion);
        this.m_JDBCVersion = jDBCVersion;
    }

    @Override
    protected SCallableStatement createCallableStatement(String string, IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        return super.createCallableStatement(string, iStatement, sConnection, n);
    }

    @Override
    protected SConnection createConnection(IConnection iConnection, String string) throws SQLException {
        boolean bl = ((VConnection)iConnection).getEnableRoutableQueries();
        Object var4_4 = null;
        switch (this.m_JDBCVersion) {
            case JDBC42: {
                return bl ? new VerticaJdbc42RoutableConnectionImpl(iConnection, string) : new VerticaJdbc42ConnectionImpl(iConnection, string);
            }
        }
        return bl ? new VerticaJdbc42RoutableConnectionImpl(iConnection, string) : new VerticaJdbc42ConnectionImpl(iConnection, string);
    }

    @Override
    protected SPreparedStatement createPreparedStatement(String string, IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        switch (this.m_JDBCVersion) {
            case JDBC42: {
                return new VerticaJdbc42PreparedStatementImpl(string, iStatement, (S42Connection)sConnection, n);
            }
        }
        return new VerticaJdbc42PreparedStatementImpl(string, iStatement, (S42Connection)sConnection, n);
    }

    @Override
    protected SStatement createStatement(IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        switch (this.m_JDBCVersion) {
            case JDBC42: {
                return new VerticaJdbc42StatementImpl(iStatement, (S42Connection)sConnection, n);
            }
        }
        return new VerticaJdbc42StatementImpl(iStatement, (S42Connection)sConnection, n);
    }

    @Override
    protected PooledConnection createPooledConnection(SConnection sConnection) throws SQLException {
        return super.createPooledConnection(sConnection);
    }

    @Override
    protected SConnectionHandle createConnectionHandle(SConnection sConnection, SPooledConnection sPooledConnection) throws SQLException {
        switch (this.m_JDBCVersion) {
            case JDBC42: {
                return new VerticaJdbc42ConnectionHandle(sConnection, sPooledConnection);
            }
        }
        return new VerticaJdbc42ConnectionHandle(sConnection, sPooledConnection);
    }
}

