/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.jdbc42;

import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.dsi.core.interfaces.IStatement;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.TypeUtilities;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.common.SConnection;
import com.vertica.jdbc.common.SPreparedStatement;
import com.vertica.jdbc.common.SStatement;
import com.vertica.jdbc.jdbc41.S41CallableStatement;
import com.vertica.jdbc.jdbc42.S42Array;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.ExceptionType;
import com.vertica.utilities.JDBCVersion;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.sql.SQLType;

public class S42CallableStatement
extends S41CallableStatement {
    private long m_longMaxRows = Long.MAX_VALUE;

    public S42CallableStatement(String sql, IStatement statement, SConnection conn, int concurrency) throws SQLException {
        super(sql, statement, conn, concurrency);
        this.m_jdbcVersion = JDBCVersion.JDBC42;
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType targetSqlType) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, targetSqlType);
        if (!(targetSqlType instanceof SQLType)) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        this.registerOutParameter(parameterIndex, targetSqlType, 0);
        if (TypeUtilities.isExactNumericType(targetSqlType.getVendorTypeNumber())) {
            this.m_parameterScale.remove(parameterIndex);
        }
    }

    @Override
    public synchronized void registerOutParameter(int parameterIndex, SQLType targetSqlType, int scale) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, targetSqlType, scale);
        if (!(targetSqlType instanceof SQLType)) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        int sqlType = targetSqlType.getVendorTypeNumber();
        this.registerOutParameter(parameterIndex, sqlType, scale);
    }

    @Override
    public synchronized void registerOutParameter(int parameterIndex, SQLType targetSqlType, String typeName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, targetSqlType, typeName);
        if (!(targetSqlType instanceof SQLType)) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        int sqlType = targetSqlType.getVendorTypeNumber();
        this.registerOutParameter(parameterIndex, sqlType, typeName);
    }

    @Override
    public synchronized void registerOutParameter(String parameterName, SQLType targetSqlType) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, targetSqlType);
        if (!(targetSqlType instanceof SQLType)) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        this.registerOutParameter(parameterName, targetSqlType, 0);
        if (TypeUtilities.isExactNumericType(targetSqlType.getVendorTypeNumber())) {
            this.m_parameterScale.remove(this.getParameterIndex(parameterName));
        }
    }

    @Override
    public synchronized void registerOutParameter(String parameterName, SQLType targetSqlType, int scale) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, targetSqlType, scale);
        if (!(targetSqlType instanceof SQLType)) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        int sqlType = targetSqlType.getVendorTypeNumber();
        this.registerOutParameter(parameterName, sqlType, scale);
    }

    @Override
    public synchronized void registerOutParameter(String parameterName, SQLType targetSqlType, String typeName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, targetSqlType, typeName);
        if (!(targetSqlType instanceof SQLType)) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        int sqlType = targetSqlType.getVendorTypeNumber();
        this.registerOutParameter(parameterName, sqlType, typeName);
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object value, SQLType targetSqlType) throws SQLException {
        if (targetSqlType instanceof SQLType) {
            try {
                LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, value, targetSqlType);
                int scale = 0;
                if (value instanceof BigDecimal) {
                    scale = this.createExactNumMetadata((BigDecimal)value, 2).getScale();
                }
                this.setObject(parameterIndex, value, targetSqlType, scale);
            }
            catch (Exception e) {
                throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
            }
        } else {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object value, SQLType targetSqlType, int scale) throws SQLException {
        LogUtilities.logFunctionEntrance(this.getLogger(), parameterIndex, value, targetSqlType, scale);
        if (!(targetSqlType instanceof SQLType)) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        int targetSType = targetSqlType.getVendorTypeNumber();
        this.setObject(parameterIndex, value, targetSType, scale);
    }

    @Override
    public synchronized void setObject(String parameterName, Object value, SQLType targetSqlType) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, value, targetSqlType);
        if (!(targetSqlType instanceof SQLType)) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        this.setObject(this.getParameterIndex(parameterName), value, targetSqlType);
    }

    @Override
    public synchronized void setObject(String parameterName, Object value, SQLType targetSqlType, int scale) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, value, targetSqlType, scale);
        if (!(targetSqlType instanceof SQLType)) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        this.setObject(this.getParameterIndex(parameterName), value, targetSqlType, scale);
    }

    @Override
    public synchronized long[] executeLargeBatch() throws SQLException, BatchUpdateException {
        try {
            SPreparedStatement.BatchExecResult result = this.executePreparedAnyBatch();
            switch (result) {
                case BATCH_EXEC_NO_BATCHES: {
                    return new long[0];
                }
                case BATCH_EXEC_SUCCEEDED: {
                    return this.processLargeBatchResults(this.m_queryExecutor.getResults(), this.getBatchParamConversionErrors(), SStatement.BatchType.MULTI_PARAM_SET);
                }
                case BATCH_EXEC_ALL_FAILED_INPUT_CONVERSION: {
                    return this.processLargeBatchResults(null, this.getBatchParamConversionErrors(), SStatement.BatchType.MULTI_PARAM_SET);
                }
            }
            throw new RuntimeException("Invalid enum value: " + result.name());
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long executeLargeUpdate() throws SQLException {
        return this.executeAnyUpdate();
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex);
            this.checkIfOpen();
            DataWrapper data = this.getOutputParameterValue(parameterIndex);
            IConnection con = this.getParentConnection().getConnection();
            return new S42Array(data.getArray(), con, this.m_logger, this.m_warningListener);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }
}

