/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.kv;

import com.sun.rowset.CachedRowSetImpl;
import com.vertica.core.VConnection;
import com.vertica.jdbc.kv.KVErrors;
import com.vertica.jdbc.kv.KVLogger;
import com.vertica.jdbc.kv.OutputColumn;
import com.vertica.jdbc.kv.ProjectionMetadata;
import com.vertica.jdbc.kv.RoutableConnection;
import com.vertica.jdbc.kv.RoutableConnectionInternal;
import com.vertica.jdbc.kv.RoutableConnectionPool;
import com.vertica.jdbc.kv.SQLWarningChainer;
import com.vertica.jdbc.kv.SortColumn;
import com.vertica.jdbc.kv.TableMetadata;
import com.vertica.jdbc.kv.TableMetadataCache;
import com.vertica.jdbc.kv.VHash;
import com.vertica.jdbc.kv.VerticaRoutableConnection;
import com.vertica.parser.Tokenizer;
import com.vertica.util.ClientErrorException;
import com.vertica.util.TypeUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLRecoverableException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

class RoutableQuery {
    VerticaRoutableConnection parentConn;
    VConnection vConn;
    KVLogger log;
    String schema;
    String table;
    RoutableConnectionPool pool;
    TableMetadata metadata;
    TableMetadataCache metaCache;
    SQLWarningChainer warnings;
    AtomicLong parentEpoch;
    ProjectionMetadata lastProjUsed;
    String lastNodeUsed;
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String dateFormat = "yyyy-MM-dd";
    private static final String timeFormat = "HH:mm:ss.SSS";
    private static final String timeTzFormat = "HH:mm:ss.SSS";
    private static final String tsFormat = "yyyy-MM-dd HH:mm:ss.SSSZ";
    private static final String tsTzFormat = "yyyy-MM-dd HH:mm:ss.SSSZ";

    RoutableQuery(RoutableConnectionInternal routableConnectionInternal, String string, String string2, SQLWarningChainer sQLWarningChainer) throws SQLException {
        this.parentConn = routableConnectionInternal.getRoutableConnection();
        this.vConn = routableConnectionInternal.getConnection();
        String string3 = this.schema = string == null ? "" : string.toLowerCase();
        if (string2 == null || "".equals(string2)) {
            throw KVErrors.InvalidTableName.makeException(string2);
        }
        this.table = string2.toLowerCase();
        this.pool = routableConnectionInternal.getPool();
        this.log = routableConnectionInternal.getLog();
        this.metaCache = routableConnectionInternal.getMetaCache();
        this.parentEpoch = routableConnectionInternal.getEpoch();
        this.warnings = sQLWarningChainer;
        this.metadata = this.metaCache.getMetadata(this.schema, this.table, this.warnings);
    }

    ResultSet execute(Map<String, Object> map, Set<String> set, List<OutputColumn> list, List<SortColumn> list2, String string) throws SQLException {
        return this.execute(map, set, list, list2, string, true);
    }

    ResultSet executeSQLQuery(String string, Map<String, Object> map) throws SQLException {
        return this.execute(map, null, null, null, string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResultSet execute(Map<String, Object> map, Set<String> set, List<OutputColumn> arrayList, List<SortColumn> list, String string, boolean bl) throws SQLException {
        Object object;
        Object object2;
        List<ProjectionMetadata.ProjectionRanking> list2 = this.metadata.getProjectionsFor(map.keySet(), (List<OutputColumn>)(bl ? arrayList : new ArrayList<OutputColumn>()));
        if (list2.isEmpty()) {
            throw KVErrors.NotEnoughPredicates.makeException(new Object[0]);
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        HashMap<Object, ProjectionMetadata> hashMap = new HashMap<Object, ProjectionMetadata>();
        for (ProjectionMetadata.ProjectionRanking object3 : list2) {
            ProjectionMetadata projectionMetadata = object3.proj;
            object2 = new VHash();
            for (ProjectionMetadata.ProjectionColumnMetadata resultSet : projectionMetadata.getSegmentationColumns()) {
                Object resultSet2 = map.get(resultSet.nameInTable);
                int string3 = this.metadata.getColumnType(resultSet.nameInTable);
                int n = this.metadata.getColumnTypeMod(resultSet.nameInTable);
                ((VHash)object2).addByType(resultSet2, string3, n);
            }
            if (projectionMetadata.isSegmented) {
                object = projectionMetadata.getNodeFor(((VHash)object2).getHash());
                if (hashMap.containsKey(object)) continue;
                arrayList2.add(object);
                hashMap.put(object, projectionMetadata);
                continue;
            }
            object = projectionMetadata.getAllNodes();
            int resultSet = ((String[])object).length;
            for (int i = 0; i < resultSet; ++i) {
                String resultSet2 = object[i];
                if (hashMap.containsKey(resultSet2)) continue;
                arrayList2.add(resultSet2);
                hashMap.put(resultSet2, projectionMetadata);
            }
        }
        ArrayList<Object> arrayList3 = arrayList2;
        while (true) {
            if (arrayList3.isEmpty()) {
                throw KVErrors.ClusterFailedNoConnections.makeException(new Object[0]);
            }
            RoutableConnection routableConnection = this.pool.getConnection((List<String>)arrayList3, !bl);
            boolean bl2 = false;
            object2 = (ProjectionMetadata)hashMap.get(routableConnection.node);
            try {
                if (bl) {
                    object = this.rewriteQuery(string, map, set, arrayList, list, (ProjectionMetadata)object2, true);
                    ResultSet resultSet = this.runQueryOnRoutableConn(routableConnection, (String)object, (ProjectionMetadata)object2);
                    return resultSet;
                }
                Object object3 = object = string.charAt(string.length() - 1) == ';' ? string.substring(0, string.length() - 1) : string;
                if (((ProjectionMetadata)object2).offset >= 0) {
                    ResultSet n = this.runQueryOnRoutableConn(routableConnection, "SELECT /*+KV(O" + ((ProjectionMetadata)object2).offset + ")*/ * FROM ( " + (String)object + ") TMP", (ProjectionMetadata)object2);
                    return n;
                }
                ResultSet resultSet = this.runQueryOnRoutableConn(routableConnection, "SELECT /*+KV*/ * FROM ( " + (String)object + ") TMP", (ProjectionMetadata)object2);
                return resultSet;
            }
            catch (SQLException sQLException) {
                this.log.logError("Failed to execute get on " + ((ProjectionMetadata)object2).schema + "." + ((ProjectionMetadata)object2).name + " on node " + routableConnection.node, sQLException);
                if (sQLException instanceof SQLRecoverableException || sQLException instanceof SQLNonTransientConnectionException) {
                    this.warnings.add(KVErrors.ConnectionFailedGetRetried.makeWarning(sQLException, routableConnection.node));
                    arrayList3.remove(routableConnection.node);
                    this.log.logInfo("Retrying query as multi-node");
                    this.pool.destroyConnection(routableConnection);
                    bl2 = true;
                    continue;
                }
                int n = sQLException.getErrorCode();
                if (n == 2242 && !this.getFailOnMultiNodePlans()) {
                    this.warnings.add(KVErrors.GetRetriedAsMultinode.makeWarning(new Object[0]));
                    ResultSet resultSet = null;
                    try {
                        if (bl) {
                            String string2 = this.rewriteQuery(string, map, set, arrayList, list, (ProjectionMetadata)object2, false);
                            resultSet = this.runQueryOnRoutableConn(routableConnection, string2, (ProjectionMetadata)object2);
                        } else {
                            resultSet = this.runQueryOnRoutableConn(routableConnection, string, (ProjectionMetadata)object2);
                        }
                    }
                    finally {
                        this.runQueryOnSqlConn(routableConnection.conn, "rollback;");
                    }
                    ResultSet resultSet3 = resultSet;
                    return resultSet3;
                }
                if (n == 2624) {
                    throw sQLException;
                }
                throw sQLException;
            }
            finally {
                if (bl2 || routableConnection == null) continue;
                this.pool.returnConnection(routableConnection);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet runQueryOnRoutableConn(RoutableConnection routableConnection, String string, ProjectionMetadata projectionMetadata) throws SQLException {
        if (this.log.isEnabled()) {
            this.log.logDebug("Executing " + string + " on node " + routableConnection.node);
        }
        try {
            ResultSet resultSet = this.runQueryOnSqlConn(routableConnection.conn, string);
            return resultSet;
        }
        finally {
            this.lastProjUsed = projectionMetadata;
            this.lastNodeUsed = routableConnection.node;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet runQueryOnSqlConn(Connection connection, String string) throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            SQLWarning sQLWarning = statement.getWarnings();
            if (sQLWarning != null) {
                this.warnings.add(sQLWarning);
            }
            CachedRowSetImpl cachedRowSetImpl = new CachedRowSetImpl();
            cachedRowSetImpl.populate(resultSet);
            cachedRowSetImpl.setReadOnly(true);
            CachedRowSetImpl cachedRowSetImpl2 = cachedRowSetImpl;
            return cachedRowSetImpl2;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    private String rewriteQuery(String string, Map<String, Object> map, Set<String> set, List<OutputColumn> list, List<SortColumn> list2, ProjectionMetadata projectionMetadata, boolean bl) throws SQLException {
        Object object;
        HashSet<String> hashSet;
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
        long l = this.parentEpoch.get();
        if (l > -1L) {
            stringBuilder.append("at epoch ");
            stringBuilder.append(l);
            stringBuilder.append(" ");
        }
        stringBuilder.append(string, 0, 7);
        if (bl) {
            stringBuilder.append("/*+KV*/ ");
        }
        int n = string.indexOf("?");
        stringBuilder.append(string, 7, n);
        stringBuilder.append("(select ");
        boolean bl2 = true;
        for (ProjectionMetadata.ProjectionColumnMetadata iterator : projectionMetadata.getColumns()) {
            if (!bl2) {
                stringBuilder.append(",");
            } else {
                bl2 = false;
            }
            stringBuilder.append(Tokenizer.quoteIdentifier(iterator.nameInProj));
            if (!iterator.nameInTable.equals(iterator.nameInProj)) {
                stringBuilder.append(" as ");
                stringBuilder.append(Tokenizer.quoteIdentifier(iterator.nameInTable));
            }
            stringBuilder.append(" ");
        }
        if (this.metadata.isFlexTable()) {
            hashSet = new HashSet();
            for (OutputColumn outputColumn : list) {
                if (outputColumn.isExpr || projectionMetadata.getProjColName(outputColumn.colOrExpr) != null) continue;
                if (!bl2) {
                    stringBuilder.append(",");
                } else {
                    bl2 = false;
                }
                stringBuilder.append(Tokenizer.quoteIdentifier(outputColumn.colOrExpr));
                stringBuilder.append(" ");
                hashSet.add(outputColumn.colOrExpr);
            }
            for (SortColumn sortColumn : list2) {
                if (projectionMetadata.getProjColName(sortColumn.col) != null || hashSet.contains(sortColumn.col)) continue;
                if (!bl2) {
                    stringBuilder.append(",");
                } else {
                    bl2 = false;
                }
                stringBuilder.append(Tokenizer.quoteIdentifier(sortColumn.col));
                stringBuilder.append(" ");
                hashSet.add(sortColumn.col);
            }
        }
        stringBuilder.append("from ");
        if (!projectionMetadata.schema.equals("")) {
            stringBuilder.append(Tokenizer.quoteIdentifier(projectionMetadata.schema));
            stringBuilder.append(".");
        }
        stringBuilder.append(Tokenizer.quoteIdentifier(projectionMetadata.name));
        stringBuilder.append(" where ");
        hashSet = new HashSet<String>();
        hashSet.addAll(map.keySet());
        bl2 = true;
        for (ProjectionMetadata.ProjectionColumnMetadata projectionColumnMetadata : projectionMetadata.getSegmentationColumns()) {
            hashSet.remove(projectionColumnMetadata.nameInTable);
            object = map.get(projectionColumnMetadata.nameInTable);
            RoutableQuery.addPredicate(stringBuilder, bl2, projectionColumnMetadata.nameInProj, object, this.metadata.getColumnType(projectionColumnMetadata.nameInTable));
            bl2 = false;
        }
        for (String string2 : hashSet) {
            object = map.get(string2);
            RoutableQuery.addPredicate(stringBuilder, bl2, projectionMetadata.getProjColName(string2), object, this.metadata.getColumnType(string2));
            bl2 = false;
        }
        for (String string3 : set) {
            stringBuilder.append(bl2 ? "" : " AND ");
            stringBuilder.append(string3);
            bl2 = false;
        }
        stringBuilder.append(")");
        stringBuilder.append(string, n + 1, string.length());
        return stringBuilder.toString();
    }

    private static void addPredicate(StringBuilder stringBuilder, boolean bl, String string, Object object, int n) {
        if (!bl) {
            stringBuilder.append("AND ");
        }
        stringBuilder.append(Tokenizer.quoteIdentifier(string));
        if (object == null) {
            stringBuilder.append("<=>");
            stringBuilder.append("NULL");
        } else {
            stringBuilder.append("=");
            if (object instanceof Number) {
                stringBuilder.append(object.toString());
            } else if (object instanceof byte[]) {
                stringBuilder.append("hex_to_binary('0x");
                RoutableQuery.appendBytesAsHex((byte[])object, stringBuilder);
                stringBuilder.append("')");
            } else if (object instanceof Date) {
                RoutableQuery.appendDateTimeType(stringBuilder, (Date)object, Calendar.getInstance(), n);
            } else if (object instanceof Calendar) {
                Calendar calendar = (Calendar)object;
                RoutableQuery.appendDateTimeType(stringBuilder, calendar.getTime(), calendar, n);
            } else {
                stringBuilder.append("'");
                stringBuilder.append(object.toString());
                stringBuilder.append("'");
            }
        }
        stringBuilder.append(" ");
    }

    void close() throws SQLException {
    }

    private static void appendBytesAsHex(byte[] byArray, StringBuilder stringBuilder) {
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append(hex[(byArray[i] & 0xF0) >>> 4]);
            stringBuilder.append(hex[byArray[i] & 0xF]);
        }
    }

    private static void appendDateTimeType(StringBuilder stringBuilder, Date date, Calendar calendar, int n) {
        String string = n == 91 ? dateFormat : (n == 92 ? "HH:mm:ss.SSS" : "yyyy-MM-dd HH:mm:ss.SSSZ");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        stringBuilder.append("'");
        simpleDateFormat.setCalendar(calendar);
        stringBuilder.append(simpleDateFormat.format(date));
        stringBuilder.append("'");
    }

    public void checkTypeSupported(String string, Object object) throws SQLException {
        if (!this.metadata.isValuesTypeCompatible(string, object)) {
            int n = this.metadata.getColumnType(string);
            String string2 = null;
            try {
                string2 = n == 1111 ? "<UDType>" : TypeUtils.getTypeName(TypeUtils.getOIDFromSQLType(n), -1);
            }
            catch (ClientErrorException clientErrorException) {
                throw new RuntimeException(clientErrorException);
            }
            throw KVErrors.TypeNotSupported.makeException(object == null ? "<null>" : object.getClass().getName(), string2);
        }
    }

    boolean getFailOnMultiNodePlans() {
        return this.vConn.getFailOnMultiNodePlans();
    }
}

